/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "tuprequestparser.h"
// #include "tupprojectrequest.h"
#include "tuplibraryobject.h"
#include "tuprequestparserhandler.h"

TupRequestParser::TupRequestParser() : QObject()
{
    response = nullptr;
}

TupRequestParser::~TupRequestParser()
{
}

bool TupRequestParser::parse(const QString &xml)
{
    TupRequestParserHandler handler(xml);
    if (handler.parse()) {
        response = handler.getResponse();
        sign = handler.getSign();

        return true;
    }

    return false;
}

TupProjectResponse *TupRequestParser::getResponse() const
{
    return response;
}

QString TupRequestParser::getSign() const
{
    return sign;
}
