/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPPROJECTSCANNER_H 
#define TUPPROJECTSCANNER_H

#include "tglobal.h"
#include "tuplibraryobject.h"

#include <QObject>
#include <QDomNode>

class TUPITUBE_EXPORT TupProjectScanner : public QObject
{
    Q_OBJECT

    public:
        TupProjectScanner();
        ~TupProjectScanner();

        virtual bool read(const QString &filename, const QString &tempFolder = QString());

        QString getProjectName() const;
        float getProjectVersion();
        QColor getProjectBgColor() const;
        QSize getProjectDimension() const;
        int scenesCount();
        QList<QString> getSceneLabels();
        bool isLibraryEmpty();
        QString getProjectPath() const;
        QList<QString> getScenePaths();
        QList<bool> getSceneLibraryFlags();
        QList<QString> getSceneContents();
        void updateLibraryKey(int index, const QString &oldKey, const QString &key);

        struct LibraryObject {
            QString key;
            TupLibraryObject::ObjectType type;
            QString path;
        };

        struct Folder {
            QString key;
            QList<LibraryObject> objects;
            QList<Folder> folders;
        };
        Folder getLibrary();

    private:
        QString readSceneName(const QString &xml) const;
        Folder scanLibrary(QDomNode domNode);
        bool storeObject();

        QString projectName;
        float projectVersion;
        QColor bgColor;
        QSize dimension;
        QString projectPath;
        int scenesTotal;
        QList<QString> sceneLabels;
        QList<QString> scenePaths;
        QList<QString> sceneContents;
        QList<bool> libraryFlags;

        Folder library;
        int objectsTotal;

        bool scanObjects(const QString &folderId, const QString &xml);
        LibraryObject scanObject(QDomNode xml);
};

#endif
