/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "tupgraphiclibraryitem.h"
#include "tupserializer.h"
#include "tupitemgroup.h"

TupGraphicLibraryItem::TupGraphicLibraryItem() : TupProxyItem()
{
}

TupGraphicLibraryItem::TupGraphicLibraryItem(TupLibraryObject *object) : TupProxyItem()
{
    setObject(object);
    itemType = object->getObjectType();
}

TupGraphicLibraryItem::~TupGraphicLibraryItem()
{
}

TupLibraryObject::ObjectType TupGraphicLibraryItem::getItemType()
{
    return itemType;
}

QDomElement TupGraphicLibraryItem::toXml(QDomDocument &doc) const
{
    QDomElement library = doc.createElement("symbol");
    library.setAttribute("id", symbolName);
    library.appendChild(TupSerializer::properties(this, doc));
    
    return library;
}

void TupGraphicLibraryItem::fromXml(const QString &xml)
{
    Q_UNUSED(xml)
}

void TupGraphicLibraryItem::setObject(TupLibraryObject *object)
{
    if (!object) {
        #ifdef TUP_DEBUG
            qDebug() << "[TupGraphicLibraryItem::setObject()] - Fatal Error: Library object is NULL!";
        #endif
        return;
    }
    
    #ifdef TUP_DEBUG
        qWarning() << "[TupGraphicLibraryItem::setObject()] - object->symbolName() -> " << object->getSymbolName();
    #endif

    symbolName = object->getSymbolName();
    symbolPath = object->getDataPath();
    switch(object->getObjectType()) {
        case TupLibraryObject::Item:
        // case TupLibraryObject::Text:
        case TupLibraryObject::Image:
        {
             setItem(qvariant_cast<QGraphicsItem *>(object->getData()));
        }
        break;
        case TupLibraryObject::Svg:
        {
             setSvgContent(object->getDataPath());
        }
        break;
        default: 
        break;
    }
}

void TupGraphicLibraryItem::setSymbolName(const QString &name)
{
    symbolName = name;
}

QString TupGraphicLibraryItem::getSymbolName() const
{
    return symbolName;
}

void TupGraphicLibraryItem::setSvgContent(const QString &path)
{
    svgContent = path;
}

QString TupGraphicLibraryItem::getSvgContent()
{
   return svgContent;
}

QString TupGraphicLibraryItem::getSymbolPath() const
{
    return symbolPath;
}
