/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef CONFIGURATOR_H
#define CONFIGURATOR_H

#include "tglobal.h"

#include <QLabel>
#include <QComboBox>
#include <QSpinBox>
#include <QCheckBox>
#include <QDoubleSpinBox>
#include <QBoxLayout>
#include <QTextEdit>

/**
 * @author Gustav Gonzalez 
*/

class TUPITUBE_EXPORT Configurator : public QWidget
{
    Q_OBJECT

    public:
        enum Structure { Basic = 0, Axial, Organic };

        Configurator(QWidget *parent = nullptr);
        ~Configurator();
        int spacingValue();
        qreal sizeToleranceValue();
        bool runSimulation();
        double smoothness() const;
        Configurator::Structure structureType();

    signals:
        void updateSpacing(int value);
        void updateSizeTolerance(int value);

    private slots:
        void updateInterface(int state);

    private:
        QComboBox *structureCombo;
        QSpinBox *spacingBox;
        QSpinBox *sizeBox;
        QCheckBox *checkBox;
        QDoubleSpinBox *smoothBox;
};

#endif
