/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "tupprojectlistparser.h"

TupProjectListParser::TupProjectListParser() : TupXmlParserBase()
{
}

TupProjectListParser::~TupProjectListParser()
{
}

bool TupProjectListParser::startTag(const QString &tag, const QXmlAttributes &atts)
{
    if (root() == "server_projectlist") {
        if (tag == "works") {
            pivot = false;
        } else if (tag == "contributions") {
            pivot = true;
        } else if (tag == "project") {
            ProjectInfo info;
            info.file = atts.value("filename");
            info.name = atts.value("name");
            info.description = atts.value("description");
            info.date = atts.value("date");

            if (pivot) {
                info.author = atts.value("author");
                contribList << info;
            } else {
                worksList << info;
            }
        }
    }

    return true;
}

bool TupProjectListParser::endTag(const QString &tag)
{
    Q_UNUSED(tag);

    return true;
}

void TupProjectListParser::text(const QString &textStr)
{
    Q_UNUSED(textStr);
}

QList<TupProjectListParser::ProjectInfo> TupProjectListParser::works()
{
    return worksList;
}

QList<TupProjectListParser::ProjectInfo> TupProjectListParser::contributions()
{
    return contribList;
}

int TupProjectListParser::workSize()
{
    return worksList.count();
}

int TupProjectListParser::contributionSize()
{
    return contribList.count();
}
