/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "tupnetsocket.h"

TupNetSocket::TupNetSocket(TupNetProjectManagerHandler *handler) : TupSocketBase(handler), m_handler(handler)
{
}

TupNetSocket::~TupNetSocket()
{
}

void TupNetSocket::readed(const QString &readed)
{
    #ifdef TUP_DEBUG
        qWarning() << "TupNetSocket::readed() - PACKAGE ARRIVING: ";
        qWarning() << readed;
    #endif

    QDomDocument doc;
    
    if (doc.setContent(readed)) {
        QString root = doc.documentElement().tagName();
        m_handler->handlePackage(root, readed);
    } else {
        #ifdef TUP_DEBUG
            qDebug() << "TupNetSocket::readed() - Error: Package isn't a DOM document";
        #endif
    }
}
