QT += core gui widgets xml
CONFIG += dll warn_on

TEMPLATE = lib
TARGET = rastermain

HEADERS += rastercanvasbase.h \
          rastercanvas.h \
          rastermainwindow.h

SOURCES += rastercanvasbase.cpp \
          rastercanvas.cpp \
          rastermainwindow.cpp

INCLUDEPATH += ../../libmypaint
INCLUDEPATH += ../../qtmypaint

INCLUDEPATH += ../brushes
LIBS += -L../brushes -lrasterbrushes

INCLUDEPATH += ../size
LIBS += -L../size -lrastersize

INCLUDEPATH += ../color
LIBS += -L../color -lrastercolor

FRAMEWORK_DIR = "../../../framework"
include($$FRAMEWORK_DIR/framework.pri)

LIBCOLOR_DIR = "../../../libcolor"
include($$LIBCOLOR_DIR/libcolor.pri)

macx {
    INSTALLS += target
    target.path = /lib

    INSTALLS += brushes
    brushes.target = .
    brushes.commands = cp -r brushes $(INSTALL_ROOT)/themes/raster
    brushes.path = /themes/raster/brushes

    INSTALLS += resources
    resources.target = .
    resources.commands = cp -r resources $(INSTALL_ROOT)/themes/raster
    resources.path = /themes/raster/resources

    STORE_DIR = ../../../store
    INCLUDEPATH += $$STORE_DIR
    LIBS += -L$$STORE_DIR/ -ltupistore

    LIBBASE_DIR = ../../../libbase
    INCLUDEPATH += $$LIBBASE_DIR
    LIBS += -L$$LIBBASE_DIR/ -ltupibase

    LIBTUPI_DIR = ../../../libtupi
    INCLUDEPATH += $$LIBTUPI_DIR
    LIBS += -L$$LIBTUPI_DIR/ -ltupi

    LIBS += -L../../json-c -ljson-c
    LIBS += -L$$OUT_PWD/../../qtmypaint -lqtmypaint

    !include(../../../../global_variables.pri) {
        error("raster/main.pro: Run ./configure first!")
    }
}

unix:!mac {
    INSTALLS += target
    target.path = /lib/raster

    INSTALLS += brushes
    brushes.target = .
    brushes.commands = cp -r brushes $(INSTALL_ROOT)/themes/raster
    brushes.path = /themes/raster/brushes

    INSTALLS += resources
    resources.target = .
    resources.commands = cp -r resources $(INSTALL_ROOT)/themes/raster
    resources.path = /themes/raster/resources

    STORE_DIR = ../../../store
    INCLUDEPATH += $$STORE_DIR
    LIBS += -L$$STORE_DIR/ -ltupistore

    LIBBASE_DIR = ../../../libbase
    INCLUDEPATH += $$LIBBASE_DIR
    LIBS += -L$$LIBBASE_DIR/ -ltupibase

    LIBTUPI_DIR = ../../../libtupi
    INCLUDEPATH += $$LIBTUPI_DIR
    LIBS += -L$$LIBTUPI_DIR/ -ltupi

    defined(DEBIAN_OS, var) {
        LIBS += -L/usr/lib/x86_64-linux-gnu -ljson-c
    } else {
        LIBS += -L../../json-c -ljson-c
    }

    LIBS += -L$$OUT_PWD/../../qtmypaint/ -lqtmypaint
	
    !include(../../../../global_variables.pri) {
        error("raster/main.pro: Run ./configure first!")
    }
}

win32 {
    STORE_DIR = ../../../store
    INCLUDEPATH += $$STORE_DIR
    LIBS += -L$$STORE_DIR/release/ -ltupistore

    LIBBASE_DIR = ../../../libbase
    INCLUDEPATH += $$LIBBASE_DIR
    LIBS += -L$$LIBBASE_DIR/release/ -ltupibase

    LIBTUPI_DIR = ../../../libtupi
    INCLUDEPATH += $$LIBTUPI_DIR
    LIBS += -L$$LIBTUPI_DIR/release/ -ltupi
	
    LIBS += -L../../json-c/release/ -ljson-c
    LIBS += -L$$OUT_PWD/../../qtmypaint/release/ -lqtmypaint

    INCLUDEPATH += ../brushes
    LIBS += -L../brushes/release/ -lrasterbrushes

    INCLUDEPATH += ../color
    LIBS += -L../color/release/ -lrastercolor

    INCLUDEPATH += ../size
    LIBS += -L../size/release/ -lrastersize

    include(../../../../win.pri)
}
