/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TSEPARATOR_H
#define TSEPARATOR_H

#include "tglobal.h"

#include <QFrame>
#include <QStyleOption>
#include <QPainter>

/**
 * Standard horizontal or vertical separator.
 *
 * @author Michael Roth \<mroth@wirlweb.de\>
 */

class T_GUI_EXPORT TSeparator : public QFrame
{
    Q_OBJECT

    Q_PROPERTY(Qt::Orientation orientation READ orientation WRITE setOrientation);

    public:

    /**
     * Constructor.
     * @param parent parent object.
     * @param f extra QWidget flags.
     **/
    TSeparator(QWidget* parent=0);

    /**
     * Constructor.
     * @param orientation Set the orientation of the separator.
     * Possible values are Horizontal or Vertical.
     * @param parent parent object.
     * @param f extra QWidget flags.
     **/
    TSeparator(Qt::Orientation orientation, QWidget* parent=0);

    /**
     * Returns the orientation of the separator.
     * @return int Possible values Horizontal or Vertical.
     **/
     Qt::Orientation orientation() const;

    /**
     * Set the orientation of the separator to @p orientation
     *
     * @param orientation Possible values are Vertical and Horizontal.
     */
     void setOrientation(Qt::Orientation orientation);

    protected:
        virtual void virtual_hook(int id, void* data);

    private:
        class TSeparatorPrivate* k;
};

#endif // TSEPARATOR_H
