/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TOSD_H
#define TOSD_H

#include "tglobal.h"
#include "tapplicationproperties.h"

#include <QWidget>
#include <QPixmap>
#include <QPaintEvent>
#include <QTimer>
#include <QTextDocument>
#include <QApplication>
#include <QBitmap>
#include <QTimer>
#include <QPainter>
#include <QDesktopWidget>
#include <QLinearGradient>

class T_GUI_EXPORT TOsd : public QWidget
{
    Q_OBJECT

    private:
        TOsd(QWidget *parent = nullptr);

    public:
        enum Level
        {
           None = -1,
           Info,
           Warning,
           Error,
           Fatal
        };
        ~TOsd();
	
        void display(Level level=Info, const QString &message=QString(), int ms=-1);

        static TOsd *self();

    private slots:
        void animate();

    protected:
        void paintEvent(QPaintEvent *event);
        void mousePressEvent(QMouseEvent *event);

    private:
        QString htmlHeader(const QString &logo, const QString &imgWidth, const QString &fontSize) const;
        void drawPixmap(const QBrush &background, const QBrush &foreground);

        static TOsd *s_osd;
        QPixmap m_pixmap;
        QTimer *m_timer;
        QPalette m_palette; 

        struct Animation
        {
          QTimer timer;
          Level level;
          bool on;
        } *m_animator;

        QTextDocument *m_document;
        int uiTheme;
};

#endif
