/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "toolview.h"

ToolView::ToolView(const QString &title, const QIcon &icon, const QString &code, QWidget *parent):
                   QDockWidget(title, parent), currentPerspective(AnimationView)
{
    setFeatures(QDockWidget::NoDockWidgetFeatures);
    setWindowIcon(icon);

    currentButton = new TViewButton(this);
    currentButton->setToolTip(title);

    setObjectName("ToolView-" + code);
    expanded = false;
}

ToolView::~ToolView()
{
}

TViewButton *ToolView::button() const
{
    return currentButton;
}

void ToolView::expandDock()
{
    /*
    #ifdef TUP_DEBUG
        qDebug() << "[ToolView::expandDock()] - code ->" << objectName();
    #endif
    */

    expanded = true;
    show();
}

void ToolView::expandDock(bool state)
{
    /*
    #ifdef TUP_DEBUG
        qDebug() << "[ToolView::expandDock(bool)] - code ->" << objectName();
        qDebug() << "[ToolView::expandDock(bool)] - state ->" << state;
    #endif
    */

    expanded = state;
    if (state)
        show();
    else 
        close();
}

bool ToolView::isExpanded()
{
    /*
    #ifdef TUP_DEBUG
        qDebug() << "[ToolView::isExpanded()] - expanded ->" << expanded;
    #endif
    */

    return expanded;
}

void ToolView::setExpandingFlag() 
{
    /*
    #ifdef TUP_DEBUG
        qDebug() << "[ToolView::setExpandingFlag()]";
    #endif
    */

    if (expanded)
        expanded = false;
    else 
        expanded = true;
}

void ToolView::setShortcut(QKeySequence shortcut)
{
    currentButton->setShortcut(shortcut);
}

void ToolView::setPerspective(UIView tabType)
{
    currentPerspective = tabType;
}

UIView ToolView::perspective() const
{
    return currentPerspective;
}

void ToolView::enableButton(bool flag)
{
    currentButton->setEnabled(flag);
}
