/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TACTIONMANAGER_H
#define TACTIONMANAGER_H

#include "tglobal.h"
#include "taction.h"

#include <QMenu>
#include <QObject>
#include <QWidget>
#include <QList>
#include <QHash>
#include <QMenuBar>
#include <QToolBar>

typedef QList<QAction *> TActionList;
typedef QHash<QString, QAction *> TActionDict;
typedef QHash<QString, TActionDict> TActionContainer;

class QToolBar;
class QMenuBar;

class T_GUI_EXPORT TActionManager : public QObject
{
    Q_OBJECT

    public:
        TActionManager(QObject *parent = nullptr);
        ~TActionManager();

        bool insert(QAction *action, const QString &id, const QString &container = "default");
        void remove(QAction* action, const QString &container = QString());

        QAction *take(QAction* action, const QString &container = QString());
        QAction *find(const QString &id, const QString &container = QString()) const;
        QAction *operator[](const QString &id) const;
        void enable(const QString &id, bool flag);
        void exec(const QString &id);

        QMenuBar *setupMenuBar(QMenuBar *menu, const QStringList &containers, bool clear = true);
        QMenu *setupMenu(QMenu *menu, const QString &container, bool clear = true);
        QToolBar *setupToolBar(QToolBar *toolBar, const QString &container, bool clear = true);

    private:
        TActionContainer m_actionContainer;
};

#endif
