/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUIVALUES_H
#define TUIVALUES_H

#define HD_WIDTH 1920 // HD Width
#define HD_HEIGHT 1080 // HD Height

#define MAIN_TOPBAR_ICON_SIZE 22 // Main Top Toolbar
#define FIT_MAIN_TOPBAR_ICON_SIZE(screenWidth) ((screenWidth*2)/100)

#define TOPBAR_ICON_SIZE 16 // Tools Top Toolbar

#define PLUGIN_ICON_SIZE 16 // Lateral Toolbar
#define FIT_PLUGIN_ICON_SIZE(screenWidth) ((screenWidth*2)/100)

#define TOOLVIEW_ICON_SIZE 16 // Panel Icons
#define FIT_TOOLVIEW_ICON_SIZE(screenWidth) ((screenWidth*1.2)/100)

#define ACTIONBAR_ICON_SIZE 16 // Exposure Sheet, TimeLine Toolbars
#define FIT_ACTIONBAR_ICON_SIZE(screenWidth) ((screenWidth*0.8)/100)

#define STATUS_ICON_SIZE 16 // Paint Area Status Icon
#define FIT_STATUS_ICON_SIZE(screenWidth) ((screenWidth*1.4)/100)

#define STATUS_PANEL_WIDTH 700 // Paint Area Status Width
#define FIT_STATUS_PANEL_WIDTH(screenWidth) ((screenWidth*36.6)/100)

#define STATUS_PANEL_ICON_SIZE 18 // Paint Area Status Icon Size
#define FIT_STATUS_PANEL_ICON_SIZE(screenWidth) ((screenWidth*0.9)/100)

#define STATUS_PANEL_ROTATE_WIDTH 10 // Paint Area Status Rotate Icon Size
#define FIT_STATUS_PANEL_ROTATE_WIDTH(screenWidth) ((screenWidth*0.5)/100)

#define RIGHT_PANEL_ICON_SIZE 22 // Plugin Right Panel
#define FIT_RIGHT_PANEL_ICON_SIZE(screenWidth) ((screenWidth*1.2)/100)

#define RIGHT_PANEL_MIN_WIDTH 130 // Plugin Right Panel Min Width
#define FIT_RIGHT_PANEL_MIN_WIDTH(screenWidth) ((screenWidth*7)/100)

#define TWEENER_PANEL_MIN_WIDTH 230 // Tweener Right Panel Min Width
#define FIT_TWEENER_PANEL_MIN_WIDTH(screenWidth) ((screenWidth*12)/100)

#define NODES_PANEL_MIN_WIDTH 150 // Nodes Right Panel Min Width
#define FIT_NODES_PANEL_MIN_WIDTH(screenWidth) ((screenWidth*8)/100)

#define LIPSYNC_PANEL_MIN_WIDTH 220 // Lipsync Right Panel Min Width
#define FIT_LIPSYNC_PANEL_MIN_WIDTH(screenWidth) ((screenWidth*12)/100)

#define TEXT_PANEL_MIN_WIDTH 320 // Text Right Panel Min Width
#define FIT_TEXT_PANEL_MIN_WIDTH(screenWidth) ((screenWidth*17)/100)

#define PANEL_TITLE_ICON_SIZE 16 // Plugin Right Panel Title
#define FIT_TITLE_ICON_SIZE(screenWidth) ((screenWidth*0.8)/100)

#define MIN_COLORPALETTE_WIDTH 316 // Min Color Palette Width
#define FIT_MIN_COLORPALETTE_WIDTH(screenWidth) ((screenWidth*18)/100)

#define MAX_COLORPALETTE_WIDTH 470 // Max Color Palette Width

#define FIT_EXPOSURESHEET_WIDTH(screenWidth) ((screenWidth*11)/100)

#define SELECTION_PASTE_ICON_SIZE 15 // Selection Paste Icon
#define FIT_SELECTION_PASTE_ICON_SIZE(screenWidth) ((screenWidth*0.8)/100)

#define SELECTION_RESET_ICON_SIZE 18 // Selection Reset Icon
#define FIT_SELECTION_RESET_ICON_SIZE(screenWidth) ((screenWidth*0.95)/100)

#define EXPOSURE_VERTICAL_HEADER_WIDTH 25 // Exposure Sheet Numbers Column
#define FIT_EXPOSURE_VERTICAL_HEADER_WIDTH(screenWidth) ((screenWidth*1.3)/100)

#define EXPOSURE_ROW_WIDTH 70 // Exposure Sheet Row Width
#define FIT_EXPOSURE_ROW_WIDTH(screenWidth) ((screenWidth*3.6)/100)

#define EXPOSURE_ROW_HEIGHT 20 // Exposure Sheet Row Height
#define FIT_EXPOSURE_ROW_HEIGHT(screenWidth) (screenWidth/100)

#define SMALL_ICON_SIZE 12 // Smaller icons
#define FIT_SMALL_ICON_SIZE(screenWidth) ((screenWidth*0.6)/100)

#define PLAYER_BUTTON_SIZE 33 // Player Buttons
#define FIT_PLAYER_BUTTON_SIZE(screenWidth) ((screenWidth*1.7)/100)

#define SMALL_PLAYER_BUTTON_SIZE 25 // Small Player Buttons
#define FIT_SMALL_PLAYER_BUTTON_SIZE(screenWidth) ((screenWidth*1.3)/100)

#define TITLE_FONT_SIZE 12 // Title Message Font Size
#define FIT_TITLE_FONT_SIZE(screenWidth) ((screenWidth*0.9)/100)

#define MSG_FONT_SIZE 11 // Info Message Font Size
#define FIT_MSG_FONT_SIZE(screenWidth) ((screenWidth*0.8)/100)

#define INFO_ICON_SIZE 10 // Info Icon Size
#define FIT_INFO_ICON_SIZE(screenWidth) ((screenWidth*0.8)/100)

#define MSG_ICON_SIZE 20 // Msg Icon Size
#define FIT_MSG_ICON_SIZE(screenWidth) ((screenWidth*1.3)/100)

#endif
