/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPTOOLSDIALOG_H
#define TUPTOOLSDIALOG_H 

#include "tglobal.h"
#include "tapplicationproperties.h"
#include "tuptoolplugin.h"
#include "timagebutton.h"

#include <QDialog>
#include <QList>
#include <QHBoxLayout>
#include <QPixmap>

class TUPITUBE_EXPORT TupToolsDialog : public QDialog 
{
    Q_OBJECT

    public:
        TupToolsDialog(QList<QString> tools, QWidget *parent);
        ~TupToolsDialog();

    signals:
        void callAction(int menu, int index);
        void isClosed();
        void openColorDialog();
        void openPenDialog();
        void openOpacityDialog();

    private slots:
        void wakeUpPencil();
        void wakeUpInk();
        void wakeUpEllipse();
        void wakeUpRectangle();
        void wakeUpPolyline();
        void wakeUpObjectSelection();
        void wakeUpNodeSelection();

    private:
        void setToolsPanel(QList<QString> tools);

        QHBoxLayout *layout;
};

#endif
