/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "tupmodeslist.h"
#include "tconfig.h"
#include "tapplicationproperties.h"

#include <QItemDelegate>
#include <QPainter>

class TupListItemDelegate: public QItemDelegate
{
    public:
        TupListItemDelegate(QObject *parent = nullptr);
        ~TupListItemDelegate();

        virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
        virtual QSize sizeHint(const QStyleOptionViewItem & option, const QModelIndex &index) const;
};

TupListItemDelegate::TupListItemDelegate(QObject *parent): QItemDelegate(parent)
{
}

TupListItemDelegate::~TupListItemDelegate()
{
}

QSize TupListItemDelegate::sizeHint(const QStyleOptionViewItem & option, const QModelIndex &index) const
{
    Q_UNUSED(option);
    Q_UNUSED(index);

    return QSize(100, 40);
}

void TupListItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    Q_ASSERT(index.isValid());

    QItemDelegate::paint(painter, option, index);
}

////////// TupListItem ////////

TupListItem::TupListItem()
{
}

TupListItem::~TupListItem()
{
}

TupModesList::TupModesList(QWidget *parent): QListWidget(parent)
{
    setItemDelegate(new TupListItemDelegate(this));
    setDragDropMode(QAbstractItemView::InternalMove);
}

TupModesList::~TupModesList()
{
}

void TupModesList::dropEvent(QDropEvent* event)
{
    QListWidget::dropEvent(event);
    emit listEdited();
}
