/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPLIBRARYDIALOG_H
#define TUPLIBRARYDIALOG_H

#include "tglobal.h"
#include "tupitempreview.h"
#include "tapplicationproperties.h"
#include "tuplibrary.h"

#include <QDialog>
#include <QToolBox>
#include <QGraphicsItem>
#include <QLineEdit>
#include <QMap>

class TUPITUBE_EXPORT TupLibraryDialog : public QDialog
{
    Q_OBJECT

    public:
        TupLibraryDialog(TupLibrary *library);
        ~TupLibraryDialog();

        void addItem(QGraphicsItem *item);
        QString symbolName(QGraphicsItem *item) const;

    private slots:
        void checkNames();

    private:
        QToolBox *toolBox;
        QMap<QGraphicsItem *, QLineEdit *> symbolNames;
        QMap<int, QLineEdit *> tabs;
        TupLibrary *library;
};

#endif
