/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "tupcamerabar.h"
#include "tapplicationproperties.h"
#include "tresponsiveui.h"

#include <QBoxLayout>

TupCameraBar::TupCameraBar(QWidget *parent) : QFrame(parent)
{
    #ifdef TUP_DEBUG
        qDebug() << "[TupCameraBar()]";
    #endif

    setFrameStyle(QFrame::StyledPanel | QFrame::Raised);
    setMidLineWidth(2);
    setLineWidth(1);

    QBoxLayout *mainLayout = new QBoxLayout(QBoxLayout::LeftToRight, parent);
    mainLayout->addStretch(1);

    mainLayout->setSpacing(10);
    mainLayout->setMargin(3);

    int smallButtonSize = TResponsiveUI::fitSmallPlayerButtonSize();
    int buttonSize = TResponsiveUI::fitPlayerButtonSize();

    rewindButton = new TImageButton(QPixmap(ICONS_DIR + "rw.png"), buttonSize, this, true);
    rewindButton->setToolTip(tr("Rewind"));
    mainLayout->addWidget(rewindButton);
    connect(rewindButton, SIGNAL(clicked()), this, SIGNAL(rew()));

    playBackButton = new TImageButton(QPixmap(ICONS_DIR + "play_back.png"), smallButtonSize, this, true);
    playBackButton->setToolTip(tr("Play in reverse"));
    mainLayout->addWidget(playBackButton);
    connect(playBackButton, SIGNAL(clicked()), this, SIGNAL(playBack()));

    playButton = new TImageButton(QPixmap(ICONS_DIR + "play.png"), buttonSize, this, true);
    playButton->setToolTip(tr("Play"));
    mainLayout->addWidget(playButton);
    connect(playButton, SIGNAL(clicked()), this, SIGNAL(play()));

    pauseButton = new TImageButton(QPixmap(ICONS_DIR + "pause.png"), smallButtonSize, this, true);
    pauseButton->setToolTip(tr("Pause"));
    mainLayout->addWidget(pauseButton);
    connect(pauseButton, SIGNAL(clicked()), this, SIGNAL(pause()));

    stopButton = new TImageButton(QPixmap(ICONS_DIR + "stop.png"), smallButtonSize, this, true);
    stopButton->setToolTip(tr("Stop"));
    mainLayout->addWidget(stopButton);
    connect(stopButton, SIGNAL(clicked()), this, SIGNAL(stop()));

    ffButton = new TImageButton(QPixmap(ICONS_DIR + "ff.png"), buttonSize, this, true);
    ffButton->setToolTip(tr("Forward"));
    mainLayout->addWidget(ffButton);
    connect(ffButton, SIGNAL(clicked()), this, SIGNAL(ff()));

    setLayout(mainLayout);
}

TupCameraBar::~TupCameraBar()
{
    #ifdef TUP_DEBUG
        qDebug() << "[~TupCameraBar()]";
    #endif
}

void TupCameraBar::updatePlayButton(bool playOn)
{
    #ifdef TUP_DEBUG
        qDebug() << "[TupCameraBar::updatePlayButton()] - playOn ->" << playOn;
    #endif

    QString pic = "";
    if (playOn)
        pic = "_on";

    playButton->setIcon(QPixmap(ICONS_DIR + "play" + pic + ".png"));
}

void TupCameraBar::updatePlaybackButton(bool playOn)
{
    QString pic = "";
    if (playOn)
        pic = "_on";

    playBackButton->setIcon(QPixmap(ICONS_DIR + "play_back" + pic + ".png"));
}
