/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPVIDEOIMPORTERDIALOG_H
#define TUPVIDEOIMPORTERDIALOG_H 

#include "tglobal.h"
#include "tapplicationproperties.h"
#include "tupvideocutter.h"

#include <QDialog>
#include <QVBoxLayout>
#include <QLabel>
#include <QSpinBox>
#include <QProgressBar>
#include <QGroupBox>
#include <QRadioButton>
#include <QCheckBox>

class TUPITUBE_EXPORT TupVideoImporterDialog : public QDialog 
{
    Q_OBJECT

    public:
        TupVideoImporterDialog(const QString &filename, const QString &photogramsPath, const QSize &projectSize,
                               TupVideoCutter *cutter, QWidget *parent = nullptr);
        ~TupVideoImporterDialog();

        int getPhotogramsTotal();

    signals:
        void imageExtractionIsDone(ImageImportAction action, const QString &imagesPath, bool sizeFlag);
        void audioExtractionIsDone(const QString &audioPath);
        void projectSizeHasChanged(const QSize dimension);

    public slots:
        void endProcedure();

    private slots:
        void startMediaExtraction();
        void updateStatusFromLibraryWidget(const QString &);
        void updateMediaProgress(MediaType media, int index);
        void startImageImportation();

    private:
        void setDialogUI(bool fixSize);

        QVBoxLayout *layout;
        QSpinBox *imagesBox;
        QWidget *progressWidget;
        QLabel *progressLabel;
        QProgressBar *progressBar;

        QWidget *buttonsWidget;

        TupVideoCutter *videoCutter;
        QString videoPath;
        QString assetsPath;
        QString audioPath;
        int framesTotal;
        int framesCounter;
        QSize projectSize;
        QSize videoSize;

        bool fixSize;
        bool sizeFlag;
        QGroupBox *groupBox;
        QRadioButton *checkButton1;
        QRadioButton *checkButton2;
        QRadioButton *checkButton3;
        QCheckBox *audioCheck;
};

#endif
