/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPSOUNDFORM_H
#define TUPSOUNDFORM_H

#include "tglobal.h"
#include "timagebutton.h"
#include "tapplicationproperties.h"
#include "tuplibraryobject.h"

#include <QWidget>
#include <QLabel>
#include <QSpinBox>
#include <QComboBox>
#include <QListWidget>

/**
 * @author Gustav Gonzalez
**/

class TUPITUBE_EXPORT TupSoundForm : public QWidget
{
    Q_OBJECT

    public:
        TupSoundForm(QWidget *parent = nullptr);
        ~TupSoundForm();

        QSize sizeHint() const;
        void setSoundParams(SoundResource params, QStringList scenesList, QList<int> frameLimits);
        void updateFrameLimit(int sceneIndex, int framesCount);

    signals:
        void soundResourceModified(SoundResource params);

    public slots:
        void updateFramesList(int index);
        void addFrame();
        void removeFrame();

    private:
        void loadScenesCombo(QStringList scenes);
        void setFramesLimit(int sceneIndex, int framesCount);
        void populateFramesList(int sceneIndex);

        QComboBox *scenesCombo;
        QLabel *playAtLabel;
        QListWidget *framesListWidget;
        QWidget *buttonBar;
        QSpinBox *framesBox;
        TImageButton *addFrameButton;
        TImageButton *removeFrameButton;

        SoundResource soundParams;
        int currentSceneIndex;
        QString bgTrackLabel;

        QList<int> framesMaxList;
        bool bgTrackEnabled;
};

#endif
