/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPITEMMANAGER_H
#define TUPITEMMANAGER_H

#include "tglobal.h"
#include "tuptreedelegate.h"
#include "treelistwidget.h"
#include "tapplicationproperties.h"

#include <QKeyEvent>
#include <QHeaderView>
#include <QMenu>
#include <QMimeData>
#include <QDrag>

class TUPITUBE_EXPORT TupItemManager : public TreeListWidget
{
    Q_OBJECT

    public:
        TupItemManager(QWidget *parent = nullptr);
        ~TupItemManager();

        QTreeWidgetItem *currentFolder();
        void setCurrentFolder(QTreeWidgetItem *cf);
        void removeCurrentFolder();
        void mousePressEvent(QMouseEvent *event);
        void mouseDoubleClickEvent(QMouseEvent *event);
        bool isFolder(QTreeWidgetItem *item);
        int indexOf(QTreeWidgetItem *item);
        QString oldFolder();
        QTreeWidgetItem *getFolder(const QString &folderName);
        void cleanUI();
        int itemType();

        enum ObjectType 
        {
            Item = 0,
            Folder
        };

    signals:
        void itemSelected(QTreeWidgetItem *item);
        void itemRemoved();
        void itemRenamed(QTreeWidgetItem *item);
        void itemCloned(QTreeWidgetItem *item);
        void itemExported(QTreeWidgetItem *item);
        void itemRequired();
        void itemMoved(QString node, QString target);
        void itemCreated(QTreeWidgetItem *item);
        void inkscapeEditCall(QTreeWidgetItem *item);
        void gimpEditCall(QTreeWidgetItem *item);
        void kritaEditCall(QTreeWidgetItem *item);
        void myPaintEditCall(QTreeWidgetItem *item);
        void lipSyncCall(QTreeWidgetItem *item);
        void newRasterCall();
        void newVectorCall();

    public slots:
        void createFolder(const QString &name = QString());

    private slots:
        void renameItem();
        void cloneItem();
        void exportItem();
        void callInkscapeToEdit();
        void callGimpToEdit();
        void callKritaToEdit();
        void callMyPaintToEdit();
        void createNewRaster();
        void createNewSVG();
        void callLipSync();

    protected:
        void dropEvent(QDropEvent *event);
        void dragEnterEvent(QDragEnterEvent *event);
        void dragMoveEvent(QDragMoveEvent *event);
        void keyPressEvent(QKeyEvent *event);

    private:
        QTreeWidgetItem *m_currentFolder;
        int foldersTotal;
        QString folderName; 
        QString parentNode;
        QString currentSelection;
        QList<QTreeWidgetItem *> nodeChildren;
};

#endif
