/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPSCENESELECTOR_H
#define TUPSCENESELECTOR_H

#include "tglobal.h"
#include "tupexportinterface.h"
#include "tupexportwizard.h"
#include "titemselector.h"

class TUPITUBE_EXPORT TupSceneSelector : public TupExportWizardPage
{
    Q_OBJECT

    public:
        TupSceneSelector();
        ~TupSceneSelector();

        bool isComplete() const;
        void resetUI();

        void setScenes(const QList<TupScene *> &scenes, int fps);
        void aboutToNextPage();

        void setFormatType(ExportOutputFormat exportFormat);
        void setDurationLabelVisible(bool visible);

    private slots:
        void updateState();
        void updateScenesList();

    signals:
        void selectedScenes(const QList<int> &scenes);

    private:
        ExportOutputFormat format;
        TItemSelector *m_selector;
        QList<TupScene *> scenes;
        QList<double> sceneDuration;
        double duration;
};

#endif
