/***************************************************************************
 *   Project TupiTube Desk                                                 *
 *   Project Contact: info@tupitube.com                                    *
 *   Project Website: http://www.tupitube.com                              * 
 *                                                                         *
 *   Developers:                                                           *
 *   2025:                                                                 *
 *    Utopian Lab Development Team                                         *
 *   2010:                                                                 *
 *    Gustav Gonzalez                                                      *
 *   ---                                                                   *
 *   KTooN's versions:                                                     *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef TUPEXPORTWIDGET_H
#define TUPEXPORTWIDGET_H

#include "tglobal.h"
#include "tupproject.h"
#include "tupexportwizard.h"
#include "tuppluginmanager.h"
#include "tosd.h"

#include "tuppluginselector.h"
#include "tupsceneselector.h"
#include "tupexportmodule.h"
#include "tupvideoproperties.h"

class TUPITUBE_EXPORT TupExportWidget : public TupExportWizard
{
    Q_OBJECT

    public:
        enum ExportType { Local, Scene, Frame };
        TupExportWidget(TupProject *project, QWidget *parent = nullptr, ExportType type = Local);
        ~TupExportWidget();

        void setProjectParams(const QString &username, const QString &secret, const QString &path);
        QString videoTitle() const;
        QString videoTopics() const;
        QString videoDescription() const;
        QList<int> videoScenes() const;
        bool isComplete();

    private slots:
        void setExporter(TupExportInterface::Plugin plugin);
        void updateWindowTitle();
        void updateWidgetConnections();

    private:
        void loadPlugins();
		
    private:
        TupExportInterface::Plugin currentPlugin;

        TupPluginSelector *pluginPage;
        TupSceneSelector *scenesPage;
        TupExportModule *animationExport;
        TupExportModule *imagesArrayExport;

        // SQA: Code temporary disabled
        // TupExportModule *animatedImageExport;

        TupVideoProperties *videoProperties;
        const TupProject *project;
        QHash<TupExportInterface::Plugin, TupExportInterface *> plugins;
        ExportType exportFlag;
};

#endif
