/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.KeypadGraphics;
import edsim51di.PeripheralMainPanel;
import edsim51di.Switch;
import edsim51di.SwitchBank;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;

class SwitchBankGraphics
extends PeripheralMainPanel
implements MouseListener {
    private Switch[] switches = new Switch[8];
    private Board board;

    SwitchBankGraphics(Board board, SwitchBank switchBank, KeypadGraphics keypad) {
        this.board = board;
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.BLACK);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        for (int i = 0; i < this.switches.length; ++i) {
            String s = board.getHardwareSetting("switch" + i + ":label");
            if (s == null) {
                s = String.valueOf(i);
            }
            this.switches[i] = new Switch(board, i, switchBank.dataLineMappings[i].portNumber, switchBank.dataLineMappings[i].pinNumber, s, keypad);
            this.switches[i].addMouseListener(this);
            gbc.gridx = this.switches.length - 1 - i;
            this.add((Component)this.switches[i], gbc);
        }
    }

    @Override
    void setSize(boolean small) {
        int size = small ? 12 : 18;
        for (int i = 0; i < this.switches.length; ++i) {
            this.switches[i].setSize(this.switches[i].getText(), "    ", 1, size);
        }
    }

    Switch getSwitch(int switchNumber) {
        return this.switches[switchNumber];
    }

    void reset() {
        for (int i = 0; i < this.switches.length; ++i) {
            this.switches[i].open();
        }
    }

    private void renameKey(Switch sw) {
        String newLabel = JOptionPane.showInputDialog(sw, "Switch labels can only be\none character long.\n\nCurrent Label: " + sw.getText(), "Change Switch Label", 3);
        if (newLabel == null) {
            return;
        }
        if (!(newLabel = String.valueOf(newLabel.charAt(0))).equals("")) {
            sw.setText(newLabel);
            this.board.setHardwareSetting("switch" + sw.getSwitchNumber() + ":label", newLabel);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        boolean rightClick = (event.getModifiers() & 4) == 4;
        Switch sw = (Switch)event.getSource();
        if (rightClick) {
            this.renameKey(sw);
        } else {
            for (int i = 0; i < 5; ++i) {
                sw.toggle();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

