/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Gui;
import edsim51di.color.LEDPreview;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;

public class LED
extends JButton
implements ActionListener {
    private Dimension sizeSmall;
    private Dimension sizeLarge;
    private Dimension size;
    private Color onColor;
    private Color currentColor = Color.WHITE;
    private JColorChooser colorChooser = new JColorChooser();
    private JDialog dialog;

    LED(Color onColor, int ledNumber) {
        this.onColor = onColor;
        this.sizeSmall = new Dimension(10, 10);
        this.sizeLarge = new Dimension(15, 15);
        this.setToolTipText("LED " + ledNumber + " | click to change on colour");
        this.setBackground(Color.WHITE);
        this.colorChooser.setColor(onColor);
        this.colorChooser.setPreviewPanel(new LEDPreview(this.colorChooser));
        this.dialog = JColorChooser.createDialog(this, "Pick a colour for this LED " + ledNumber, false, this.colorChooser, this, null);
        this.addActionListener(this);
    }

    void turnOn(boolean b) {
        this.currentColor = b ? this.onColor : Color.WHITE;
    }

    void setSize(boolean small) {
        this.size = small ? this.sizeSmall : this.sizeLarge;
        Gui.setSize(this, this.size);
    }

    void updateGraphics() {
        this.setBackground(this.currentColor);
    }

    public void setColor(Color c) {
        this.onColor = c;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this) {
            this.dialog.setVisible(true);
            return;
        }
        this.onColor = this.colorChooser.getColor();
        if (this.currentColor.getRGB() != Color.WHITE.getRGB()) {
            this.setBackground(this.onColor);
        }
    }
}

