/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.rag.store;

import cc.unitmesh.cf.core.utils.IdUtil;
import cc.unitmesh.nlp.similarity.JaccardSimilarity;
import cc.unitmesh.nlp.similarity.RelevanceScore;
import cc.unitmesh.rag.store.EmbeddingMatch;
import cc.unitmesh.rag.store.EmbeddingStore;
import cc.unitmesh.rag.store.Entry;
import cc.unitmesh.rag.store.InMemoryEnglishTextStore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fH\u0016J'\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\"\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fH\u0016J1\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0011J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0016\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\nH\u0016J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0016\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J6\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\n2\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcc/unitmesh/rag/store/InMemoryEnglishTextStore;", "Embedded", "Lcc/unitmesh/rag/store/EmbeddingStore;", "()V", "entries", "", "Lcc/unitmesh/rag/store/Entry;", "add", "", "embedding", "", "", "Lcc/unitmesh/nlp/embedding/Embedding;", "embedded", "(Ljava/util/List;Ljava/lang/Object;)Ljava/lang/String;", "", "id", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Object;)V", "addAll", "embeddings", "findRelevant", "Lcc/unitmesh/rag/store/EmbeddingMatch;", "referenceEmbedding", "maxResults", "", "minScore", "cocoa-core"})
@SourceDebugExtension(value={"SMAP\nInMemoryEnglishTextStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryEnglishTextStore.kt\ncc/unitmesh/rag/store/InMemoryEnglishTextStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class InMemoryEnglishTextStore<Embedded>
implements EmbeddingStore<Embedded> {
    @NotNull
    private final List<Entry<Embedded>> entries = new ArrayList();

    @Override
    @NotNull
    public String add(@NotNull List<Double> embedding) {
        Intrinsics.checkNotNullParameter(embedding, (String)"embedding");
        String id = IdUtil.INSTANCE.uuid();
        this.add(id, embedding);
        return id;
    }

    @Override
    public void add(@NotNull String id, @NotNull List<Double> embedding) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(embedding, (String)"embedding");
        this.add(id, embedding, null);
    }

    @Override
    @NotNull
    public String add(@NotNull List<Double> embedding, Embedded embedded) {
        Intrinsics.checkNotNullParameter(embedding, (String)"embedding");
        String id = IdUtil.INSTANCE.uuid();
        this.add(id, embedding, embedded);
        return id;
    }

    private final void add(String id, List<Double> embedding, Embedded embedded) {
        this.entries.add(new Entry<Embedded>(id, embedding, embedded));
    }

    @Override
    @NotNull
    public List<String> addAll(@NotNull List<? extends List<Double>> embeddings) {
        Intrinsics.checkNotNullParameter(embeddings, (String)"embeddings");
        List ids = new ArrayList();
        for (List<Double> list : embeddings) {
            ids.add(this.add(list));
        }
        return ids;
    }

    @Override
    @NotNull
    public List<String> addAll(@NotNull List<? extends List<Double>> embeddings, @NotNull List<? extends Embedded> embedded) {
        Intrinsics.checkNotNullParameter(embeddings, (String)"embeddings");
        Intrinsics.checkNotNullParameter(embedded, (String)"embedded");
        if (!(embeddings.size() == embedded.size())) {
            boolean $i$a$-require-InMemoryEnglishTextStore$addAll$22 = false;
            String $i$a$-require-InMemoryEnglishTextStore$addAll$22 = "The list of embeddings and embedded must have the same size";
            throw new IllegalArgumentException($i$a$-require-InMemoryEnglishTextStore$addAll$22.toString());
        }
        List ids = new ArrayList();
        int n = embeddings.size();
        for (int i = 0; i < n; ++i) {
            ids.add(this.add(embeddings.get(i), embedded.get(i)));
        }
        return ids;
    }

    @Override
    @NotNull
    public List<EmbeddingMatch<Embedded>> findRelevant(@NotNull List<Double> referenceEmbedding, int maxResults, double minScore) {
        Intrinsics.checkNotNullParameter(referenceEmbedding, (String)"referenceEmbedding");
        Comparator<Object> comparator2 = Comparator.comparingDouble(arg_0 -> InMemoryEnglishTextStore.findRelevant$lambda$1((Function1)findRelevant.comparator.1.INSTANCE, arg_0));
        PriorityQueue<Object> matches = new PriorityQueue<Object>(comparator2);
        for (Entry<Embedded> entry : this.entries) {
            double cosineSimilarity = JaccardSimilarity.Companion.between(entry.getEmbedding(), referenceEmbedding);
            double score = RelevanceScore.INSTANCE.fromCosineSimilarity(cosineSimilarity);
            if (!(score >= minScore)) continue;
            String string = entry.getId();
            List<Double> list = entry.getEmbedding();
            Embedded Embedded = entry.getEmbedded();
            Intrinsics.checkNotNull(Embedded);
            matches.add(new EmbeddingMatch<Embedded>(score, string, list, Embedded));
            if (matches.size() <= maxResults) continue;
            matches.poll();
        }
        ArrayList result = new ArrayList(matches);
        List list = result;
        Intrinsics.checkNotNull(comparator2);
        CollectionsKt.sortWith((List)list, comparator2);
        CollectionsKt.reverse((List)result);
        return result;
    }

    private static final double findRelevant$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }
}

