/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.terminal.sketch;

import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcc/unitmesh/terminal/sketch/ResizableTerminalPanel;", "Ljavax/swing/JPanel;", "terminalWidget", "Lcom/intellij/terminal/JBTerminalWidget;", "<init>", "(Lcom/intellij/terminal/JBTerminalWidget;)V", "minHeight", "", "maxHeight", "startY", "startHeight", "ext-terminal"})
public final class ResizableTerminalPanel
extends JPanel {
    private final int minHeight;
    private final int maxHeight;
    private int startY;
    private int startHeight;

    public ResizableTerminalPanel(@NotNull JBTerminalWidget terminalWidget) {
        JLabel jLabel;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
        super(new BorderLayout());
        this.minHeight = 48;
        this.maxHeight = 600;
        this.add((Component)terminalWidget.getComponent(), "Center");
        JPanel $this$_init__u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$_init__u24lambda_u240.setPreferredSize(new Dimension(Integer.MAX_VALUE, 5));
        $this$_init__u24lambda_u240.setBackground(UIUtil.getPanelBackground());
        $this$_init__u24lambda_u240.setCursor(Cursor.getPredefinedCursor(9));
        JPanel dragHandle = jPanel;
        JLabel $this$_init__u24lambda_u241 = jLabel = new JLabel("\u2261", 0);
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setForeground((Color)JBColor.GRAY);
        JLabel dragIndicator = jLabel;
        dragHandle.add(dragIndicator);
        this.add((Component)dragHandle, "South");
        dragHandle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                startY = e.getY();
                startHeight = this.getPreferredSize().height;
            }
        });
        dragHandle.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int newHeight = startHeight + e.getY() - startY;
                int n = minHeight;
                boolean bl = newHeight <= maxHeight ? n <= newHeight : false;
                if (bl) {
                    this.setPreferredSize(new Dimension(this.getPreferredSize().width, newHeight));
                    this.revalidate();
                    this.repaint();
                }
            }
        });
    }
}

