/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.python.provider;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"buildAndInsert", "Lcom/jetbrains/python/psi/PyDocStringOwner;", "replacementText", "", "anchor", "pycharm"})
public final class PythonLivingDocumentationKt {
    @NotNull
    public static final PyDocStringOwner buildAndInsert(@NotNull String replacementText, @NotNull PyDocStringOwner anchor) {
        Intrinsics.checkNotNullParameter((Object)replacementText, (String)"replacementText");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance((Project)anchor.getProject());
        PyExpressionStatement replacement = elementGenerator.createDocstring(replacementText);
        PyStringLiteralExpression docStringExpression = anchor.getDocStringExpression();
        if (docStringExpression != null) {
            docStringExpression.replace((PsiElement)replacement.getExpression());
            return anchor;
        }
        PyStatementListContainer pyStatementListContainer = (PyStatementListContainer)PyUtil.as((Object)anchor, PyStatementListContainer.class);
        if (pyStatementListContainer == null) {
            throw new IncorrectOperationException("Cannot find container for docstring, Should be a function or class");
        }
        PyStatementListContainer container = pyStatementListContainer;
        PyStatementList pyStatementList = container.getStatementList();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementList, (String)"getStatementList(...)");
        PyStatementList statements = pyStatementList;
        String string = PyIndentUtil.getElementIndent((PsiElement)((PsiElement)statements));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementIndent(...)");
        String indentation = string;
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)anchor.getProject());
        Document document = manager.getDocument(anchor.getContainingFile());
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        PsiElement beforeStatements = statements.getPrevSibling();
        Object replacementWithLineBreaks = StringsKt.trimIndent((String)(indentation + replacementText));
        PyStatement[] pyStatementArray = statements.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)pyStatementArray, (String)"getStatements(...)");
        if (!(((Object[])pyStatementArray).length == 0)) {
            replacementWithLineBreaks = (String)replacementWithLineBreaks + StringsKt.trimIndent((String)indentation);
        }
        TextRange range = beforeStatements.getTextRange();
        if (!(beforeStatements instanceof PsiWhiteSpace)) {
            document2.insertString(range.getEndOffset(), (CharSequence)replacementWithLineBreaks);
        } else {
            PyStatement[] pyStatementArray2 = statements.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)pyStatementArray2, (String)"getStatements(...)");
            if (((Object[])pyStatementArray2).length == 0 && ((PsiWhiteSpace)beforeStatements).textContains('\n')) {
                document2.insertString(range.getStartOffset(), (CharSequence)replacementWithLineBreaks);
            } else {
                document2.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacementWithLineBreaks);
            }
        }
        return anchor;
    }
}

