/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.python.provider;

import cc.unitmesh.devti.context.ClassContext;
import cc.unitmesh.devti.provider.AutoTestService;
import cc.unitmesh.devti.provider.context.TestFileContext;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfigurationProducer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006#"}, d2={"Lcc/unitmesh/python/provider/PythonAutoTestService;", "Lcc/unitmesh/devti/provider/AutoTestService;", "<init>", "()V", "isApplicable", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/execution/configurations/RunProfile;", "createConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "virtualFile", "getElementForTests", "editor", "Lcom/intellij/openapi/editor/Editor;", "findOrCreateTestFile", "Lcc/unitmesh/devti/provider/context/TestFileContext;", "sourceFile", "Lcom/intellij/psi/PsiFile;", "psiElement", "getTestNameExample", "", "getTestsDirectory", "toTestFileName", "testFileName", "exampleName", "lookupRelevantClass", "", "Lcc/unitmesh/devti/context/ClassContext;", "pycharm"})
public final class PythonAutoTestService
extends AutoTestService {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)element.getLanguage().getDisplayName(), (Object)"Python");
    }

    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getExtension(), (Object)"py");
    }

    @Override
    @NotNull
    public Class<? extends RunProfile> runConfigurationClass(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PythonRunConfiguration.class;
    }

    @Override
    @Nullable
    public RunConfiguration createConfiguration(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile);
        PyFile pyFile = psiFile2 instanceof PyFile ? (PyFile)psiFile2 : null;
        if (pyFile == null) {
            return null;
        }
        PyFile psiFile3 = pyFile;
        RunManager runManager = RunManager.Companion.getInstance(project);
        ConfigurationContext context = new ConfigurationContext((PsiElement)psiFile3);
        Object object = ActionsKt.runReadAction(PythonAutoTestService::createConfiguration$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        PythonRunConfigurationProducer configProducer = (PythonRunConfigurationProducer)object;
        RunnerAndConfigurationSettings settings = configProducer.findExistingConfiguration(context);
        if (settings == null) {
            ConfigurationFromContext configurationFromContext = configProducer.createConfigurationFromContext(context);
            if (configurationFromContext == null) {
                return null;
            }
            ConfigurationFromContext fromContext = configurationFromContext;
            settings = fromContext.getConfigurationSettings();
            runManager.setTemporaryConfiguration(settings);
        }
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.python.run.PythonRunConfiguration");
        PythonRunConfiguration configuration = (PythonRunConfiguration)runConfiguration;
        return (RunConfiguration)configuration;
    }

    @Nullable
    public final PsiElement getElementForTests(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        PsiElement psiElement = PsiUtilBase.getElementAtCaret((Editor)editor);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        PsiFile psiFile2 = element.getContainingFile();
        if (psiFile2 == null) {
            return null;
        }
        PsiFile containingFile = psiFile2;
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(containingFile)) {
            return (PsiElement)containingFile;
        }
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        if (psiElement2 != null) {
            return psiElement2;
        }
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        return pyClass != null ? (PsiElement)pyClass : (PsiElement)containingFile;
    }

    @Override
    @Nullable
    public TestFileContext findOrCreateTestFile(@NotNull PsiFile sourceFile, @NotNull Project project, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        VirtualFile virtualFile = sourceFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        String testFileName = this.getTestNameExample(virtualFile);
        VirtualFile virtualFile2 = sourceFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        VirtualFile testDir = this.getTestsDirectory(virtualFile2, project);
        VirtualFile virtualFile3 = (VirtualFile)WriteAction.computeAndWait(() -> PythonAutoTestService.findOrCreateTestFile$lambda$1(testDir, this, testFileName, sourceFile));
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile testFile = virtualFile3;
        return new TestFileContext(true, testFile, CollectionsKt.emptyList(), "", CodeFence.Companion.findLanguage("Python"), null, null, null, 224, null);
    }

    private final String getTestNameExample(VirtualFile file) {
        Object[] children = file.getChildren();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])children);
        while (iterator.hasNext()) {
            String fileName;
            VirtualFile child;
            VirtualFile virtualFile = child = (VirtualFile)iterator.next();
            if (virtualFile == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getName(), (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)fileName, (String)".py", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fileName, (String)"_", (boolean)false, (int)2, null)) continue;
            return fileName;
        }
        return "test_example.py";
    }

    private final VirtualFile getTestsDirectory(VirtualFile file, Project project) {
        VirtualFile baseDirectory = (VirtualFile)ActionsKt.runReadAction(() -> PythonAutoTestService.getTestsDirectory$lambda$2(project, file));
        if (baseDirectory == null) {
            VirtualFile parent = file.getParent();
            Intrinsics.checkNotNull((Object)parent);
            return parent;
        }
        VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)"tests");
        if (virtualFile == null) {
            virtualFile = baseDirectory;
        }
        VirtualFile testDir = virtualFile;
        return testDir;
    }

    private final String toTestFileName(String testFileName, String exampleName) {
        if (StringsKt.startsWith$default((String)exampleName, (String)"test_", (boolean)false, (int)2, null)) {
            return "test_" + testFileName + ".py";
        }
        return testFileName + "_test.py";
    }

    @Override
    @NotNull
    public List<ClassContext> lookupRelevantClass(@NotNull Project project, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return CollectionsKt.emptyList();
    }

    private static final PythonRunConfigurationProducer createConfiguration$lambda$0() {
        return (PythonRunConfigurationProducer)RunConfigurationProducer.getInstance(PythonRunConfigurationProducer.class);
    }

    private static final VirtualFile findOrCreateTestFile$lambda$1(VirtualFile $testDir, PythonAutoTestService this$0, String $testFileName, PsiFile $sourceFile) {
        String string = $sourceFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return $testDir.findOrCreateChildData((Object)this$0, this$0.toTestFileName($testFileName, string));
    }

    private static final VirtualFile getTestsDirectory$lambda$2(Project $project, VirtualFile $file) {
        return ProjectFileIndex.getInstance((Project)$project).getContentRootForFile($file);
    }
}

