/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.kotlin.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u001c\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/kotlin/util/KotlinContextCollector;", "", "<init>", "()V", "resolveReference", "Lcom/intellij/psi/PsiElement;", "reference", "Lcom/intellij/psi/PsiReference;", "findUsedVariables", "", "Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;", "scope", "returnTypeText", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "replaceReferenceExpressions", "element", "oldName", "newName", "generateSummary", "psiElement", "summarizeClassOrObject", "", "project", "Lcom/intellij/openapi/project/Project;", "item", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "placeholderMessage", "removeFunctionImplementation", "makePlaceholder", "kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinContextCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinContextCollector.kt\ncc/unitmesh/kotlin/util/KotlinContextCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,206:1\n1603#2,9:207\n1855#2:216\n1856#2:218\n1612#2:219\n800#2,11:220\n766#2:231\n857#2,2:232\n1855#2,2:234\n1#3:217\n13309#4,2:236\n13309#4,2:238\n*S KotlinDebug\n*F\n+ 1 KotlinContextCollector.kt\ncc/unitmesh/kotlin/util/KotlinContextCollector\n*L\n49#1:207,9\n49#1:216\n49#1:218\n49#1:219\n90#1:220,11\n91#1:231\n91#1:232,2\n92#1:234,2\n49#1:217\n124#1:236,2\n130#1:238,2\n*E\n"})
public final class KotlinContextCollector {
    @NotNull
    public static final KotlinContextCollector INSTANCE = new KotlinContextCollector();
    @NotNull
    private static final String placeholderMessage = "/* implementation omitted for shortness */";

    private KotlinContextCollector() {
    }

    @Nullable
    public final PsiElement resolveReference(@Nullable PsiReference reference) {
        PsiElement resolvedElement;
        PsiReference psiReference = reference;
        Object object = resolvedElement = psiReference != null ? psiReference.resolve() : null;
        if (resolvedElement instanceof KtPrimaryConstructor) {
            return PsiTreeUtil.getParentOfType((PsiElement)resolvedElement, KtClass.class, (boolean)false);
        }
        if (resolvedElement == null) {
            return null;
        }
        VirtualFile virtualFile = resolvedElement.getContainingFile().getVirtualFile();
        if (virtualFile != null && !ProjectFileIndex.getInstance((Project)resolvedElement.getProject()).isInLibrary(virtualFile) && (resolvedElement instanceof KtClass || resolvedElement instanceof KtFunction)) {
            return resolvedElement;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtValVarKeywordOwner> findUsedVariables(@NotNull PsiElement scope) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)scope, KtReferenceExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Collection referenceExpressions = collection;
        Iterable $this$mapNotNull$iv = referenceExpressions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            KtValVarKeywordOwner it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtReferenceExpression it = (KtReferenceExpression)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            PsiElement psiElement = ReferenceUtilsKt.getMainReference((KtReferenceExpression)it).resolve();
            if ((psiElement instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resolvedReferences = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)resolvedReferences);
    }

    @NotNull
    public final String returnTypeText(@Nullable KtFunction function) {
        KtFunction ktFunction = function;
        Object typeReference = ktFunction != null ? ktFunction.getTypeReference() : null;
        Object object = typeReference;
        if (object == null || (object = object.getTypeText()) == null) {
            return "";
        }
        Object typeText = object;
        return ": " + (String)typeText;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement replaceReferenceExpressions(PsiElement element, String oldName, String newName) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        if (newName == null) {
            return element;
        }
        PsiElement copiedElement = element.copy();
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)element.getProject());
        Class[] classArray = new Class[]{KtReferenceExpression.class};
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)copiedElement, (boolean)false, (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
        Iterable iterable = collection;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtReferenceExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtReferenceExpression it = (KtReferenceExpression)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getText(), (Object)oldName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtReferenceExpression reference = (KtReferenceExpression)element$iv;
            boolean bl = false;
            reference.replace((PsiElement)factory.createExpressionFromText(newName, reference.getContext()));
        }
        Intrinsics.checkNotNull((Object)copiedElement);
        return copiedElement;
    }

    @Nullable
    public final String generateSummary(@NotNull PsiElement psiElement) {
        String string;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!Intrinsics.areEqual((Object)psiElement.getLanguage(), (Object)KotlinLanguage.INSTANCE) || psiElement instanceof KtDecompiledFile) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof KtFile) {
            KtClassOrObject[] classesOrObjects;
            KtFunction[] functions;
            PsiElement psiElement3 = ((KtFile)psiElement).copy();
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            KtFile copy = (KtFile)psiElement3;
            Project project = copy.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            KtFunction[] ktFunctionArray = (KtFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)copy), KtFunction.class);
            if (ktFunctionArray == null) {
                ktFunctionArray = new KtFunction[]{};
            }
            KtFunction[] $this$forEach$iv = functions = ktFunctionArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                KtFunction element$iv;
                KtFunction function = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)function);
                INSTANCE.removeFunctionImplementation(project2, function);
            }
            KtClassOrObject[] ktClassOrObjectArray = (KtClassOrObject[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)copy), KtClassOrObject.class);
            if (ktClassOrObjectArray == null) {
                ktClassOrObjectArray = new KtClassOrObject[]{};
            }
            KtClassOrObject[] $this$forEach$iv2 = classesOrObjects = ktClassOrObjectArray;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (n = 0; n < n2; ++n) {
                KtClassOrObject element$iv;
                KtClassOrObject classOrObject = element$iv = $this$forEach$iv2[n];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)classOrObject);
                INSTANCE.summarizeClassOrObject(project2, classOrObject);
            }
            string = copy.getText();
        } else if (psiElement2 instanceof KtClassOrObject) {
            PsiElement psiElement4 = ((KtClassOrObject)psiElement).copy();
            Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            KtClassOrObject copy = (KtClassOrObject)psiElement4;
            Project project = copy.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project3 = project;
            this.summarizeClassOrObject(project3, copy);
            string = copy.getText();
        } else {
            string = null;
        }
        return string;
    }

    private final void summarizeClassOrObject(Project project, KtClassOrObject item) {
        for (KtDeclaration declaration : item.getDeclarations()) {
            KtDeclaration ktDeclaration = declaration;
            if (ktDeclaration instanceof KtFunction) {
                this.removeFunctionImplementation(project, (KtFunction)declaration);
                continue;
            }
            if (!(ktDeclaration instanceof KtClassOrObject)) continue;
            this.summarizeClassOrObject(project, (KtClassOrObject)declaration);
        }
    }

    private final void removeFunctionImplementation(Project project, KtFunction function) {
        KtExpression ktExpression = function.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression bodyExpression = ktExpression;
        if (42 >= bodyExpression.getTextLength()) {
            return;
        }
        bodyExpression.deleteChildRange(bodyExpression.getFirstChild(), bodyExpression.getLastChild());
        bodyExpression.addAfter(this.makePlaceholder(project), bodyExpression.getFirstChild());
    }

    private final PsiElement makePlaceholder(Project project) {
        return (PsiElement)new KtPsiFactory(project, false).createComment(placeholderMessage);
    }
}

