/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.kotlin.provider;

import cc.unitmesh.devti.provider.RefactorInstElement;
import cc.unitmesh.devti.provider.RefactoringTool;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002R\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/kotlin/provider/KotlinRefactoringTool;", "Lcc/unitmesh/devti/provider/RefactoringTool;", "<init>", "()V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "lookupFile", "Lcom/intellij/psi/PsiFile;", "path", "", "rename", "", "sourceName", "targetName", "psiFile", "getElementInfo", "Lcc/unitmesh/devti/provider/RefactorInstElement;", "input", "kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinRefactoringTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRefactoringTool.kt\ncc/unitmesh/kotlin/provider/KotlinRefactoringTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n1603#2,9:120\n1855#2:129\n1856#2:131\n1612#2:132\n288#2,2:133\n800#2,11:137\n288#2,2:148\n800#2,11:150\n288#2,2:161\n1#3:130\n1282#4,2:135\n11#5:163\n*S KotlinDebug\n*F\n+ 1 KotlinRefactoringTool.kt\ncc/unitmesh/kotlin/provider/KotlinRefactoringTool\n*L\n27#1:120,9\n27#1:129\n27#1:131\n27#1:132\n32#1:133,2\n64#1:137,11\n65#1:148,2\n70#1:150,11\n71#1:161,2\n27#1:130\n57#1:135,2\n87#1:163\n*E\n"})
public final class KotlinRefactoringTool
implements RefactoringTool {
    @Nullable
    private final Project project;

    public KotlinRefactoringTool() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        this.project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PsiFile lookupFile(@NotNull String path) {
        Object v3;
        block5: {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (this.project == null) {
                return null;
            }
            RefactorInstElement refactorInstElement = this.getElementInfo(path, null);
            if (refactorInstElement == null) {
                return null;
            }
            RefactorInstElement elementInfo = refactorInstElement;
            GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getProjectScope(...)");
            GlobalSearchScope searchScope = globalSearchScope;
            Collection collection = FileTypeIndex.getFiles((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)searchScope);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
            Iterable iterable = collection;
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KtFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(it);
                if ((psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List ktFiles = (List)destination$iv$iv;
            String className = elementInfo.getClassName();
            String packageName = elementInfo.getPkgName();
            Iterable $this$firstOrNull$iv = ktFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtFile it = (KtFile)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getPackageFqName().asString(), (Object)packageName) && Intrinsics.areEqual((Object)it.getName(), (Object)(className + ".kt")))) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        KtFile ktFile = v3;
        if (ktFile == null) {
            return null;
        }
        KtFile sourceFile = ktFile;
        return (PsiFile)sourceFile;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean rename(@NotNull String sourceName, @NotNull String targetName, @Nullable PsiFile psiFile2) {
        PsiNamedElement psiNamedElement;
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        if (this.project == null) {
            return false;
        }
        RefactorInstElement retrieveElementInfo = this.getElementInfo(sourceName, psiFile2);
        if (retrieveElementInfo == null) {
            return false;
        }
        RefactorInstElement elementInfo = retrieveElementInfo;
        if (psiFile2 == null) return false;
        if (!(psiFile2 instanceof KtFile)) return false;
        String methodName = elementInfo.getMethodName();
        String className = elementInfo.getClassName();
        String pkgName = elementInfo.getPkgName();
        if (elementInfo.isMethod()) {
            PsiElement psiElement;
            PsiMethod findClassAndMethod;
            Object v0;
            Iterator it;
            Object $this$firstOrNull$iv;
            boolean $i$f$firstOrNull;
            block15: {
                PsiClass[] psiClassArray = ((KtFile)psiFile2).getClasses();
                $i$f$firstOrNull = false;
                int n = ((void)$this$firstOrNull$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv = $this$firstOrNull$iv[i];
                    it = element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)className)) continue;
                    v0 = element$iv;
                    break block15;
                }
                v0 = null;
            }
            var11_31 = v0;
            PsiMethod psiMethod = findClassAndMethod = var11_31 != null && ($this$firstOrNull$iv = var11_31.findMethodsByName(methodName, false)) != null ? (PsiMethod)ArraysKt.firstOrNull((Object[])$this$firstOrNull$iv) : null;
            if (psiMethod != null) {
                psiElement = (PsiElement)psiMethod;
            } else {
                Object v3;
                block16: {
                    Iterator $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    $this$firstOrNull$iv = ((KtFile)psiFile2).getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    void var14_16 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    it = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (it.hasNext()) {
                        Object element$iv$iv = it.next();
                        if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    $i$f$firstOrNull = false;
                    $this$filterIsInstanceTo$iv$iv = $this$firstOrNull$iv.iterator();
                    while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                        Object element$iv = $this$filterIsInstanceTo$iv$iv.next();
                        KtNamedFunction it2 = (KtNamedFunction)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)methodName)) continue;
                        v3 = element$iv;
                        break block16;
                    }
                    v3 = null;
                }
                KtNamedFunction ktNamedFunction = v3;
                if (ktNamedFunction == null) {
                    return false;
                }
                psiElement = (PsiElement)ktNamedFunction;
            }
            psiNamedElement = (PsiNamedElement)psiElement;
        } else {
            Object v6;
            block17: {
                void $this$firstOrNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                var11_31 = ((KtFile)psiFile2).getDeclarations();
                boolean $i$f$filterIsInstance = false;
                void $i$f$firstOrNull = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtFile)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull2 = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)className) && Intrinsics.areEqual((Object)it.getPackageFqName().asString(), (Object)pkgName))) continue;
                    v6 = element$iv;
                    break block17;
                }
                v6 = null;
            }
            KtFile ktFile = v6;
            if (ktFile == null) {
                return false;
            }
            psiNamedElement = (PsiNamedElement)ktFile;
        }
        PsiNamedElement element = psiNamedElement;
        RenameElementFix rename = new RenameElementFix(element, targetName);
        try {
            rename.invoke(this.project, psiFile2, (PsiElement)element, (PsiElement)element);
            return true;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KotlinRefactoringTool.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Error in renaming", (Throwable)e);
            return false;
        }
    }

    private final RefactorInstElement getElementInfo(String input, PsiFile psiFile2) {
        if (!StringsKt.contains$default((CharSequence)input, (CharSequence)"#", (boolean)false, (int)2, null) && psiFile2 != null) {
            KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            if (ktFile == null) {
                return null;
            }
            KtFile kotlinFile = ktFile;
            Object object = (PsiClass)ArraysKt.firstOrNull((Object[])kotlinFile.getClasses());
            if (object == null || (object = object.getName()) == null) {
                return null;
            }
            Object className = object;
            String canonicalName = kotlinFile.getPackageFqName().asString() + "." + (String)className;
            String string = kotlinFile.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return new RefactorInstElement(true, true, input, canonicalName, (String)className, string);
        }
        boolean isMethod = StringsKt.contains$default((CharSequence)input, (CharSequence)"#", (boolean)false, (int)2, null);
        String methodName = StringsKt.substringAfter$default((String)input, (String)"#", null, (int)2, null);
        String canonicalName = StringsKt.substringBefore$default((String)input, (String)"#", null, (int)2, null);
        String maybeClassName = StringsKt.substringAfterLast$default((String)canonicalName, (String)".", null, (int)2, null);
        boolean isClass = false;
        Object pkgName = StringsKt.substringBeforeLast$default((String)canonicalName, (String)".", null, (int)2, null);
        if (Character.isLowerCase(maybeClassName.charAt(0))) {
            pkgName = (String)pkgName + "." + maybeClassName;
        } else {
            isClass = true;
        }
        return new RefactorInstElement(isClass, isMethod, methodName, canonicalName, maybeClassName, (String)pkgName);
    }

    @Override
    public boolean safeDelete(@NotNull PsiElement element) {
        return RefactoringTool.DefaultImpls.safeDelete(this, element);
    }

    @Override
    public void performRefactoringRename(@NotNull Project myProject, @NotNull PsiNamedElement elementToRename, @NotNull String newName) {
        RefactoringTool.DefaultImpls.performRefactoringRename(this, myProject, elementToRename, newName);
    }

    @Override
    public boolean move(@NotNull PsiElement element, @NotNull String canonicalName) {
        return RefactoringTool.DefaultImpls.move(this, element, canonicalName);
    }
}

