/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.kotlin.provider;

import cc.unitmesh.devti.custom.document.LivingDocumentationType;
import cc.unitmesh.devti.provider.LivingDocumentation;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.kdoc.KDocElementFactory;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lcc/unitmesh/kotlin/provider/KotlinLivingDocumentation;", "Lcc/unitmesh/devti/provider/LivingDocumentation;", "<init>", "()V", "parameterTagInstruction", "", "getParameterTagInstruction", "()Ljava/lang/String;", "returnTagInstruction", "getReturnTagInstruction", "forbiddenRules", "", "getForbiddenRules", "()Ljava/util/List;", "startEndString", "Lkotlin/Pair;", "type", "Lcc/unitmesh/devti/custom/document/LivingDocumentationType;", "updateDoc", "", "target", "Lcom/intellij/psi/PsiElement;", "newDoc", "editor", "Lcom/intellij/openapi/editor/Editor;", "doInsertComment", "project", "Lcom/intellij/openapi/project/Project;", "findDocTargetsInSelection", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "root", "selectionModel", "Lcom/intellij/openapi/editor/SelectionModel;", "filterAndCollectNameIdentifierOwners", "declarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findNearestDocumentationTarget", "psiElement", "Companion", "kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinLivingDocumentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLivingDocumentation.kt\ncc/unitmesh/kotlin/provider/KotlinLivingDocumentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,206:1\n800#2,11:207\n766#2:218\n857#2,2:219\n11#3:221\n*S KotlinDebug\n*F\n+ 1 KotlinLivingDocumentation.kt\ncc/unitmesh/kotlin/provider/KotlinLivingDocumentation\n*L\n189#1:207,11\n190#1:218\n190#1:219,2\n60#1:221\n*E\n"})
public final class KotlinLivingDocumentation
implements LivingDocumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> forbiddenRules;
    @NotNull
    private static final Logger logger;

    public KotlinLivingDocumentation() {
        Object[] objectArray = new String[]{"When given a class, do not return code, just documentation. For example, do not return `class MyClass { ... }`, just return /** ... */ comment", "do not use @author and @version tags."};
        this.forbiddenRules = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getParameterTagInstruction() {
        return "use @param tag";
    }

    @Override
    @NotNull
    public String getReturnTagInstruction() {
        return "use @return tag";
    }

    @Override
    @NotNull
    public List<String> getForbiddenRules() {
        return this.forbiddenRules;
    }

    @Override
    @NotNull
    public Pair<String, String> startEndString(@NotNull LivingDocumentationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> new Pair((Object)"/**", (Object)"*/");
            case 2 -> new Pair((Object)"", (Object)"");
            case 3 -> new Pair((Object)"", (Object)"");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void updateDoc(@NotNull PsiElement target, @NotNull String newDoc, @NotNull LivingDocumentationType type, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)newDoc, (String)"newDoc");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)"Living Document", (String)"cc.unitmesh.livingDoc", () -> KotlinLivingDocumentation.updateDoc$lambda$0(target, newDoc, type, this, project2, editor, codeStyleManager), (PsiFile[])new PsiFile[0]);
    }

    private final void doInsertComment(PsiElement target, Project project, String newDoc) {
        KDoc docComment;
        KtDeclaration ktDeclaration = target instanceof KtDeclaration ? (KtDeclaration)target : null;
        if (ktDeclaration == null) {
            throw new IncorrectOperationException();
        }
        KtDeclaration ktDeclaration2 = ktDeclaration;
        PsiElement createKDocFromText = (PsiElement)new KDocElementFactory(project).createKDocFromText(newDoc);
        Intrinsics.checkNotNull((Object)target, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
        KDoc kDoc = docComment = ((KtDeclaration)target).getDocComment();
        if ((kDoc != null ? kDoc.replace(createKDocFromText) : null) == null) {
            ktDeclaration2.addBefore(createKDocFromText, ktDeclaration2.getFirstChild());
        }
    }

    @Override
    @NotNull
    public List<PsiNameIdentifierOwner> findDocTargetsInSelection(@NotNull PsiElement root, @NotNull SelectionModel selectionModel) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        PsiElement commonParent = CollectHighlightsUtil.findCommonParent((PsiElement)root, (int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
        if (commonParent instanceof KtFile) {
            return this.filterAndCollectNameIdentifierOwners(((KtFile)commonParent).getDeclarations(), selectionModel);
        }
        PsiElement psiElement = commonParent;
        Intrinsics.checkNotNull((Object)psiElement);
        PsiNameIdentifierOwner nearestDocumentationTarget = this.findNearestDocumentationTarget(psiElement);
        if (!(nearestDocumentationTarget instanceof KtClassOrObject) || this.containsElement(selectionModel, (PsiElement)nearestDocumentationTarget)) {
            PsiNameIdentifierOwner psiNameIdentifierOwner = nearestDocumentationTarget;
            Intrinsics.checkNotNull((Object)psiNameIdentifierOwner);
            return CollectionsKt.listOf((Object)psiNameIdentifierOwner);
        }
        List classDeclarations = ((KtClassOrObject)nearestDocumentationTarget).getDeclarations();
        return this.filterAndCollectNameIdentifierOwners(classDeclarations, selectionModel);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiNameIdentifierOwner> filterAndCollectNameIdentifierOwners(Iterable<? extends KtDeclaration> declarations, SelectionModel selectionModel) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = declarations;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiNameIdentifierOwner)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiNameIdentifierOwner it = (PsiNameIdentifierOwner)element$iv$iv;
            boolean bl = false;
            if (!this.containsElement(selectionModel, (PsiElement)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredElements = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)filteredElements);
    }

    @Override
    @Nullable
    public PsiNameIdentifierOwner findNearestDocumentationTarget(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (psiElement instanceof KtNamedFunction || psiElement instanceof KtClassOrObject) {
            return (PsiNameIdentifierOwner)psiElement;
        }
        PsiNameIdentifierOwner closestIdentifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNameIdentifierOwner.class);
        if (!(closestIdentifierOwner instanceof KtNamedFunction)) {
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, KtNamedFunction.class);
            return ktNamedFunction != null ? (PsiNameIdentifierOwner)ktNamedFunction : closestIdentifierOwner;
        }
        return closestIdentifierOwner;
    }

    @Override
    public boolean containsElement(@NotNull SelectionModel selectionModel, @NotNull PsiElement element) {
        return LivingDocumentation.DefaultImpls.containsElement(this, selectionModel, element);
    }

    private static final void updateDoc$lambda$0(PsiElement $target, String $newDoc, LivingDocumentationType $type, KotlinLivingDocumentation this$0, Project $project, Editor $editor, CodeStyleManager $codeStyleManager) {
        int startOffset = $target.getTextRange().getStartOffset();
        int newEndOffset = startOffset + $newDoc.length();
        switch (WhenMappings.$EnumSwitchMapping$0[$type.ordinal()]) {
            case 1: {
                try {
                    this$0.doInsertComment($target, $project, $newDoc);
                }
                catch (Exception e) {
                    String fromSuggestion = LivingDocumentation.Companion.buildDocFromSuggestion($newDoc, "/**", "*/");
                    if (((CharSequence)fromSuggestion).length() > 0) {
                        try {
                            this$0.doInsertComment($target, $project, fromSuggestion);
                        }
                        catch (Exception e2) {
                            logger.error("Failed to update documentation for " + $target + ", doc: " + $newDoc);
                        }
                        return;
                    }
                    logger.error("Failed to update documentation for " + $target + ", doc: " + $newDoc);
                }
                break;
            }
            case 2: {
                $editor.getDocument().insertString(startOffset, (CharSequence)$newDoc);
                $codeStyleManager.reformatText($target.getContainingFile(), startOffset, newEndOffset);
                break;
            }
            case 3: {
                $editor.getDocument().insertString(startOffset, (CharSequence)$newDoc);
                $codeStyleManager.reformatText($target.getContainingFile(), startOffset, newEndOffset);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinLivingDocumentation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        KotlinLivingDocumentation.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/kotlin/provider/KotlinLivingDocumentation$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LivingDocumentationType.values().length];
            try {
                nArray[LivingDocumentationType.COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LivingDocumentationType.ANNOTATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LivingDocumentationType.CUSTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

