/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.idea.provider;

import cc.unitmesh.devti.provider.RefactorInstElement;
import cc.unitmesh.devti.provider.RefactoringTool;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002R\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcc/unitmesh/idea/provider/JavaRefactoringTool;", "Lcc/unitmesh/devti/provider/RefactoringTool;", "<init>", "()V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "lookupFile", "Lcom/intellij/psi/PsiFile;", "path", "", "rename", "", "sourceName", "targetName", "psiFile", "searchPsiElementByName", "Lcom/intellij/psi/PsiNamedElement;", "refactorInstElement", "Lcc/unitmesh/devti/provider/RefactorInstElement;", "getElementInfo", "input", "java"})
@SourceDebugExtension(value={"SMAP\nJavaRefactoringTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaRefactoringTool.kt\ncc/unitmesh/idea/provider/JavaRefactoringTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,129:1\n1603#2,9:130\n1855#2:139\n1856#2:141\n1612#2:142\n288#2,2:143\n1#3:140\n1282#4,2:145\n1282#4,2:147\n1282#4,2:149\n1282#4,2:151\n1282#4,2:153\n*S KotlinDebug\n*F\n+ 1 JavaRefactoringTool.kt\ncc/unitmesh/idea/provider/JavaRefactoringTool\n*L\n24#1:130,9\n24#1:139\n24#1:141\n24#1:142\n31#1:143,2\n24#1:140\n50#1:145,2\n51#1:147,2\n83#1:149,2\n84#1:151,2\n92#1:153,2\n*E\n"})
public final class JavaRefactoringTool
implements RefactoringTool {
    @Nullable
    private final Project project;

    public JavaRefactoringTool() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        this.project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public PsiFile lookupFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.project == null) {
            return null;
        }
        RefactorInstElement refactorInstElement = (RefactorInstElement)ActionsKt.runReadAction(() -> JavaRefactoringTool.lookupFile$lambda$0(this, path));
        if (refactorInstElement == null) {
            return null;
        }
        RefactorInstElement elementInfo = refactorInstElement;
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getProjectScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        List javaFiles = (List)ActionsKt.runReadAction(() -> JavaRefactoringTool.lookupFile$lambda$2(searchScope, this));
        String className = elementInfo.getClassName();
        String packageName = elementInfo.getPkgName();
        PsiJavaFile psiJavaFile = (PsiJavaFile)ActionsKt.runReadAction(() -> JavaRefactoringTool.lookupFile$lambda$4(javaFiles, packageName, className));
        if (psiJavaFile == null) {
            return null;
        }
        PsiJavaFile sourceFile = psiJavaFile;
        return (PsiFile)sourceFile;
    }

    @Override
    public boolean rename(@NotNull String sourceName, @NotNull String targetName, @Nullable PsiFile psiFile2) {
        PsiNamedElement psiNamedElement;
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        if (this.project == null) {
            return false;
        }
        RefactorInstElement refactorInstElement = (RefactorInstElement)ActionsKt.runReadAction(() -> JavaRefactoringTool.rename$lambda$5(this, sourceName, psiFile2));
        if (refactorInstElement == null) {
            return false;
        }
        RefactorInstElement elementInfo = refactorInstElement;
        if (psiFile2 != null) {
            if (psiFile2 instanceof PsiJavaFile) {
                PsiMethod psiMethod;
                String methodName = elementInfo.getMethodName();
                String className = elementInfo.getClassName();
                PsiMethod psiMethod2 = psiMethod = (PsiMethod)ActionsKt.runReadAction(() -> JavaRefactoringTool.rename$lambda$8(psiFile2, className, methodName));
                psiNamedElement = (PsiNamedElement)(psiMethod2 != null ? (PsiElement)psiMethod2 : (PsiElement)psiFile2);
            } else {
                psiNamedElement = (PsiNamedElement)psiFile2;
            }
        } else {
            psiNamedElement = this.searchPsiElementByName(elementInfo, sourceName);
            if (psiNamedElement == null) {
                return false;
            }
        }
        PsiNamedElement element = psiNamedElement;
        try {
            new RenameElementFix(element, targetName).invoke(this.project, element.getContainingFile(), (PsiElement)element, (PsiElement)element);
            this.performRefactoringRename(this.project, element, targetName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private final PsiNamedElement searchPsiElementByName(RefactorInstElement refactorInstElement, String sourceName) {
        return (PsiNamedElement)ActionsKt.runReadAction(() -> JavaRefactoringTool.searchPsiElementByName$lambda$12(refactorInstElement, this, sourceName));
    }

    private final RefactorInstElement getElementInfo(String input, PsiFile psiFile2) {
        if (!StringsKt.contains$default((CharSequence)input, (CharSequence)"#", (boolean)false, (int)2, null) && psiFile2 != null) {
            PsiJavaFile psiJavaFile = psiFile2 instanceof PsiJavaFile ? (PsiJavaFile)psiFile2 : null;
            if (psiJavaFile == null) {
                return null;
            }
            PsiJavaFile javaFile = psiJavaFile;
            PsiClass[] psiClassArray = javaFile.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
            Object object = (PsiClass)ArraysKt.firstOrNull((Object[])psiClassArray);
            if (object == null || (object = object.getName()) == null) {
                return null;
            }
            Object className = object;
            String canonicalName = javaFile.getPackageName() + "." + (String)className;
            String string = javaFile.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            return new RefactorInstElement(true, true, input, canonicalName, (String)className, string);
        }
        boolean isMethod = StringsKt.contains$default((CharSequence)input, (CharSequence)"#", (boolean)false, (int)2, null);
        String methodName = StringsKt.substringAfter$default((String)input, (String)"#", null, (int)2, null);
        String canonicalName = StringsKt.substringBefore$default((String)input, (String)"#", null, (int)2, null);
        String maybeClassName = StringsKt.substringAfterLast$default((String)canonicalName, (String)".", null, (int)2, null);
        boolean isClass = false;
        Object pkgName = StringsKt.substringBeforeLast$default((String)canonicalName, (String)".", null, (int)2, null);
        if (Character.isLowerCase(maybeClassName.charAt(0))) {
            pkgName = (String)pkgName + "." + maybeClassName;
        } else {
            isClass = true;
        }
        return new RefactorInstElement(isClass, isMethod, methodName, canonicalName, maybeClassName, (String)pkgName);
    }

    @Override
    public boolean safeDelete(@NotNull PsiElement element) {
        return RefactoringTool.DefaultImpls.safeDelete(this, element);
    }

    @Override
    public void performRefactoringRename(@NotNull Project myProject, @NotNull PsiNamedElement elementToRename, @NotNull String newName) {
        RefactoringTool.DefaultImpls.performRefactoringRename(this, myProject, elementToRename, newName);
    }

    @Override
    public boolean move(@NotNull PsiElement element, @NotNull String canonicalName) {
        return RefactoringTool.DefaultImpls.move(this, element, canonicalName);
    }

    private static final RefactorInstElement lookupFile$lambda$0(JavaRefactoringTool this$0, String $path) {
        return this$0.getElementInfo($path, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List lookupFile$lambda$2(GlobalSearchScope $searchScope, JavaRefactoringTool this$0) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = FileTypeIndex.getFiles((FileType)((FileType)JavaFileType.INSTANCE), (GlobalSearchScope)$searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PsiJavaFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            PsiFile psiFile2 = PsiManager.getInstance((Project)this$0.project).findFile(it);
            if ((psiFile2 instanceof PsiJavaFile ? (PsiJavaFile)psiFile2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PsiJavaFile lookupFile$lambda$4(List $javaFiles, String $packageName, String $className) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $javaFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getPackageName(), (Object)$packageName) && Intrinsics.areEqual((Object)it.getName(), (Object)($className + ".java")))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final RefactorInstElement rename$lambda$5(JavaRefactoringTool this$0, String $sourceName, PsiFile $psiFile) {
        return this$0.getElementInfo($sourceName, $psiFile);
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiMethod rename$lambda$8(PsiFile $psiFile, String $className, String $methodName) {
        Object v2;
        block5: {
            PsiMethod[] psiMethodArray;
            Object object;
            int n;
            block4: {
                PsiClass[] psiClassArray = ((PsiJavaFile)$psiFile).getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
                Object[] $this$firstOrNull$iv = psiClassArray;
                boolean $i$f$firstOrNull = false;
                n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv = $this$firstOrNull$iv[i];
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$className)) continue;
                    object = element$iv;
                    break block4;
                }
                object = null;
            }
            PsiClass psiClass = (PsiClass)object;
            if (psiClass != null && (psiMethodArray = psiClass.getMethods()) != null) {
                void $this$firstOrNull$iv;
                PsiMethod[] $i$f$firstOrNull = psiMethodArray;
                boolean $i$f$firstOrNull2 = false;
                int n2 = ((void)$this$firstOrNull$iv).length;
                for (n = 0; n < n2; ++n) {
                    void element$iv;
                    void it = element$iv = $this$firstOrNull$iv[n];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$methodName)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            } else {
                v2 = null;
            }
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiNamedElement searchPsiElementByName$lambda$12(RefactorInstElement $refactorInstElement, JavaRefactoringTool this$0, String $sourceName) {
        PsiElement psiElement;
        block18: {
            block15: {
                Object $i$f$firstOrNull2;
                block17: {
                    block16: {
                        block13: {
                            Object v3;
                            void $this$firstOrNull$iv;
                            PsiMethod[] psiMethodArray;
                            Object object;
                            PsiFile psiFile2;
                            block12: {
                                if (!$refactorInstElement.isMethod()) break block15;
                                String className = $refactorInstElement.getClassName();
                                psiFile2 = this$0.lookupFile($sourceName);
                                PsiJavaFile psiJavaFile = psiFile2 instanceof PsiJavaFile ? (PsiJavaFile)psiFile2 : null;
                                if (psiJavaFile == null) {
                                    return null;
                                }
                                PsiJavaFile javaFile = psiJavaFile;
                                PsiClass[] psiClassArray = javaFile.getClasses();
                                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
                                Object[] $this$firstOrNull$iv2 = psiClassArray;
                                boolean $i$f$firstOrNull2 = false;
                                for (Object element$iv : $this$firstOrNull$iv2) {
                                    PsiClass it = (PsiClass)element$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)className)) continue;
                                    object = element$iv;
                                    break block12;
                                }
                                object = null;
                            }
                            psiFile2 = (PsiClass)object;
                            if (psiFile2 == null || (psiMethodArray = psiFile2.getMethods()) == null) break block16;
                            PsiMethod[] psiMethodArray2 = psiMethodArray;
                            boolean $i$f$firstOrNull3 = false;
                            int n = ((void)$this$firstOrNull$iv).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv;
                                void it = element$iv = $this$firstOrNull$iv[i];
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$refactorInstElement.getMethodName())) continue;
                                v3 = element$iv;
                                break block13;
                            }
                            v3 = $i$f$firstOrNull2 = null;
                        }
                        if ($i$f$firstOrNull2 != null) break block17;
                    }
                    return null;
                }
                Object psiMethod = $i$f$firstOrNull2;
                psiElement = psiMethod;
                break block18;
            }
            if ($refactorInstElement.isClass()) {
                Object object;
                block14: {
                    PsiFile psiMethod = this$0.lookupFile($sourceName);
                    PsiJavaFile psiJavaFile = psiMethod instanceof PsiJavaFile ? (PsiJavaFile)psiMethod : null;
                    if (psiJavaFile == null) {
                        return null;
                    }
                    PsiJavaFile javaFile = psiJavaFile;
                    PsiClass[] psiClassArray = javaFile.getClasses();
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
                    Object[] $this$firstOrNull$iv = psiClassArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiClass it = (PsiClass)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)$refactorInstElement.getClassName())) continue;
                        object = element$iv;
                        break block14;
                    }
                    object = null;
                }
                psiElement = (PsiElement)object;
            } else {
                void var3_5;
                PsiFile psiFile3 = this$0.lookupFile($sourceName);
                PsiJavaFile psiJavaFile = psiFile3 instanceof PsiJavaFile ? (PsiJavaFile)psiFile3 : null;
                if (psiJavaFile == null) {
                    return null;
                }
                PsiJavaFile javaFile = psiJavaFile;
                psiElement = (PsiElement)var3_5;
            }
        }
        return (PsiNamedElement)psiElement;
    }
}

