/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.ide.javascript.util;

import cc.unitmesh.devti.provider.context.ChatCreationContext;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/ide/javascript/util/LanguageApplicableUtil;", "", "<init>", "()V", "isJavaScriptApplicable", "", "language", "Lcom/intellij/lang/Language;", "isPreferTypeScript", "creationContext", "Lcc/unitmesh/devti/provider/context/ChatCreationContext;", "isWebChatCreationContextSupported", "psiFile", "Lcom/intellij/psi/PsiFile;", "isWebLLMContext", "javascript"})
public final class LanguageApplicableUtil {
    @NotNull
    public static final LanguageApplicableUtil INSTANCE = new LanguageApplicableUtil();

    private LanguageApplicableUtil() {
    }

    public final boolean isJavaScriptApplicable(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE) || language.isKindOf((Language)HTMLLanguage.INSTANCE);
    }

    public final boolean isPreferTypeScript(@NotNull ChatCreationContext creationContext) {
        Intrinsics.checkNotNullParameter((Object)creationContext, (String)"creationContext");
        PsiFile psiFile2 = creationContext.getSourceFile();
        if (psiFile2 == null) {
            return false;
        }
        PsiFile sourceFile = psiFile2;
        return DialectDetector.isTypeScript((PsiElement)((PsiElement)sourceFile));
    }

    public final boolean isWebChatCreationContextSupported(@Nullable PsiFile psiFile2) {
        return this.isWebLLMContext(psiFile2);
    }

    public final boolean isWebLLMContext(@Nullable PsiFile psiFile2) {
        if (psiFile2 == null) {
            return false;
        }
        if (PackageJsonUtil.isPackageJsonFile((PsiFile)psiFile2)) {
            return true;
        }
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return this.isJavaScriptApplicable(language);
    }
}

