/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.ide.javascript.provider;

import cc.unitmesh.devti.provider.RefactorInstElement;
import cc.unitmesh.devti.provider.RefactoringTool;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J.\u0010\u001c\u001a\u0004\u0018\u00010\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00192\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010%\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lcc/unitmesh/ide/javascript/provider/TypeScriptRefactoringTool;", "Lcc/unitmesh/devti/provider/RefactoringTool;", "<init>", "()V", "identifierPattern", "Lkotlin/text/Regex;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "lookupFile", "Lcom/intellij/psi/PsiFile;", "path", "", "findNamedElement", "Lcom/intellij/psi/PsiNamedElement;", "psiFile", "elementInfo", "Lcc/unitmesh/devti/provider/RefactorInstElement;", "findElementInJSFile", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "findClassByName", "classes", "", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "className", "findMethodByName", "functions", "Lcom/intellij/lang/javascript/psi/JSFunction;", "methodName", "rename", "", "sourceName", "targetName", "getElementInfo", "input", "javascript"})
@SourceDebugExtension(value={"SMAP\nTypeScriptRefactoringTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptRefactoringTool.kt\ncc/unitmesh/ide/javascript/provider/TypeScriptRefactoringTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1603#2,9:130\n1855#2:139\n1856#2:141\n1612#2:142\n1603#2,9:143\n1855#2:152\n1856#2:154\n1612#2:155\n288#2,2:156\n288#2,2:158\n288#2,2:160\n1#3:140\n1#3:153\n*S KotlinDebug\n*F\n+ 1 TypeScriptRefactoringTool.kt\ncc/unitmesh/ide/javascript/provider/TypeScriptRefactoringTool\n*L\n29#1:130,9\n29#1:139\n29#1:141\n29#1:142\n32#1:143,9\n32#1:152\n32#1:154\n32#1:155\n36#1:156,2\n62#1:158,2\n72#1:160,2\n29#1:140\n32#1:153\n*E\n"})
public final class TypeScriptRefactoringTool
implements RefactoringTool {
    @NotNull
    private final Regex identifierPattern = new Regex("^[a-zA-Z_][a-zA-Z0-9_]*$");
    @Nullable
    private final Project project;

    public TypeScriptRefactoringTool() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        this.project = (Project)ArraysKt.firstOrNull((Object[])projectArray);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PsiFile lookupFile(@NotNull String path) {
        Object v3;
        block5: {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object element$iv$iv$iv2;
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (this.project == null) {
                return null;
            }
            GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getProjectScope(...)");
            GlobalSearchScope searchScope = globalSearchScope;
            Collection collection = FileTypeIndex.getFiles((FileType)((FileType)JavaScriptFileType.INSTANCE), (GlobalSearchScope)searchScope);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
            Iterable iterable = collection;
            boolean $i$f$mapNotNull22 = false;
            void var6_6 = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                JSFile it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv2;
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(it);
                if ((psiFile2 instanceof JSFile ? (JSFile)psiFile2 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List jsFiles = (List)destination$iv$iv;
            Collection collection2 = FileTypeIndex.getFiles((FileType)((FileType)JavaScriptFileType.INSTANCE), (GlobalSearchScope)searchScope);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getFiles(...)");
            Iterable $i$f$mapNotNull22 = collection2;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                JSFile it$iv$iv;
                Object element$iv$iv$iv3;
                Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl4 = false;
                PsiFile psiFile3 = PsiManager.getInstance((Project)this.project).findFile(it);
                if ((psiFile3 instanceof JSFile ? (JSFile)psiFile3 : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List tsFiles = (List)destination$iv$iv2;
            List files = CollectionsKt.plus((Collection)jsFiles, (Iterable)tsFiles);
            Iterable $this$firstOrNull$iv = files;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JSFile it = (JSFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVirtualFile().getPath(), (Object)path)) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        JSFile jSFile = v3;
        if (jSFile == null) {
            return null;
        }
        JSFile sourceFile = jSFile;
        return (PsiFile)sourceFile;
    }

    private final PsiNamedElement findNamedElement(PsiFile psiFile2, RefactorInstElement elementInfo) {
        return psiFile2 instanceof JSFile ? this.findElementInJSFile((JSFile)psiFile2, elementInfo) : null;
    }

    private final PsiNamedElement findElementInJSFile(JSFile jsFile, RefactorInstElement elementInfo) {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PsiElement)jsFile), JSClass.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        List classes = list;
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PsiElement)jsFile), JSFunction.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
        List functions = list2;
        return elementInfo.isClass() ? this.findClassByName(classes, elementInfo.getClassName()) : (elementInfo.isMethod() ? this.findMethodByName(classes, functions, elementInfo.getMethodName()) : null);
    }

    private final PsiNamedElement findClassByName(List<? extends JSClass> classes, String className) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = classes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JSClass it = (JSClass)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)className)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final PsiNamedElement findMethodByName(List<? extends JSClass> classes, List<? extends JSFunction> functions, String methodName) {
        PsiNamedElement psiNamedElement;
        JSFunction jSFunction;
        block4: {
            for (JSClass it : (Iterable)classes) {
                boolean bl = false;
                JSFunction jSFunction2 = it.findFunctionByName(methodName);
                if (jSFunction2 == null) continue;
                jSFunction = jSFunction2;
                break block4;
            }
            jSFunction = null;
        }
        if (jSFunction != null) {
            psiNamedElement = (PsiNamedElement)jSFunction;
        } else {
            Object v2;
            block5: {
                Iterable $this$firstOrNull$iv = functions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JSFunction it = (JSFunction)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)methodName)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            psiNamedElement = v2;
        }
        return psiNamedElement;
    }

    @Override
    public boolean rename(@NotNull String sourceName, @NotNull String targetName, @Nullable PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        if (this.project == null) {
            return false;
        }
        if (!this.identifierPattern.matches((CharSequence)targetName)) {
            return false;
        }
        RefactorInstElement refactorInstElement = this.getElementInfo(sourceName, psiFile2);
        if (refactorInstElement == null) {
            return false;
        }
        RefactorInstElement elementInfo = refactorInstElement;
        PsiNamedElement psiNamedElement = this.findNamedElement(psiFile2, elementInfo);
        if (psiNamedElement == null) {
            return false;
        }
        PsiNamedElement element = psiNamedElement;
        try {
            Object target = targetName;
            if (element instanceof JSFile) {
                String string = ((JSFile)element).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                target = (String)target + StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null);
            }
            new RenameElementFix(element, (String)target).invoke(this.project, element.getContainingFile(), (PsiElement)element, (PsiElement)element);
            this.performRefactoringRename(this.project, element, targetName);
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private final RefactorInstElement getElementInfo(String input, PsiFile psiFile2) {
        if (!StringsKt.contains$default((CharSequence)input, (CharSequence)"#", (boolean)false, (int)2, null) && psiFile2 != null) {
            JSFile jSFile = psiFile2 instanceof JSFile ? (JSFile)psiFile2 : null;
            if (jSFile == null) {
                return null;
            }
            JSFile jsFile = jSFile;
            boolean isClass = Character.isUpperCase(input.charAt(0));
            boolean isMethod = Character.isLowerCase(input.charAt(0));
            String string = jsFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return new RefactorInstElement(isClass, isMethod, input, input, input, string);
        }
        boolean isMethod = StringsKt.contains$default((CharSequence)input, (CharSequence)"#", (boolean)false, (int)2, null);
        String methodName = StringsKt.substringAfter$default((String)input, (String)"#", null, (int)2, null);
        String canonicalName = StringsKt.substringBefore$default((String)input, (String)"#", null, (int)2, null);
        String maybeClassName = StringsKt.substringAfterLast$default((String)canonicalName, (String)".", null, (int)2, null);
        boolean isClass = false;
        Object pkgName = StringsKt.substringBeforeLast$default((String)canonicalName, (String)".", null, (int)2, null);
        if (Character.isLowerCase(maybeClassName.charAt(0))) {
            pkgName = (String)pkgName + "." + maybeClassName;
        } else {
            isClass = true;
        }
        return new RefactorInstElement(isClass, isMethod, methodName, canonicalName, maybeClassName, (String)pkgName);
    }

    @Override
    public boolean safeDelete(@NotNull PsiElement element) {
        return RefactoringTool.DefaultImpls.safeDelete(this, element);
    }

    @Override
    public void performRefactoringRename(@NotNull Project myProject, @NotNull PsiNamedElement elementToRename, @NotNull String newName) {
        RefactoringTool.DefaultImpls.performRefactoringRename(this, myProject, elementToRename, newName);
    }

    @Override
    public boolean move(@NotNull PsiElement element, @NotNull String canonicalName) {
        return RefactoringTool.DefaultImpls.move(this, element, canonicalName);
    }
}

