/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.ide.javascript.provider;

import cc.unitmesh.devti.prompting.code.TechStack;
import cc.unitmesh.devti.provider.context.ChatContextItem;
import cc.unitmesh.devti.provider.context.ChatContextProvider;
import cc.unitmesh.devti.provider.context.ChatCreationContext;
import cc.unitmesh.ide.javascript.JsDependenciesSnapshot;
import cc.unitmesh.ide.javascript.provider.JsTestFrameworks;
import cc.unitmesh.ide.javascript.provider.JsWebFrameworks;
import cc.unitmesh.ide.javascript.util.JsUtil;
import cc.unitmesh.ide.javascript.util.LanguageApplicableUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.PackageJsonDependency;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/ide/javascript/provider/JavaScriptContextProvider;", "Lcc/unitmesh/devti/provider/context/ChatContextProvider;", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "creationContext", "Lcc/unitmesh/devti/provider/context/ChatCreationContext;", "collect", "", "Lcc/unitmesh/devti/provider/context/ChatContextItem;", "(Lcom/intellij/openapi/project/Project;Lcc/unitmesh/devti/provider/context/ChatCreationContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMostPopularPackagesContext", "snapshot", "Lcc/unitmesh/ide/javascript/JsDependenciesSnapshot;", "getTypeScriptLanguageContext", "prepareStack", "Lcc/unitmesh/devti/prompting/code/TechStack;", "javascript"})
@SourceDebugExtension(value={"SMAP\nJavaScriptContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptContextProvider.kt\ncc/unitmesh/ide/javascript/provider/JavaScriptContextProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,130:1\n11#2:131\n1#3:132\n215#4:133\n216#4:138\n13309#5,2:134\n13309#5,2:136\n*S KotlinDebug\n*F\n+ 1 JavaScriptContextProvider.kt\ncc/unitmesh/ide/javascript/provider/JavaScriptContextProvider\n*L\n16#1:131\n99#1:133\n99#1:138\n107#1:134,2\n113#1:136,2\n*E\n"})
public final class JavaScriptContextProvider
implements ChatContextProvider {
    @NotNull
    private final Logger log;

    public JavaScriptContextProvider() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JavaScriptContextProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
    }

    @Override
    public boolean isApplicable(@NotNull Project project, @NotNull ChatCreationContext creationContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)creationContext, (String)"creationContext");
        PsiFile psiFile2 = creationContext.getSourceFile();
        if (psiFile2 == null) {
            return false;
        }
        PsiFile sourceFile = psiFile2;
        Language language = sourceFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return LanguageApplicableUtil.INSTANCE.isJavaScriptApplicable(language);
    }

    @Override
    @Nullable
    public Object collect(@NotNull Project project, @NotNull ChatCreationContext creationContext, @NotNull Continuation<? super List<ChatContextItem>> $completion) {
        List results2 = new ArrayList();
        ChatCreationContext chatCreationContext = creationContext;
        JsDependenciesSnapshot snapshot = JsDependenciesSnapshot.Companion.create(project, (PsiFile)(chatCreationContext != null ? chatCreationContext.getSourceFile() : null));
        ChatContextItem typeScriptLanguageContext = this.getTypeScriptLanguageContext(snapshot);
        ChatContextItem mostPopularPackagesContext = this.getMostPopularPackagesContext(snapshot);
        TechStack techStack = this.prepareStack(snapshot);
        if (typeScriptLanguageContext != null) {
            results2.add(typeScriptLanguageContext);
        }
        if (mostPopularPackagesContext != null) {
            results2.add(mostPopularPackagesContext);
        }
        this.log.info("Tech stack: " + techStack);
        if (((CharSequence)techStack.coreFrameworks()).length() > 0) {
            ChatContextItem element = new ChatContextItem(Reflection.getOrCreateKotlinClass(JavaScriptContextProvider.class), "The project uses the following JavaScript component frameworks: " + techStack.coreFrameworks());
            results2.add(element);
        }
        if (((CharSequence)techStack.testFrameworks()).length() > 0) {
            ChatContextItem testChatContext = new ChatContextItem(Reflection.getOrCreateKotlinClass(JavaScriptContextProvider.class), "The project uses " + techStack.testFrameworks() + " to test.");
            Boxing.boxBoolean((boolean)results2.add(testChatContext));
        } else {
            PsiFile psiFile2 = creationContext.getSourceFile();
            if (psiFile2 == null) {
                return CollectionsKt.emptyList();
            }
            String testFrameworkName = JsUtil.INSTANCE.guessTestFrameworkName(psiFile2);
            if (testFrameworkName != null) {
                ChatContextItem testChatContext = new ChatContextItem(Reflection.getOrCreateKotlinClass(JavaScriptContextProvider.class), "\nUse " + testFrameworkName + " JavaScript test framework.");
                results2.add(testChatContext);
            }
        }
        return results2;
    }

    private final ChatContextItem getMostPopularPackagesContext(JsDependenciesSnapshot snapshot) {
        List<String> dependencies = snapshot.mostPopularFrameworks();
        if (dependencies.isEmpty()) {
            return null;
        }
        return new ChatContextItem(Reflection.getOrCreateKotlinClass(JavaScriptContextProvider.class), "The project uses the following JavaScript packages: " + CollectionsKt.joinToString$default((Iterable)dependencies, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    private final ChatContextItem getTypeScriptLanguageContext(JsDependenciesSnapshot snapshot) {
        Object object;
        KClass kClass;
        block5: {
            block4: {
                PackageJsonData.PackageJsonDependencyEntry packageJsonDependencyEntry = snapshot.getPackages().get("typescript");
                if (packageJsonDependencyEntry == null) {
                    return null;
                }
                PackageJsonData.PackageJsonDependencyEntry packageJson = packageJsonDependencyEntry;
                SemVer version = packageJson.parseVersion();
                kClass = Reflection.getOrCreateKotlinClass(JavaScriptContextProvider.class);
                object = version;
                if (object == null) break block4;
                SemVer semVer = object;
                KClass kClass2 = kClass;
                boolean bl = false;
                String string = ", version: " + version;
                kClass = kClass2;
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        String string = "The project uses TypeScript language" + (String)object;
        KClass kClass3 = kClass;
        return new ChatContextItem(kClass3, string);
    }

    private final TechStack prepareStack(JsDependenciesSnapshot snapshot) {
        Map devDependencies = new LinkedHashMap();
        Map dependencies = new LinkedHashMap();
        Map frameworks = new LinkedHashMap();
        Map testFrameworks = new LinkedHashMap();
        Map<String, PackageJsonData.PackageJsonDependencyEntry> $this$forEach$iv = snapshot.getPackages();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, PackageJsonData.PackageJsonDependencyEntry>> iterator = $this$forEach$iv.entrySet().iterator();
        block3: while (iterator.hasNext()) {
            Map.Entry<String, PackageJsonData.PackageJsonDependencyEntry> element$iv;
            Map.Entry<String, PackageJsonData.PackageJsonDependencyEntry> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            PackageJsonData.PackageJsonDependencyEntry entry2 = entry.getValue();
            PackageJsonDependency it = entry2.getDependencyType();
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: 
                case 2: {
                    Enum framework;
                    Enum element$iv2;
                    int n;
                    if (!StringsKt.startsWith$default((String)name, (String)"@types/", (boolean)false, (int)2, null)) {
                        devDependencies.put(name, entry2.getVersionRange());
                    }
                    Enum[] $this$forEach$iv2 = JsWebFrameworks.values();
                    boolean $i$f$forEach2 = false;
                    int n2 = $this$forEach$iv2.length;
                    for (n = 0; n < n2; ++n) {
                        framework = element$iv2 = $this$forEach$iv2[n];
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)name, (String)((JsWebFrameworks)framework).getPackageName(), (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name, (Object)((JsWebFrameworks)framework).getPackageName())) continue;
                        frameworks.put(((JsWebFrameworks)framework).getPackageName(), true);
                    }
                    $this$forEach$iv2 = JsTestFrameworks.values();
                    $i$f$forEach2 = false;
                    n2 = $this$forEach$iv2.length;
                    for (n = 0; n < n2; ++n) {
                        framework = element$iv2 = $this$forEach$iv2[n];
                        boolean bl4 = false;
                        if (!StringsKt.startsWith$default((String)name, (String)((JsTestFrameworks)framework).getPackageName(), (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name, (Object)((JsTestFrameworks)framework).getPackageName())) continue;
                        testFrameworks.put(((JsTestFrameworks)framework).getPackageName(), true);
                    }
                    continue block3;
                }
            }
        }
        return new TechStack(frameworks, testFrameworks, dependencies, devDependencies);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PackageJsonDependency.values().length];
            try {
                nArray[PackageJsonDependency.dependencies.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageJsonDependency.devDependencies.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

