/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.ide.javascript;

import cc.unitmesh.ide.javascript.provider.JavaScriptFrameworksKt;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.SemVer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J\u0006\u0010\u0014\u001a\u00020\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/ide/javascript/JsDependenciesSnapshot;", "", "packageJsonFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolvedPackageJson", "", "tsConfigs", "packages", "", "", "Lcom/intellij/javascript/nodejs/PackageJsonData$PackageJsonDependencyEntry;", "<init>", "(Ljava/util/Set;ZLjava/util/Set;Ljava/util/Map;)V", "getPackageJsonFiles", "()Ljava/util/Set;", "getPackages", "()Ljava/util/Map;", "mostPopularFrameworks", "", "language", "Companion", "javascript"})
public final class JsDependenciesSnapshot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<VirtualFile> packageJsonFiles;
    private final boolean resolvedPackageJson;
    @NotNull
    private final Set<VirtualFile> tsConfigs;
    @NotNull
    private final Map<String, PackageJsonData.PackageJsonDependencyEntry> packages;

    public JsDependenciesSnapshot(@NotNull Set<? extends VirtualFile> packageJsonFiles, boolean resolvedPackageJson, @NotNull Set<? extends VirtualFile> tsConfigs, @NotNull Map<String, ? extends PackageJsonData.PackageJsonDependencyEntry> packages) {
        Intrinsics.checkNotNullParameter(packageJsonFiles, (String)"packageJsonFiles");
        Intrinsics.checkNotNullParameter(tsConfigs, (String)"tsConfigs");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        this.packageJsonFiles = packageJsonFiles;
        this.resolvedPackageJson = resolvedPackageJson;
        this.tsConfigs = tsConfigs;
        this.packages = packages;
    }

    @NotNull
    public final Set<VirtualFile> getPackageJsonFiles() {
        return this.packageJsonFiles;
    }

    @NotNull
    public final Map<String, PackageJsonData.PackageJsonDependencyEntry> getPackages() {
        return this.packages;
    }

    @NotNull
    public final List<String> mostPopularFrameworks() {
        List dependencies = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(this.packages), JsDependenciesSnapshot::mostPopularFrameworks$lambda$0), JsDependenciesSnapshot::mostPopularFrameworks$lambda$1));
        return dependencies;
    }

    @NotNull
    public final String language() {
        SemVer tsVersion;
        PackageJsonData.PackageJsonDependencyEntry packageJson;
        String language = "JavaScript";
        String languageVersion = "ES5";
        PackageJsonData.PackageJsonDependencyEntry packageJsonDependencyEntry = packageJson = this.packages.get("typescript");
        Object object = tsVersion = packageJsonDependencyEntry != null ? packageJsonDependencyEntry.parseVersion() : null;
        if (tsVersion != null) {
            language = "TypeScript";
            String string = tsVersion.getRawVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawVersion(...)");
            languageVersion = string;
        }
        return language + ": " + languageVersion;
    }

    private static final boolean mostPopularFrameworks$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return JavaScriptFrameworksKt.getMOST_POPULAR_PACKAGES().contains(entry.getKey()) && !StringsKt.startsWith$default((String)((String)entry.getKey()), (String)"@type", (boolean)false, (int)2, null);
    }

    private static final String mostPopularFrameworks$lambda$1(Map.Entry entry) {
        SemVer version;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String dependency = (String)entry.getKey();
        SemVer semVer = version = ((PackageJsonData.PackageJsonDependencyEntry)entry.getValue()).parseVersion();
        return semVer != null ? dependency + ": " + semVer : dependency;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/ide/javascript/JsDependenciesSnapshot$Companion;", "", "<init>", "()V", "create", "Lcc/unitmesh/ide/javascript/JsDependenciesSnapshot;", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "enumerateAllPackages", "", "", "Lcom/intellij/javascript/nodejs/PackageJsonData$PackageJsonDependencyEntry;", "set", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "findTsConfigs", "javascript"})
    @SourceDebugExtension(value={"SMAP\nJsDependenciesSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsDependenciesSnapshot.kt\ncc/unitmesh/ide/javascript/JsDependenciesSnapshot$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,97:1\n689#2:98\n722#2,4:99\n*S KotlinDebug\n*F\n+ 1 JsDependenciesSnapshot.kt\ncc/unitmesh/ide/javascript/JsDependenciesSnapshot$Companion\n*L\n83#1:98\n83#1:99,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsDependenciesSnapshot create(@NotNull Project project, @Nullable PsiFile psiFile2) {
            VirtualFile packageJson;
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Set packageJsonFiles = SetsKt.emptySet();
            boolean resolvedPackageJson = false;
            PsiFile psiFile3 = psiFile2;
            Object object = virtualFile = psiFile3 != null ? psiFile3.getVirtualFile() : null;
            if (virtualFile != null && (packageJson = PackageJsonUtil.findUpPackageJson((VirtualFile)virtualFile)) != null) {
                packageJsonFiles = SetsKt.setOf((Object)packageJson);
                resolvedPackageJson = true;
            }
            if (packageJsonFiles.isEmpty()) {
                Set set = PackageJsonFileManager.getInstance((Project)project).getValidPackageJsonFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getValidPackageJsonFiles(...)");
                packageJsonFiles = set;
            }
            Set<VirtualFile> tsConfigs = this.findTsConfigs(project, packageJsonFiles);
            Map<String, PackageJsonData.PackageJsonDependencyEntry> packages = this.enumerateAllPackages(packageJsonFiles);
            return new JsDependenciesSnapshot(packageJsonFiles, resolvedPackageJson, tsConfigs, packages);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, PackageJsonData.PackageJsonDependencyEntry> enumerateAllPackages(@NotNull Set<? extends VirtualFile> set) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter(set, (String)"set");
            Sequence $this$associateBy$iv = SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), Companion::enumerateAllPackages$lambda$0), Companion::enumerateAllPackages$lambda$1);
            boolean $i$f$associateBy = false;
            Sequence sequence = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Map.Entry it;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                it = (Map.Entry)element$iv$iv;
                String string = (String)k;
                boolean bl2 = false;
                PackageJsonData.PackageJsonDependencyEntry packageJsonDependencyEntry = (PackageJsonData.PackageJsonDependencyEntry)it.getValue();
                map.put(string, packageJsonDependencyEntry);
            }
            return destination$iv$iv;
        }

        private final Set<VirtualFile> findTsConfigs(Project project, Set<? extends VirtualFile> set) {
            Sequence mapNotNull = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)set), Companion::findTsConfigs$lambda$4);
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
            VirtualFile rootConfig = virtualFile != null ? virtualFile.findChild("tsconfig.json") : null;
            return SequencesKt.toSet((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)mapNotNull, (Object)rootConfig)));
        }

        private static final PackageJsonData enumerateAllPackages$lambda$0(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return PackageJsonData.getOrCreate((VirtualFile)it);
        }

        private static final Iterable enumerateAllPackages$lambda$1(PackageJsonData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getAllDependencyEntries().entrySet();
        }

        private static final VirtualFile findTsConfigs$lambda$4(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            VirtualFile virtualFile = it.getParent();
            return virtualFile != null ? virtualFile.findChild("tsconfig.json") : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

