/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.git.provider;

import cc.unitmesh.devti.devins.VariableActionEventDataHolder;
import cc.unitmesh.devti.devins.provider.ToolchainVariableProvider;
import cc.unitmesh.devti.devins.variable.ToolchainVariable;
import cc.unitmesh.devti.devins.variable.toolchain.VcsToolchainVariable;
import cc.unitmesh.devti.vcs.VcsPrompting;
import cc.unitmesh.git.provider.GitToolchainVariableProviderKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.vcs.commit.CommitWorkflowUi;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcc/unitmesh/git/provider/GitToolchainVariableProvider;", "Lcc/unitmesh/devti/devins/provider/ToolchainVariableProvider;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isResolvable", "", "variable", "Lcc/unitmesh/devti/devins/variable/ToolchainVariable;", "psiElement", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "editor", "Lcom/intellij/openapi/editor/Editor;", "analysisLog", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getHistoryCommitMessages", "collectExamples", "logProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filter", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "getDiff", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitWorkflowUi", "Lcom/intellij/vcs/commit/CommitWorkflowUi;", "ext-git"})
@SourceDebugExtension(value={"SMAP\nGitToolchainVariableProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitToolchainVariableProvider.kt\ncc/unitmesh/git/provider/GitToolchainVariableProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n11#2:198\n18#3:199\n26#4:200\n1549#5:201\n1620#5,3:202\n1549#5:205\n1620#5,3:206\n*S KotlinDebug\n*F\n+ 1 GitToolchainVariableProvider.kt\ncc/unitmesh/git/provider/GitToolchainVariableProvider\n*L\n29#1:198\n110#1:199\n110#1:200\n161#1:201\n161#1:202,3\n175#1:205\n175#1:206,3\n*E\n"})
public final class GitToolchainVariableProvider
implements ToolchainVariableProvider {
    @NotNull
    private final Logger logger;

    public GitToolchainVariableProvider() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitToolchainVariableProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    public boolean isResolvable(@NotNull ToolchainVariable variable, @Nullable PsiElement psiElement, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolchainVariable toolchainVariable = variable;
        return toolchainVariable == VcsToolchainVariable.CurrentChanges ? true : (toolchainVariable == VcsToolchainVariable.HistoryCommitMessages ? true : (toolchainVariable == VcsToolchainVariable.CurrentBranch ? true : toolchainVariable == VcsToolchainVariable.Diff));
    }

    @NotNull
    public ToolchainVariable resolve(@NotNull ToolchainVariable variable, @NotNull Project project, @NotNull Editor editor, @Nullable PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ToolchainVariable toolchainVariable = variable;
        if (toolchainVariable == VcsToolchainVariable.CurrentChanges) {
            CommitWorkflowUi commitWorkflowUi = GitToolchainVariableProviderKt.getCommitWorkflowUi();
            if (commitWorkflowUi == null) {
                this.logger.warn("Cannot get commit workflow UI, you may not be in a commit workflow.");
                return variable;
            }
            Ref.ObjectRef changes = new Ref.ObjectRef();
            EventQueue.invokeAndWait(() -> GitToolchainVariableProvider.resolve$lambda$0(changes, this, commitWorkflowUi));
            if (changes.element == null) {
                this.logger.warn("Cannot get changes.");
                return variable;
            }
            VcsPrompting vcsPrompting = (VcsPrompting)project.getService(VcsPrompting.class);
            Object object = changes.element;
            Intrinsics.checkNotNull((Object)object);
            String diffContext = VcsPrompting.prepareContext$default(vcsPrompting, (List)object, null, 2, null);
            if (((CharSequence)diffContext).length() == 0 || Intrinsics.areEqual((Object)diffContext, (Object)"\n")) {
                this.logger.warn("Diff context is empty or cannot get enough useful context.");
                return variable;
            }
            variable.setValue(diffContext);
            return variable;
        }
        if (toolchainVariable == VcsToolchainVariable.CurrentBranch) {
            Map logProviders = VcsProjectLog.Companion.getLogProviders(project);
            Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)logProviders.entrySet());
            if (entry == null) {
                return variable;
            }
            Map.Entry entry2 = entry;
            VcsLogProvider logProvider = (VcsLogProvider)entry2.getValue();
            String string = logProvider.getCurrentBranch((VirtualFile)entry2.getKey());
            if (string == null) {
                return variable;
            }
            String branch = string;
            variable.setValue(branch);
        } else if (toolchainVariable == VcsToolchainVariable.HistoryCommitMessages) {
            String exampleCommitMessages = this.getHistoryCommitMessages(project);
            if (exampleCommitMessages != null) {
                variable.setValue(exampleCommitMessages);
            }
        } else if (toolchainVariable == VcsToolchainVariable.Diff) {
            VariableActionEventDataHolder variableActionEventDataHolder = VariableActionEventDataHolder.Companion.getData();
            DataContext dataContext = variableActionEventDataHolder != null ? variableActionEventDataHolder.getDataContext() : null;
            variable.setValue(this.analysisLog(dataContext, project));
        }
        return variable;
    }

    private final String analysisLog(DataContext dataContext, Project project) {
        if (dataContext == null) {
            return "";
        }
        VcsLog vcsLog = (VcsLog)dataContext.getData(VcsLogDataKeys.VCS_LOG);
        if (vcsLog == null) {
            return "";
        }
        VcsLog vcsLog2 = vcsLog;
        List list = vcsLog2.getSelectedDetails();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedDetails(...)");
        List details = CollectionsKt.toList((Iterable)list);
        Object[] $this$orEmpty$iv = (Object[])dataContext.getData(VcsDataKeys.SELECTED_CHANGES);
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new Change[]{};
        }
        List selectList = ArraysKt.toList((Object[])objectArray);
        VcsPrompting vcsPrompting = (VcsPrompting)project.getService(VcsPrompting.class);
        String fullChangeContent = VcsPrompting.buildDiffPrompt$default(vcsPrompting, details, CollectionsKt.toList((Iterable)selectList), project, null, 0, 24, null);
        String string = fullChangeContent;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getHistoryCommitMessages(Project project) {
        VcsLogFilterCollection vcsLogFilterCollection;
        Map logProviders = VcsProjectLog.Companion.getLogProviders(project);
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)logProviders.entrySet());
        if (entry == null) {
            return null;
        }
        Map.Entry entry2 = entry;
        VcsLogProvider logProvider = (VcsLogProvider)entry2.getValue();
        String string = logProvider.getCurrentBranch((VirtualFile)entry2.getKey());
        if (string == null) {
            return null;
        }
        String branch = string;
        VcsUser user = logProvider.getCurrentUser((VirtualFile)entry2.getKey());
        if (user != null) {
            var8_7 = new VcsLogFilter[]{VcsLogFilterObject.fromUser((VcsUser)user, (Set)SetsKt.emptySet())};
            vcsLogFilterCollection = VcsLogFilterObject.collection((VcsLogFilter[])var8_7);
        } else {
            var8_7 = new VcsLogFilter[]{VcsLogFilterObject.fromBranch((String)branch)};
            vcsLogFilterCollection = VcsLogFilterObject.collection((VcsLogFilter[])var8_7);
        }
        VcsLogFilterCollection logFilter = vcsLogFilterCollection;
        return this.collectExamples(logProvider, (VirtualFile)entry2.getKey(), logFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final String collectExamples(VcsLogProvider logProvider, VirtualFile root, VcsLogFilterCollection filter) {
        void $this$mapTo$iv$iv;
        List list = logProvider.getCommitsMatchingFilter(root, filter, 3);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCommitsMatchingFilter(...)");
        List commits = list;
        if (commits.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("");
        Iterable $this$map$iv = commits;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimedVcsCommit timedVcsCommit = (TimedVcsCommit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Hash)it.getId()).asString());
        }
        List commitIds = (List)destination$iv$iv;
        logProvider.readMetadata(root, commitIds, arg_0 -> GitToolchainVariableProvider.collectExamples$lambda$3(arg_0 -> GitToolchainVariableProvider.collectExamples$lambda$2(builder, arg_0), arg_0));
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Change> getDiff(CommitWorkflowUi commitWorkflowUi) {
        void $this$mapTo$iv$iv;
        List changes = commitWorkflowUi.getIncludedChanges();
        List unversionedFiles = commitWorkflowUi.getIncludedUnversionedFiles();
        Iterable $this$map$iv = unversionedFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePath filePath = (FilePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Change(null, (ContentRevision)new CurrentContentRevision((FilePath)it)));
        }
        List changeList = (List)destination$iv$iv;
        if (!((Collection)changes).isEmpty() || !((Collection)changeList).isEmpty()) {
            return CollectionsKt.plus((Collection)changes, (Iterable)changeList);
        }
        return null;
    }

    private static final void resolve$lambda$0(Ref.ObjectRef $changes, GitToolchainVariableProvider this$0, CommitWorkflowUi $commitWorkflowUi) {
        $changes.element = this$0.getDiff($commitWorkflowUi);
    }

    private static final Unit collectExamples$lambda$2(StringBuilder $builder, VcsCommitMetadata it) {
        String string = it.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        String[] stringArray = new String[]{"\n"};
        String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (string2 == null) {
            String string3 = it.getFullMessage();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullMessage(...)");
        }
        String shortMsg = string2;
        $builder.append(shortMsg).append("\n");
        return Unit.INSTANCE;
    }

    private static final void collectExamples$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

