/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.git.mcp;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.NoArgs;
import cc.unitmesh.devti.mcp.host.Response;
import cc.unitmesh.git.mcp.VcsToolsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/git/mcp/GetVcsStatusTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/devti/mcp/host/NoArgs;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "ext-git"})
@SourceDebugExtension(value={"SMAP\nvcsTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 vcsTools.kt\ncc/unitmesh/git/mcp/GetVcsStatusTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1603#2,9:114\n1855#2:123\n1856#2:125\n1612#2:126\n1#3:124\n*S KotlinDebug\n*F\n+ 1 vcsTools.kt\ncc/unitmesh/git/mcp/GetVcsStatusTool\n*L\n90#1:114,9\n90#1:123\n90#1:125\n90#1:126\n90#1:124\n*E\n"})
public final class GetVcsStatusTool
extends AbstractMcpTool<NoArgs> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public GetVcsStatusTool() {
        this.name = "get_project_vcs_status";
        this.description = "\n        Retrieves the current version control status of files in the project.\n        Use this tool to get information about modified, added, deleted, and moved files in your VCS (e.g., Git).\n        Returns a JSON-formatted list of changed files, where each entry contains:\n        - path: The file path relative to project root\n        - type: The type of change (e.g., MODIFICATION, ADDITION, DELETION, MOVED)\n        Returns an empty list ([]) if no changes are detected or VCS is not configured.\n        Returns error \"project dir not found\" if project directory cannot be determined.\n        Note: Works with any VCS supported by the IDE, but is most commonly used with Git\n    ";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull NoArgs args) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = VcsToolsKt.toNioPathOrNull((VirtualFile)object)) == null) {
            return new Response(null, "project dir not found", 1, null);
        }
        Object projectDir = object;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Collection collection = changeListManager2.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
        Collection changes = collection;
        Iterable $this$mapNotNull$iv = changes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Change change = (Change)element$iv$iv;
            boolean bl2 = false;
            Object object2 = change.getVirtualFile();
            if (object2 == null || (object2 = object2.getPath()) == null) {
                ContentRevision contentRevision = change.getAfterRevision();
                object2 = contentRevision != null && (contentRevision = contentRevision.getFile()) != null ? contentRevision.getPath() : null;
            }
            Object absolutePath = object2;
            Intrinsics.checkNotNullExpressionValue((Object)change.getType(), (String)"getType(...)");
            if (absolutePath != null) {
                Pair pair2;
                try {
                    Change.Type changeType;
                    Path path = Paths.get((String)absolutePath, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    String relativePath = ((Object)projectDir.relativize(path)).toString();
                    pair2 = TuplesKt.to((Object)relativePath, (Object)changeType);
                }
                catch (IllegalArgumentException e) {
                    pair2 = null;
                }
                pair = pair2;
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        String string = null;
        String string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",\n", (CharSequence)"[", (CharSequence)"]", (int)0, null, GetVcsStatusTool::handle$lambda$1, (int)24, null);
        return new Response(string2, string, n, defaultConstructorMarker);
    }

    private static final CharSequence handle$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "{\"path\": \"" + it.getFirst() + "\", \"type\": \"" + it.getSecond() + "\"}";
    }
}

