/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.git.mcp;

import cc.unitmesh.devti.mcp.host.AbstractMcpTool;
import cc.unitmesh.devti.mcp.host.Response;
import cc.unitmesh.git.mcp.CommitQuery;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitCommit;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcc/unitmesh/git/mcp/FindCommitByTextTool;", "Lcc/unitmesh/devti/mcp/host/AbstractMcpTool;", "Lcc/unitmesh/git/mcp/CommitQuery;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "description", "getDescription", "handle", "Lcc/unitmesh/devti/mcp/host/Response;", "project", "Lcom/intellij/openapi/project/Project;", "args", "ext-git"})
@SourceDebugExtension(value={"SMAP\nvcsTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 vcsTools.kt\ncc/unitmesh/git/mcp/FindCommitByTextTool\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n11383#2,9:114\n13309#2:123\n13310#2:125\n11392#2:126\n1#3:124\n1855#4:127\n1855#4,2:128\n1856#4:130\n*S KotlinDebug\n*F\n+ 1 vcsTools.kt\ncc/unitmesh/git/mcp/FindCommitByTextTool\n*L\n35#1:114,9\n35#1:123\n35#1:125\n35#1:126\n35#1:124\n42#1:127\n48#1:128,2\n42#1:130\n*E\n"})
public final class FindCommitByTextTool
extends AbstractMcpTool<CommitQuery> {
    @NotNull
    private final String name;
    @NotNull
    private final String description;

    public FindCommitByTextTool() {
        this.name = "find_commit_by_message";
        this.description = "\n        Searches for a commit based on the provided text or keywords in the project history.\n        Useful for finding specific change sets or code modifications by commit messages or diff content.\n        Takes a query parameter and returns the matching commit information.\n        Returns matched commit hashes as a JSON array.\n    ";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Response handle(@NotNull Project project, @NotNull CommitQuery args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String queryText = args.getText();
        List matchingCommits = new ArrayList();
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            VcsRoot[] vcsRootArray = ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
            Object[] objectArray = vcsRootArray;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                VirtualFile it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                VcsRoot it = (VcsRoot)element$iv$iv;
                boolean bl2 = false;
                if (it.getPath() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List vcs = (List)destination$iv$iv;
            if (vcs.isEmpty()) {
                return new Response("Error: No VCS configured for this project", null, 2, null);
            }
            Iterable $this$forEach$iv = vcs;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                List gitLog;
                GitRepository repository;
                VirtualFile vcsRoot = (VirtualFile)element$iv;
                boolean bl = false;
                if ((GitRepository)GitRepositoryManager.getInstance((Project)project).getRepositoryForRoot(vcsRoot) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)GitHistoryUtils.history((Project)project, (VirtualFile)repository.getRoot(), (String[])new String[0]), (String)"history(...)");
                Iterable $this$forEach$iv2 = gitLog;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    GitCommit commit = (GitCommit)element$iv2;
                    boolean bl4 = false;
                    String string = commit.getFullMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
                    if (!StringsKt.contains((CharSequence)string, (CharSequence)queryText, (boolean)true)) continue;
                    matchingCommits.add(commit.getId().toString());
                }
            }
            return !((Collection)matchingCommits).isEmpty() ? new Response(CollectionsKt.joinToString$default((Iterable)matchingCommits, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, FindCommitByTextTool::handle$lambda$3, (int)24, null), null, 2, null) : new Response("No commits found matching the query: " + queryText, null, 2, null);
        }
        catch (Exception e) {
            return new Response("Error while searching commits: " + e.getMessage(), null, 2, null);
        }
    }

    private static final CharSequence handle$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }
}

