/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.git.actions.vcs;

import cc.unitmesh.git.actions.vcs.PrepushReviewAction;
import cc.unitmesh.git.actions.vcs.StructureDiagramBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/git/actions/vcs/PrepushReviewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "previewFile", "Lcom/intellij/testFramework/LightVirtualFile;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showNoChangesDialog", "project", "Lcom/intellij/openapi/project/Project;", "showMermaidDiagramPopup", "mermaidContent", "", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Companion", "ext-git"})
@SourceDebugExtension(value={"SMAP\nPrepushReviewAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepushReviewAction.kt\ncc/unitmesh/git/actions/vcs/PrepushReviewAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n288#2,2:130\n*S KotlinDebug\n*F\n+ 1 PrepushReviewAction.kt\ncc/unitmesh/git/actions/vcs/PrepushReviewAction\n*L\n120#1:130,2\n*E\n"})
public final class PrepushReviewAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private LightVirtualFile previewFile;
    @NotNull
    private static final Key<TextEditorWithPreview.Layout> LAYOUT_KEY;

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Collection collection = changeListManager2.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
        List changes = CollectionsKt.toList((Iterable)collection);
        if (changes.isEmpty()) {
            this.showNoChangesDialog(project2);
            return;
        }
        StructureDiagramBuilder structureDiagramBuilder = new StructureDiagramBuilder(project2, changes);
        String mermaidContent = structureDiagramBuilder.build();
        this.showMermaidDiagramPopup(project2, mermaidContent);
    }

    private final void showNoChangesDialog(Project project) {
        JPanel jPanel;
        JPanel $this$showNoChangesDialog_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$showNoChangesDialog_u24lambda_u240.setPreferredSize(new Dimension(300, 100));
        $this$showNoChangesDialog_u24lambda_u240.setBorder(JBUI.Borders.empty((int)16));
        $this$showNoChangesDialog_u24lambda_u240.add((Component)new JLabel("No changes detected for review."), "Center");
        JPanel panel2 = jPanel;
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, null).setTitle("Prepush Review").setResizable(false).setMovable(true).setRequestFocus(true).setCancelOnClickOutside(true).createPopup().showCenteredInCurrentWindow(project);
    }

    private final void showMermaidDiagramPopup(Project project, String mermaidContent) {
        ApplicationManager.getApplication().invokeLater(() -> PrepushReviewAction.showMermaidDiagramPopup$lambda$1(this, mermaidContent, project));
    }

    private final FileEditor createEditor(String mermaidContent, Project project) {
        FileEditorProvider fileEditorProvider;
        Object v0;
        LightVirtualFile virtualFile;
        block2: {
            long time = System.currentTimeMillis();
            virtualFile = new LightVirtualFile("mermaid-" + time + ".mmd", (CharSequence)mermaidContent);
            virtualFile.putUserData(Key.create((String)"TextEditorWithPreview.DefaultLayout"), (Object)TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW);
            Iterable $this$firstOrNull$iv = FileEditorProvider.EP_FILE_EDITOR_PROVIDER.getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileEditorProvider it = (FileEditorProvider)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)"MermaidEditorWithPreviewProvider") || Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)"MermaidSplitEditorProvider"))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((fileEditorProvider = (FileEditorProvider)v0) == null) {
            fileEditorProvider = (FileEditorProvider)TextEditorProvider.Companion.getInstance();
        }
        FileEditorProvider editorProvider = fileEditorProvider;
        FileEditor fileEditor2 = editorProvider.createEditor(project, (VirtualFile)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor2, (String)"createEditor(...)");
        FileEditor editor = fileEditor2;
        return editor;
    }

    private static final void showMermaidDiagramPopup$lambda$1(PrepushReviewAction this$0, String $mermaidContent, Project $project) {
        FileEditor editor = this$0.createEditor($mermaidContent, $project);
        new DialogWrapper(editor, $project){
            private final showMermaidDiagramPopup.1.refreshAction.1 refreshAction;
            final /* synthetic */ FileEditor $editor;
            {
                this.$editor = $editor;
                super($project);
                this.refreshAction = new DialogWrapper.DialogWrapperAction(this, $editor){
                    final /* synthetic */ FileEditor $editor;
                    {
                        this.$editor = $editor;
                        super((DialogWrapper)$receiver, "Refresh");
                    }

                    protected void doAction(ActionEvent e) {
                        this.$editor.selectNotify();
                        this.$editor.getComponent().revalidate();
                        this.$editor.getComponent().repaint();
                    }
                };
                this.setTitle("Prepush Review in Diagram");
                this.setOKButtonText("Accept");
                this.setSize(1200, 800);
                this.init();
                $editor.selectNotify();
            }

            protected void doOKAction() {
                super.doOKAction();
            }

            protected Action[] createActions() {
                Action[] actionArray = new Action[]{this.refreshAction, this.getOKAction(), this.getCancelAction()};
                return actionArray;
            }

            protected JComponent createCenterPanel() {
                JComponent jComponent = this.$editor.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                return jComponent;
            }

            protected void dispose() {
                Disposer.dispose((Disposable)((Disposable)this.$editor));
                super.dispose();
            }
        }.showAndGet();
    }

    static {
        Key key = Key.create((String)"TextEditorWithPreview.DefaultLayout");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LAYOUT_KEY = key;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcc/unitmesh/git/actions/vcs/PrepushReviewAction$Companion;", "", "<init>", "()V", "LAYOUT_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "ext-git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

