/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.git.actions.vcs;

import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.actions.chat.base.ChatBaseAction;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.LlmFactory;
import cc.unitmesh.devti.settings.locale.LanguageChangedCallback;
import cc.unitmesh.devti.statusbar.AutoDevStatus;
import cc.unitmesh.devti.template.TemplateRender;
import cc.unitmesh.devti.util.AutoDevCoroutineScope;
import cc.unitmesh.devti.util.parser.CodeFence;
import cc.unitmesh.devti.vcs.VcsPrompting;
import cc.unitmesh.devti.vcs.VcsUtil;
import cc.unitmesh.git.actions.vcs.CommitMessageSuggestionAction;
import cc.unitmesh.git.actions.vcs.CommitMsgGenContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.vcs.commit.CommitWorkflowUi;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcc/unitmesh/git/actions/vcs/CommitMessageSuggestionAction;", "Lcc/unitmesh/devti/actions/chat/base/ChatBaseAction;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "currentJob", "Lkotlinx/coroutines/Job;", "getActionType", "Lcc/unitmesh/devti/gui/chat/message/ChatActionType;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "executeAction", "event", "findExampleCommitMessages", "", "project", "Lcom/intellij/openapi/project/Project;", "collectExamples", "logProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filter", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "generateCommitMessage", "diff", "originText", "getChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitWorkflowUi", "Lcom/intellij/vcs/commit/CommitWorkflowUi;", "ext-git"})
@SourceDebugExtension(value={"SMAP\nCommitMessageSuggestionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitMessageSuggestionAction.kt\ncc/unitmesh/git/actions/vcs/CommitMessageSuggestionAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n11#2:231\n31#3,2:232\n31#3,2:234\n1549#4:236\n1620#4,3:237\n1549#4:240\n1620#4,3:241\n*S KotlinDebug\n*F\n+ 1 CommitMessageSuggestionAction.kt\ncc/unitmesh/git/actions/vcs/CommitMessageSuggestionAction\n*L\n37#1:231\n57#1:232,2\n78#1:234,2\n178#1:236\n178#1:237,3\n213#1:240\n213#1:241,3\n*E\n"})
public final class CommitMessageSuggestionAction
extends ChatBaseAction {
    @NotNull
    private final Logger logger;
    @Nullable
    private Job currentJob;

    public CommitMessageSuggestionAction() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommitMessageSuggestionAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
        LanguageChangedCallback.presentationText$default(LanguageChangedCallback.INSTANCE, "settings.autodev.others.commitMessage", presentation, 0, 4, null);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    @NotNull
    public ChatActionType getActionType() {
        return ChatActionType.GEN_COMMIT_MESSAGE;
    }

    public void update(@NotNull AnActionEvent e) {
        VcsPrompting vcsPrompting;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CommitMessageI data = (CommitMessageI)e.getData(VcsDataKeys.COMMIT_MESSAGE_CONTROL);
        if (data == null) {
            e.getPresentation().setIcon(AutoDevStatus.WAITING.getIcon());
            e.getPresentation().setEnabled(false);
            return;
        }
        Project project = e.getProject();
        if (project != null) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VcsPrompting> serviceClass$iv = VcsPrompting.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            vcsPrompting = (VcsPrompting)object;
        } else {
            vcsPrompting = null;
        }
        VcsPrompting prompting2 = vcsPrompting;
        e.getPresentation().setIcon(AutoDevStatus.Ready.getIcon());
        VcsPrompting vcsPrompting2 = prompting2;
        e.getPresentation().setEnabled(vcsPrompting2 != null ? vcsPrompting2.hasChanges() : false);
    }

    @Override
    public void executeAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        CommitWorkflowUi commitWorkflowUi = VcsUtil.INSTANCE.getCommitWorkFlowUi(event);
        if (commitWorkflowUi == null) {
            AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, project2, "Cannot get commit workflow UI.", null, 4, null);
            return;
        }
        List<Change> changes = this.getChanges(commitWorkflowUi);
        if (changes == null || changes.isEmpty()) {
            AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, project2, "No changes to commit. Do you select any files?", null, 4, null);
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<VcsPrompting> serviceClass$iv = VcsPrompting.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        String diffContext = VcsPrompting.prepareContext$default((VcsPrompting)object, changes, null, 2, null);
        if (((CharSequence)diffContext).length() == 0 || Intrinsics.areEqual((Object)diffContext, (Object)"\n")) {
            this.logger.warn("Diff context is empty or cannot get enough useful context.");
            AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, project2, "Diff context is empty or cannot get enough useful context.", null, 4, null);
            return;
        }
        Object object2 = event.getData(VcsDataKeys.COMMIT_MESSAGE_CONTROL);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.ui.CommitMessage");
        EditorTextField editorTextField = ((CommitMessage)object2).getEditorField();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
        EditorTextField editorField = editorTextField;
        Object object3 = editorField.getEditor();
        if (object3 == null || (object3 = object3.getSelectionModel()) == null || (object3 = object3.getSelectedText()) == null) {
            object3 = "";
        }
        Object originText = object3;
        Job job = this.currentJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        editorField.setText("");
        event.getPresentation().setIcon(AutoDevStatus.InProgress.getIcon());
        ApplicationManager.getApplication().executeOnPooledThread(() -> CommitMessageSuggestionAction.executeAction$lambda$0(this, diffContext, project2, (String)originText, event, editorField));
    }

    private final String findExampleCommitMessages(Project project) {
        VcsLogFilterCollection vcsLogFilterCollection;
        Map logProviders = VcsProjectLog.Companion.getLogProviders(project);
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)logProviders.entrySet());
        if (entry == null) {
            return null;
        }
        Map.Entry entry2 = entry;
        VcsLogProvider logProvider = (VcsLogProvider)entry2.getValue();
        String string = logProvider.getCurrentBranch((VirtualFile)entry2.getKey());
        if (string == null) {
            return null;
        }
        String branch = string;
        VcsUser user = logProvider.getCurrentUser((VirtualFile)entry2.getKey());
        if (user != null) {
            var8_7 = new VcsLogFilter[]{VcsLogFilterObject.fromUser((VcsUser)user, (Set)SetsKt.emptySet())};
            vcsLogFilterCollection = VcsLogFilterObject.collection((VcsLogFilter[])var8_7);
        } else {
            var8_7 = new VcsLogFilter[]{VcsLogFilterObject.fromBranch((String)branch)};
            vcsLogFilterCollection = VcsLogFilterObject.collection((VcsLogFilter[])var8_7);
        }
        VcsLogFilterCollection logFilter = vcsLogFilterCollection;
        return this.collectExamples(logProvider, (VirtualFile)entry2.getKey(), logFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final String collectExamples(VcsLogProvider logProvider, VirtualFile root, VcsLogFilterCollection filter) {
        void $this$mapTo$iv$iv;
        List list = logProvider.getCommitsMatchingFilter(root, filter, 3);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCommitsMatchingFilter(...)");
        List commits = list;
        if (commits.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("");
        Iterable $this$map$iv = commits;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimedVcsCommit timedVcsCommit = (TimedVcsCommit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Hash)it.getId()).asString());
        }
        List commitIds = (List)destination$iv$iv;
        logProvider.readMetadata(root, commitIds, arg_0 -> CommitMessageSuggestionAction.collectExamples$lambda$3(arg_0 -> CommitMessageSuggestionAction.collectExamples$lambda$2(builder, arg_0), arg_0));
        return builder.toString();
    }

    private final String generateCommitMessage(String diff, Project project, String originText) {
        String string;
        TemplateRender templateRender = new TemplateRender("/practises");
        String template = templateRender.getTemplate("gen-commit-msg.vm");
        try {
            String string2 = this.findExampleCommitMessages(project);
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
        }
        catch (Exception e) {
            this.logger.warn("Cannot get example commit messages.", (Throwable)e);
            string = "";
        }
        String historyExamples = string;
        templateRender.setContext(new CommitMsgGenContext(historyExamples, diff, originText));
        String prompter = TemplateRender.renderTemplate$default(templateRender, template, null, 2, null);
        this.logger.info("Prompt: " + prompter);
        return prompter;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Change> getChanges(@NotNull CommitWorkflowUi commitWorkflowUi) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commitWorkflowUi, (String)"commitWorkflowUi");
        List changes = commitWorkflowUi.getIncludedChanges();
        List unversionedFiles = commitWorkflowUi.getIncludedUnversionedFiles();
        Iterable $this$map$iv = unversionedFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePath filePath = (FilePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Change(null, (ContentRevision)new CurrentContentRevision((FilePath)it)));
        }
        List unversionedFileChanges = (List)destination$iv$iv;
        if (!((Collection)changes).isEmpty() || !((Collection)unversionedFileChanges).isEmpty()) {
            return CollectionsKt.plus((Collection)changes, (Iterable)unversionedFileChanges);
        }
        return null;
    }

    private static final void executeAction$lambda$0(CommitMessageSuggestionAction this$0, String $diffContext, Project $project, String $originText, AnActionEvent $event, EditorTextField $editorField) {
        String prompt2 = this$0.generateCommitMessage($diffContext, $project, $originText);
        this$0.logger.info(prompt2);
        try {
            Flow stream2 = LLMProvider.DefaultImpls.stream$default(LlmFactory.INSTANCE.create($project), prompt2, "", false, false, 8, null);
            this$0.currentJob = BuildersKt.launch$default((CoroutineScope)AutoDevCoroutineScope.Companion.scope($project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Flow<String>)stream2, this$0, $editorField, $project, $event, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Flow<String> $stream;
                final /* synthetic */ CommitMessageSuggestionAction this$0;
                final /* synthetic */ EditorTextField $editorField;
                final /* synthetic */ Project $project;
                final /* synthetic */ AnActionEvent $event;
                {
                    this.$stream = $stream;
                    this.this$0 = $receiver;
                    this.$editorField = $editorField;
                    this.$project = $project;
                    this.$event = $event;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            finalText = new Ref.ObjectRef();
                            finalText.element = "";
                            this.L$0 = $this$launch;
                            this.L$1 = finalText;
                            this.label = 1;
                            v0 = FlowKt.cancellable(this.$stream).collect(new FlowCollector((Ref.ObjectRef<String>)finalText, $this$launch, this.$editorField){
                                final /* synthetic */ Ref.ObjectRef<String> $finalText;
                                final /* synthetic */ CoroutineScope $$this$launch;
                                final /* synthetic */ EditorTextField $editorField;
                                {
                                    this.$finalText = $finalText;
                                    this.$$this$launch = $$this$launch;
                                    this.$editorField = $editorField;
                                }

                                public final Object emit(String chunk, Continuation<? super Unit> $completion) {
                                    this.$finalText.element = this.$finalText.element + chunk;
                                    ActionsKt.invokeLater$default(null, () -> executeAction.1.1.emit$lambda$0(this.$$this$launch, this.$editorField, chunk), (int)1, null);
                                    return Unit.INSTANCE;
                                }

                                private static final Unit emit$lambda$0(CoroutineScope $$this$launch, EditorTextField $editorField, String $chunk) {
                                    if (CoroutineScopeKt.isActive((CoroutineScope)$$this$launch)) {
                                        $editorField.setText($editorField.getText() + $chunk);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            ** if (v0 != var4_2) goto lbl16
lbl15:
                            // 1 sources

                            return var4_2;
lbl16:
                            // 1 sources

                            ** GOTO lbl24
                        }
                        case 1: {
                            finalText = (Ref.ObjectRef)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl24:
                                // 2 sources

                                if (!CoroutineScopeKt.isActive((CoroutineScope)$this$launch) || !StringsKt.startsWith$default((String)((String)finalText.element), (String)"```", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)((String)finalText.element), (String)"```", (boolean)false, (int)2, null)) ** GOTO lbl27
                                ActionsKt.invokeLater$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.ui.EditorTextField kotlin.jvm.internal.Ref$ObjectRef ), ()Lkotlin/Unit;)((EditorTextField)this.$editorField, (Ref.ObjectRef)finalText), (int)1, null);
                                ** GOTO lbl29
lbl27:
                                // 1 sources

                                if (!CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) ** GOTO lbl29
                                ActionsKt.invokeLater$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.ui.EditorTextField kotlin.jvm.internal.Ref$ObjectRef ), ()Lkotlin/Unit;)((EditorTextField)this.$editorField, (Ref.ObjectRef)finalText), (int)1, null);
                            }
                            catch (Exception e) {
                                CommitMessageSuggestionAction.access$getLogger$p(this.this$0).error("Error during commit message generation", (Throwable)e);
                                ActionsKt.invokeLater$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(com.intellij.openapi.project.Project java.lang.Exception ), ()Lkotlin/Unit;)((Project)this.$project, (Exception)e), (int)1, null);
                                ** GOTO lbl41
                            }
lbl29:
                            // 3 sources

                            ActionsKt.invokeLater$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(com.intellij.openapi.actionSystem.AnActionEvent ), ()Lkotlin/Unit;)((AnActionEvent)this.$event), (int)1, null);
                            ** GOTO lbl41
                        }
                        {
                            finally {
                                ActionsKt.invokeLater$default(null, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(com.intellij.openapi.actionSystem.AnActionEvent ), ()Lkotlin/Unit;)((AnActionEvent)this.$event), (int)1, null);
                            }
                        }
lbl41:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(EditorTextField $editorField, Ref.ObjectRef $finalText) {
                    $editorField.setText(CodeFence.Companion.parse((String)$finalText.element).getText());
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$1(EditorTextField $editorField, Ref.ObjectRef $finalText) {
                    $editorField.setText(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)((String)$finalText.element), (CharSequence)"```\n"), (CharSequence)"```"));
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$2(Project $project, Exception $e) {
                    AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, $project, "Error generating commit message: " + $e.getMessage(), null, 4, null);
                    return Unit.INSTANCE;
                }

                private static final Unit invokeSuspend$lambda$3(AnActionEvent $event) {
                    $event.getPresentation().setIcon(AutoDevStatus.Ready.getIcon());
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
        }
        catch (Exception e) {
            this$0.logger.error("Failed to start commit message generation", (Throwable)e);
            $event.getPresentation().setIcon(AutoDevStatus.Error.getIcon());
            AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, $project, "Failed to start commit message generation: " + e.getMessage(), null, 4, null);
        }
    }

    private static final Unit collectExamples$lambda$2(StringBuilder $builder, VcsCommitMetadata it) {
        String string = it.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        String[] stringArray = new String[]{"\n"};
        String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (string2 == null) {
            String string3 = it.getFullMessage();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFullMessage(...)");
        }
        String shortMsg = string2;
        $builder.append(shortMsg).append("\n");
        return Unit.INSTANCE;
    }

    private static final void collectExamples$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(CommitMessageSuggestionAction $this) {
        return $this.logger;
    }
}

