/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.git.actions.vcs;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.actions.chat.base.ChatBaseAction;
import cc.unitmesh.devti.flow.kanban.impl.GitHubIssue;
import cc.unitmesh.devti.flow.model.SimpleStory;
import cc.unitmesh.devti.gui.SendToWindowKt;
import cc.unitmesh.devti.gui.chat.ChatCodingService;
import cc.unitmesh.devti.gui.chat.NormalChatCodingPanel;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.provider.context.ChatContextItem;
import cc.unitmesh.devti.provider.context.ChatContextProvider;
import cc.unitmesh.devti.provider.context.ChatCreationContext;
import cc.unitmesh.devti.provider.context.ChatOrigin;
import cc.unitmesh.devti.settings.devops.AutoDevDevOpsConfigurableProviderKt;
import cc.unitmesh.devti.settings.devops.AutoDevDevOpsSettingService;
import cc.unitmesh.devti.settings.locale.LanguageChangedCallback;
import cc.unitmesh.devti.template.TemplateRender;
import cc.unitmesh.devti.vcs.VcsPrompting;
import cc.unitmesh.git.actions.vcs.CodeReviewActionKt;
import cc.unitmesh.git.actions.vcs.CodeReviewContext;
import cc.unitmesh.git.actions.vcs.StructureDiagramBuilder;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.changelog.CommitParser;
import org.changelog.CommitReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JA\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/git/actions/vcs/CodeReviewAction;", "Lcc/unitmesh/devti/actions/chat/base/ChatBaseAction;", "<init>", "()V", "getActionType", "Lcc/unitmesh/devti/gui/chat/message/ChatActionType;", "commitParser", "Lorg/changelog/CommitParser;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "doReviewWithChanges", "project", "Lcom/intellij/openapi/project/Project;", "details", "", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "selectList", "", "Lcom/intellij/openapi/vcs/changes/Change;", "stories", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;[Lcom/intellij/openapi/vcs/changes/Change;Ljava/util/List;)V", "doCodeReview", "context", "Lcc/unitmesh/git/actions/vcs/CodeReviewContext;", "fetchKanbanByCommits", "repository", "Lcom/intellij/dvcs/repo/Repository;", "Companion", "ext-git"})
@SourceDebugExtension(value={"SMAP\nCodeReviewAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeReviewAction.kt\ncc/unitmesh/git/actions/vcs/CodeReviewAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,157:1\n31#2,2:158\n1549#3:160\n1620#3,3:161\n1855#3,2:164\n11#4:166\n*S KotlinDebug\n*F\n+ 1 CodeReviewAction.kt\ncc/unitmesh/git/actions/vcs/CodeReviewAction\n*L\n75#1:158,2\n133#1:160\n133#1:161,3\n137#1:164,2\n148#1:166\n*E\n"})
public class CodeReviewAction
extends ChatBaseAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommitParser commitParser;
    @NotNull
    private static final Logger log;

    public CodeReviewAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getTemplatePresentation(...)");
        LanguageChangedCallback.presentationText$default(LanguageChangedCallback.INSTANCE, "settings.autodev.others.codeReview", presentation, 0, 4, null);
        this.commitParser = new CommitParser(null, 1, null);
    }

    @Override
    @NotNull
    public ChatActionType getActionType() {
        return ChatActionType.CODE_REVIEW;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VcsLog vcsLog = (VcsLog)event.getData(VcsLogDataKeys.VCS_LOG);
        Object object = vcsLog;
        if (object == null || (object = object.getSelectedDetails()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            return;
        }
        Object details = object;
        Change[] changeArray = (Change[])event.getData(VcsDataKeys.SELECTED_CHANGES);
        if (changeArray == null) {
            return;
        }
        Change[] selectList = changeArray;
        Ref.ObjectRef stories = new Ref.ObjectRef();
        stories.element = CollectionsKt.emptyList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CodeReviewAction.actionPerformed$lambda$0(project2, stories, this, (List)details), "Prepare Repository", true, project2);
        this.doReviewWithChanges(project2, (List<? extends VcsFullCommitDetails>)details, selectList, (List)stories.element);
    }

    public void doReviewWithChanges(@NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> details, @NotNull Change[] selectList, @NotNull List<String> stories) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)selectList, (String)"selectList");
        Intrinsics.checkNotNullParameter(stories, (String)"stories");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<VcsPrompting> serviceClass$iv = VcsPrompting.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VcsPrompting vcsPrompting = (VcsPrompting)object;
        List changes = ArraysKt.toList((Object[])selectList);
        String fullChangeContent = VcsPrompting.buildDiffPrompt$default(vcsPrompting, details, changes, project, null, 0, 24, null);
        String structureContext = "```mermaid\n" + new StructureDiagramBuilder(project, changes).build() + "\n```";
        if (fullChangeContent == null) {
            AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, project, "No code to review.", null, 4, null);
            return;
        }
        ChatCreationContext creationContext = new ChatCreationContext(ChatOrigin.Intention, this.getActionType(), null, CollectionsKt.emptyList(), null);
        List contextItems2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ChatContextItem>>, Object>(project, creationContext, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ ChatCreationContext $creationContext;
            {
                this.$project = $project;
                this.$creationContext = $creationContext;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ChatContextProvider.Companion.collectChatContextList(this.$project, this.$creationContext, (Continuation<? super List<ChatContextItem>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<ChatContextItem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        CodeReviewContext context = new CodeReviewContext(CollectionsKt.joinToString$default((Iterable)contextItems2, (CharSequence)"\n", null, null, (int)0, null, CodeReviewAction::doReviewWithChanges$lambda$1, (int)30, null), CollectionsKt.toMutableList((Collection)stories), fullChangeContent, structureContext);
        this.doCodeReview(project, context);
    }

    public final void doCodeReview(@NotNull Project project, @NotNull CodeReviewContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TemplateRender templateRender = new TemplateRender("/practises");
        String template = templateRender.getTemplate("code-review.vm");
        templateRender.setContext(context);
        List<LlmMsg.ChatMessage> messages = templateRender.buildMsgs(template);
        log.info("messages: " + messages);
        SendToWindowKt.sendToChatPanel(project, (Function2<? super NormalChatCodingPanel, ? super ChatCodingService, Unit>)((Function2)(arg_0, arg_1) -> CodeReviewAction.doCodeReview$lambda$2(messages, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> fetchKanbanByCommits(Repository repository, List<? extends VcsFullCommitDetails> details, Project project) {
        List stories = new ArrayList();
        String githubToken = ((AutoDevDevOpsSettingService.AutoDevCoderSettings)AutoDevDevOpsConfigurableProviderKt.getDevopsPromptsSettings(project).getState()).getGithubToken();
        if (repository instanceof GitRepository) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            GitRemote gitRemote = (GitRemote)CollectionsKt.firstOrNull((Iterable)((GitRepository)repository).getInfo().getRemotes());
            if (gitRemote == null) {
                return stories;
            }
            GitRemote remote = gitRemote;
            String string = remote.getFirstUrl();
            if (string == null) {
                return stories;
            }
            String url = string;
            CharSequence charSequence = url;
            if (!CodeReviewActionKt.getGithubUrlRegex().matches(charSequence)) {
                return stories;
            }
            GitHubIssue github = new GitHubIssue(url, githubToken);
            Iterable iterable = details;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSubject(...)");
                collection.add(this.commitParser.parse(string2).getReferences());
            }
            $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CommitReference it = (CommitReference)element$iv;
                boolean bl = false;
                SimpleStory simpleStory = github.getStoryById(it.getIssue());
                ((Collection)stories).add(simpleStory.getTitle());
            }
        }
        return stories;
    }

    private static final void actionPerformed$lambda$0(Project $project, Ref.ObjectRef $stories, CodeReviewAction this$0, List $details) {
        VcsRepositoryManager vcsRepositoryManager = VcsRepositoryManager.getInstance((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsRepositoryManager, (String)"getInstance(...)");
        VcsRepositoryManager repositoryManager = vcsRepositoryManager;
        Repository repository = repositoryManager.getRepositoryForFile($project.getBaseDir());
        if (repository == null) {
            AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, $project, "No git repository found.", null, 4, null);
            return;
        }
        $stories.element = this$0.fetchKanbanByCommits(repository, $details, $project);
    }

    private static final CharSequence doReviewWithChanges$lambda$1(ChatContextItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    private static final Unit doCodeReview$lambda$2(List $messages, NormalChatCodingPanel panel2, ChatCodingService service) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        service.handleMsgsAndResponse(panel2, $messages);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeReviewAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcc/unitmesh/git/actions/vcs/CodeReviewAction$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "ext-git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

