/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.diagram.parser.mermaid;

import cc.unitmesh.diagram.parser.mermaid.AccessibilityStatementNode;
import cc.unitmesh.diagram.parser.mermaid.AccessibilityType;
import cc.unitmesh.diagram.parser.mermaid.AnnotationStatementNode;
import cc.unitmesh.diagram.parser.mermaid.ChangeStatus;
import cc.unitmesh.diagram.parser.mermaid.ClassAnnotationStatementNode;
import cc.unitmesh.diagram.parser.mermaid.ClassDefStatementNode;
import cc.unitmesh.diagram.parser.mermaid.ClassDiagramNode;
import cc.unitmesh.diagram.parser.mermaid.ClassStatementNode;
import cc.unitmesh.diagram.parser.mermaid.ClickActionNode;
import cc.unitmesh.diagram.parser.mermaid.ClickStatementNode;
import cc.unitmesh.diagram.parser.mermaid.DirectionStatementNode;
import cc.unitmesh.diagram.parser.mermaid.DirectionType;
import cc.unitmesh.diagram.parser.mermaid.LineType;
import cc.unitmesh.diagram.parser.mermaid.MemberNode;
import cc.unitmesh.diagram.parser.mermaid.MemberStatementNode;
import cc.unitmesh.diagram.parser.mermaid.MermaidToken;
import cc.unitmesh.diagram.parser.mermaid.NamespaceStatementNode;
import cc.unitmesh.diagram.parser.mermaid.NoteStatementNode;
import cc.unitmesh.diagram.parser.mermaid.ParseError;
import cc.unitmesh.diagram.parser.mermaid.ParseException;
import cc.unitmesh.diagram.parser.mermaid.ParseResult;
import cc.unitmesh.diagram.parser.mermaid.RelationNode;
import cc.unitmesh.diagram.parser.mermaid.RelationStatementNode;
import cc.unitmesh.diagram.parser.mermaid.RelationType;
import cc.unitmesh.diagram.parser.mermaid.StatementNode;
import cc.unitmesh.diagram.parser.mermaid.StyleNode;
import cc.unitmesh.diagram.parser.mermaid.StyleStatementNode;
import cc.unitmesh.diagram.parser.mermaid.TokenPosition;
import cc.unitmesh.diagram.parser.mermaid.TokenType;
import cc.unitmesh.diagram.parser.mermaid.VisibilityType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020#H\u0002J\b\u0010&\u001a\u00020\u001fH\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0003H\u0002J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u00020,H\u0002J \u00106\u001a\u0002032\u0006\u00105\u001a\u00020,2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J \u0010;\u001a\u0002032\u0006\u00105\u001a\u00020,2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020,0\u0003H\u0002J%\u0010=\u001a\u00020>*\u00020,2\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0@\"\u00020,H\u0002\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020>H\u0002J\b\u0010C\u001a\u00020DH\u0002J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020F0\u0003H\u0002J\b\u0010G\u001a\u00020>H\u0002J\b\u0010H\u001a\u00020>H\u0002J\b\u0010I\u001a\u00020>H\u0002J!\u0010J\u001a\u00020>2\u0012\u0010K\u001a\n\u0012\u0006\b\u0001\u0012\u00020L0@\"\u00020LH\u0002\u00a2\u0006\u0002\u0010MJ\b\u0010N\u001a\u00020\u0004H\u0002J\b\u0010O\u001a\u00020>H\u0002J\n\u0010P\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010Q\u001a\u00020\u0004H\u0002J\u0018\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020L2\u0006\u0010T\u001a\u00020,H\u0002J\b\u0010U\u001a\u00020VH\u0002J\b\u0010W\u001a\u00020VH\u0002J\n\u0010X\u001a\u0004\u0018\u00010YH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcc/unitmesh/diagram/parser/mermaid/MermaidParser;", "", "tokens", "", "Lcc/unitmesh/diagram/parser/mermaid/MermaidToken;", "<init>", "(Ljava/util/List;)V", "position", "", "errors", "", "Lcc/unitmesh/diagram/parser/mermaid/ParseError;", "parse", "Lcc/unitmesh/diagram/parser/mermaid/ParseResult;", "parseStatements", "Lcc/unitmesh/diagram/parser/mermaid/StatementNode;", "parseStatement", "parseClassStatement", "Lcc/unitmesh/diagram/parser/mermaid/ClassStatementNode;", "parseNamespaceStatement", "Lcc/unitmesh/diagram/parser/mermaid/NamespaceStatementNode;", "parseRelationStatement", "Lcc/unitmesh/diagram/parser/mermaid/RelationStatementNode;", "parseMemberStatement", "Lcc/unitmesh/diagram/parser/mermaid/MemberStatementNode;", "parseNoteStatement", "Lcc/unitmesh/diagram/parser/mermaid/NoteStatementNode;", "parseNoteForStatement", "parseAnnotationStatement", "Lcc/unitmesh/diagram/parser/mermaid/AnnotationStatementNode;", "parseStyleStatement", "Lcc/unitmesh/diagram/parser/mermaid/StyleStatementNode;", "parseClassDefStatement", "Lcc/unitmesh/diagram/parser/mermaid/ClassDefStatementNode;", "parseClickStatement", "Lcc/unitmesh/diagram/parser/mermaid/ClickStatementNode;", "parseCallbackStatement", "parseLinkStatement", "parseCssClassStatement", "parseDirectionStatement", "Lcc/unitmesh/diagram/parser/mermaid/DirectionStatementNode;", "parseAccessibilityStatement", "Lcc/unitmesh/diagram/parser/mermaid/AccessibilityStatementNode;", "parseClassName", "", "parseNamespaceName", "parseRelation", "Lcc/unitmesh/diagram/parser/mermaid/RelationNode;", "parseRelationType", "Lcc/unitmesh/diagram/parser/mermaid/RelationType;", "parseMembers", "Lcc/unitmesh/diagram/parser/mermaid/MemberNode;", "parseMemberFromText", "text", "parseMemberField", "visibility", "Lcc/unitmesh/diagram/parser/mermaid/VisibilityType;", "changeStatus", "Lcc/unitmesh/diagram/parser/mermaid/ChangeStatus;", "parseMemberMethod", "parseClassList", "startsWithAny", "", "prefixes", "", "(Ljava/lang/String;[Ljava/lang/String;)Z", "checkClassAnnotationStatement", "parseClassAnnotationStatement", "Lcc/unitmesh/diagram/parser/mermaid/ClassAnnotationStatementNode;", "parseStyles", "Lcc/unitmesh/diagram/parser/mermaid/StyleNode;", "checkRelationStatement", "checkMemberStatement", "checkRelationType", "check", "types", "Lcc/unitmesh/diagram/parser/mermaid/TokenType;", "([Lcc/unitmesh/diagram/parser/mermaid/TokenType;)Z", "advance", "isAtEnd", "currentToken", "previous", "consume", "type", "message", "consumeNewlines", "", "synchronize", "getCurrentPosition", "Lcc/unitmesh/diagram/parser/mermaid/TokenPosition;", "ext-diagram"})
@SourceDebugExtension(value={"SMAP\nMermaidParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MermaidParser.kt\ncc/unitmesh/diagram/parser/mermaid/MermaidParser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,689:1\n12474#2,2:690\n*S KotlinDebug\n*F\n+ 1 MermaidParser.kt\ncc/unitmesh/diagram/parser/mermaid/MermaidParser\n*L\n527#1:690,2\n*E\n"})
public final class MermaidParser {
    @NotNull
    private final List<MermaidToken> tokens;
    private int position;
    @NotNull
    private final List<ParseError> errors;

    public MermaidParser(@NotNull List<MermaidToken> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        this.tokens = tokens;
        this.errors = new ArrayList();
    }

    @NotNull
    public final ParseResult parse() {
        ParseResult parseResult;
        this.errors.clear();
        this.position = 0;
        try {
            List<StatementNode> statements = this.parseStatements();
            ClassDiagramNode ast = new ClassDiagramNode(statements, null, 2, null);
            parseResult = new ParseResult.Success(ast);
        }
        catch (ParseException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown parse error";
            }
            this.errors.add(new ParseError(string, this.getCurrentPosition()));
            parseResult = new ParseResult.Error(CollectionsKt.toList((Iterable)this.errors));
        }
        return parseResult;
    }

    private final List<StatementNode> parseStatements() {
        TokenType[] tokenTypeArray;
        List statements = new ArrayList();
        while (!this.isAtEnd() && !this.check(tokenTypeArray = new TokenType[]{TokenType.CLASS_DIAGRAM})) {
            this.advance();
        }
        tokenTypeArray = new TokenType[]{TokenType.CLASS_DIAGRAM};
        if (this.check(tokenTypeArray)) {
            this.advance();
            this.consumeNewlines();
        }
        while (!this.isAtEnd()) {
            try {
                StatementNode statement = this.parseStatement();
                if (statement != null) {
                    statements.add(statement);
                }
                this.consumeNewlines();
            }
            catch (ParseException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "Error parsing statement";
                }
                this.errors.add(new ParseError(string, this.getCurrentPosition()));
                this.synchronize();
            }
        }
        return statements;
    }

    private final StatementNode parseStatement() {
        StatementNode statementNode;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.CLASS};
        if (this.check(tokenTypeArray)) {
            statementNode = this.parseClassStatement();
        } else {
            tokenTypeArray = new TokenType[]{TokenType.NAMESPACE};
            if (this.check(tokenTypeArray)) {
                statementNode = this.parseNamespaceStatement();
            } else {
                tokenTypeArray = new TokenType[]{TokenType.NOTE};
                if (this.check(tokenTypeArray)) {
                    statementNode = this.parseNoteStatement();
                } else {
                    tokenTypeArray = new TokenType[]{TokenType.NOTE_FOR};
                    if (this.check(tokenTypeArray)) {
                        statementNode = this.parseNoteForStatement();
                    } else {
                        tokenTypeArray = new TokenType[]{TokenType.STYLE};
                        if (this.check(tokenTypeArray)) {
                            statementNode = this.parseStyleStatement();
                        } else {
                            tokenTypeArray = new TokenType[]{TokenType.CLASSDEF};
                            if (this.check(tokenTypeArray)) {
                                statementNode = this.parseClassDefStatement();
                            } else {
                                tokenTypeArray = new TokenType[]{TokenType.CLICK};
                                if (this.check(tokenTypeArray)) {
                                    statementNode = this.parseClickStatement();
                                } else {
                                    tokenTypeArray = new TokenType[]{TokenType.CALLBACK};
                                    if (this.check(tokenTypeArray)) {
                                        statementNode = this.parseCallbackStatement();
                                    } else {
                                        tokenTypeArray = new TokenType[]{TokenType.LINK};
                                        if (this.check(tokenTypeArray)) {
                                            statementNode = this.parseLinkStatement();
                                        } else {
                                            tokenTypeArray = new TokenType[]{TokenType.CSSCLASS};
                                            if (this.check(tokenTypeArray)) {
                                                statementNode = this.parseCssClassStatement();
                                            } else {
                                                tokenTypeArray = new TokenType[]{TokenType.ANNOTATION_START};
                                                if (this.check(tokenTypeArray)) {
                                                    statementNode = this.parseAnnotationStatement();
                                                } else {
                                                    tokenTypeArray = new TokenType[]{TokenType.DIRECTION_TB, TokenType.DIRECTION_BT, TokenType.DIRECTION_RL, TokenType.DIRECTION_LR};
                                                    if (this.check(tokenTypeArray)) {
                                                        statementNode = this.parseDirectionStatement();
                                                    } else {
                                                        tokenTypeArray = new TokenType[]{TokenType.ACC_TITLE};
                                                        if (this.check(tokenTypeArray)) {
                                                            statementNode = this.parseAccessibilityStatement();
                                                        } else {
                                                            tokenTypeArray = new TokenType[]{TokenType.ACC_DESCR};
                                                            if (this.check(tokenTypeArray)) {
                                                                statementNode = this.parseAccessibilityStatement();
                                                            } else if (this.checkRelationStatement()) {
                                                                statementNode = this.parseRelationStatement();
                                                            } else if (this.checkMemberStatement()) {
                                                                statementNode = this.parseMemberStatement();
                                                            } else if (this.checkClassAnnotationStatement()) {
                                                                statementNode = this.parseClassAnnotationStatement();
                                                            } else {
                                                                tokenTypeArray = new TokenType[]{TokenType.NEWLINE, TokenType.EOF};
                                                                if (!this.check(tokenTypeArray)) {
                                                                    this.advance();
                                                                }
                                                                statementNode = null;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return statementNode;
    }

    private final ClassStatementNode parseClassStatement() {
        this.consume(TokenType.CLASS, "Expected 'class'");
        String className = this.parseClassName();
        String classLabel = null;
        List<MemberNode> members = CollectionsKt.emptyList();
        String cssClass = null;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.SQS};
        if (this.check(tokenTypeArray)) {
            this.advance();
            classLabel = this.consume(TokenType.STR, "Expected class label").getValue();
            this.consume(TokenType.SQE, "Expected ']'");
        }
        tokenTypeArray = new TokenType[]{TokenType.STYLE_SEPARATOR};
        if (this.check(tokenTypeArray)) {
            this.advance();
            cssClass = this.consume(TokenType.ALPHA, "Expected CSS class name").getValue();
        }
        tokenTypeArray = new TokenType[]{TokenType.STRUCT_START};
        if (this.check(tokenTypeArray)) {
            this.advance();
            members = this.parseMembers();
            this.consume(TokenType.STRUCT_STOP, "Expected '}'");
        }
        return new ClassStatementNode(className, classLabel, members, cssClass, ChangeStatus.UNCHANGED, this.getCurrentPosition());
    }

    private final NamespaceStatementNode parseNamespaceStatement() {
        TokenType[] tokenTypeArray;
        this.consume(TokenType.NAMESPACE, "Expected 'namespace'");
        String namespaceName = this.parseNamespaceName();
        this.consume(TokenType.STRUCT_START, "Expected '{'");
        this.consumeNewlines();
        List classes = new ArrayList();
        while (!this.check(tokenTypeArray = new TokenType[]{TokenType.STRUCT_STOP}) && !this.isAtEnd()) {
            tokenTypeArray = new TokenType[]{TokenType.CLASS};
            Object object = this.check(tokenTypeArray) ? Boolean.valueOf(classes.add(this.parseClassStatement())) : this.advance();
            this.consumeNewlines();
        }
        this.consume(TokenType.STRUCT_STOP, "Expected '}'");
        return new NamespaceStatementNode(namespaceName, classes, this.getCurrentPosition());
    }

    private final RelationStatementNode parseRelationStatement() {
        String sourceClass = this.parseClassName();
        String sourceLabel = null;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.STR};
        if (this.check(tokenTypeArray)) {
            sourceLabel = this.advance().getValue();
        }
        RelationNode relation = this.parseRelation();
        String targetLabel = null;
        TokenType[] tokenTypeArray2 = new TokenType[]{TokenType.STR};
        if (this.check(tokenTypeArray2)) {
            targetLabel = this.advance().getValue();
        }
        String targetClass = this.parseClassName();
        String relationLabel = null;
        TokenType[] tokenTypeArray3 = new TokenType[]{TokenType.LABEL};
        if (this.check(tokenTypeArray3)) {
            String string = this.advance().getValue().substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            relationLabel = string;
        }
        return new RelationStatementNode(sourceClass, targetClass, relation, sourceLabel, targetLabel, relationLabel, this.getCurrentPosition());
    }

    private final MemberStatementNode parseMemberStatement() {
        String string;
        String className = this.parseClassName();
        this.consume(TokenType.COLON, "Expected ':'");
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.LABEL};
        if (this.check(tokenTypeArray)) {
            String string2 = this.advance().getValue().substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            tokenTypeArray = new TokenType[]{TokenType.MEMBER};
            if (this.check(tokenTypeArray)) {
                string = this.advance().getValue();
            } else {
                throw new ParseException("Expected member definition");
            }
        }
        String memberText = string;
        MemberNode member = this.parseMemberFromText(memberText);
        return new MemberStatementNode(className, member, this.getCurrentPosition());
    }

    private final NoteStatementNode parseNoteStatement() {
        this.consume(TokenType.NOTE, "Expected 'note'");
        String noteText = this.consume(TokenType.STR, "Expected note text").getValue();
        return new NoteStatementNode(noteText, null, this.getCurrentPosition());
    }

    private final NoteStatementNode parseNoteForStatement() {
        this.consume(TokenType.NOTE_FOR, "Expected 'note for'");
        String className = this.parseClassName();
        String noteText = this.consume(TokenType.STR, "Expected note text").getValue();
        return new NoteStatementNode(noteText, className, this.getCurrentPosition());
    }

    private final AnnotationStatementNode parseAnnotationStatement() {
        this.consume(TokenType.ANNOTATION_START, "Expected '<<'");
        String annotation = this.consume(TokenType.ALPHA, "Expected annotation").getValue();
        this.consume(TokenType.ANNOTATION_END, "Expected '>>'");
        String className = this.parseClassName();
        return new AnnotationStatementNode(className, annotation, this.getCurrentPosition());
    }

    private final StyleStatementNode parseStyleStatement() {
        this.consume(TokenType.STYLE, "Expected 'style'");
        String className = this.consume(TokenType.ALPHA, "Expected class name").getValue();
        List<StyleNode> styles = this.parseStyles();
        return new StyleStatementNode(className, styles, this.getCurrentPosition());
    }

    private final ClassDefStatementNode parseClassDefStatement() {
        this.consume(TokenType.CLASSDEF, "Expected 'classDef'");
        List<String> classNames = this.parseClassList();
        List<StyleNode> styles = this.parseStyles();
        return new ClassDefStatementNode(classNames, styles, this.getCurrentPosition());
    }

    private final ClickStatementNode parseClickStatement() {
        ClickActionNode clickActionNode;
        this.consume(TokenType.CLICK, "Expected 'click'");
        String className = this.parseClassName();
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.CALLBACK_NAME};
        if (this.check(tokenTypeArray)) {
            callbackName = this.advance().getValue();
            String args = null;
            tooltip = null;
            var6_5 = new TokenType[]{TokenType.CALLBACK_ARGS};
            if (this.check(var6_5)) {
                args = this.advance().getValue();
            }
            var6_5 = new TokenType[]{TokenType.STR};
            if (this.check(var6_5)) {
                tooltip = this.advance().getValue();
            }
            clickActionNode = new ClickActionNode.CallbackAction((String)callbackName, args, tooltip, this.getCurrentPosition());
        } else {
            callbackName = new TokenType[]{TokenType.HREF};
            if (this.check(callbackName)) {
                this.advance();
                String url = this.consume(TokenType.STR, "Expected URL").getValue();
                String target = null;
                tooltip = null;
                var6_5 = new TokenType[]{TokenType.LINK_TARGET};
                if (this.check(var6_5)) {
                    target = this.advance().getValue();
                }
                var6_5 = new TokenType[]{TokenType.STR};
                if (this.check(var6_5)) {
                    tooltip = this.advance().getValue();
                }
                clickActionNode = new ClickActionNode.LinkAction(url, target, tooltip, this.getCurrentPosition());
            } else {
                throw new ParseException("Expected callback name or href");
            }
        }
        ClickActionNode action = clickActionNode;
        return new ClickStatementNode(className, action, this.getCurrentPosition());
    }

    private final ClickStatementNode parseCallbackStatement() {
        this.consume(TokenType.CALLBACK, "Expected 'callback'");
        String className = this.parseClassName();
        String callbackName = this.consume(TokenType.STR, "Expected callback name").getValue();
        String tooltip = null;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.STR};
        if (this.check(tokenTypeArray)) {
            tooltip = this.advance().getValue();
        }
        ClickActionNode.CallbackAction action = new ClickActionNode.CallbackAction(callbackName, null, tooltip, this.getCurrentPosition());
        return new ClickStatementNode(className, action, this.getCurrentPosition());
    }

    private final ClickStatementNode parseLinkStatement() {
        this.consume(TokenType.LINK, "Expected 'link'");
        String className = this.parseClassName();
        String url = this.consume(TokenType.STR, "Expected URL").getValue();
        String target = null;
        String tooltip = null;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.LINK_TARGET};
        if (this.check(tokenTypeArray)) {
            target = this.advance().getValue();
        }
        tokenTypeArray = new TokenType[]{TokenType.STR};
        if (this.check(tokenTypeArray)) {
            tooltip = this.advance().getValue();
        }
        ClickActionNode.LinkAction action = new ClickActionNode.LinkAction(url, target, tooltip, this.getCurrentPosition());
        return new ClickStatementNode(className, action, this.getCurrentPosition());
    }

    private final StyleStatementNode parseCssClassStatement() {
        this.consume(TokenType.CSSCLASS, "Expected 'cssClass'");
        String className = this.consume(TokenType.STR, "Expected class name").getValue();
        String cssClassName = this.consume(TokenType.ALPHA, "Expected CSS class name").getValue();
        StyleNode style = new StyleNode("cssClass", cssClassName, this.getCurrentPosition());
        return new StyleStatementNode(className, CollectionsKt.listOf((Object)style), this.getCurrentPosition());
    }

    private final DirectionStatementNode parseDirectionStatement() {
        DirectionType directionType;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.DIRECTION_TB};
        if (this.check(tokenTypeArray)) {
            directionType = DirectionType.TB;
        } else {
            tokenTypeArray = new TokenType[]{TokenType.DIRECTION_BT};
            if (this.check(tokenTypeArray)) {
                directionType = DirectionType.BT;
            } else {
                tokenTypeArray = new TokenType[]{TokenType.DIRECTION_RL};
                if (this.check(tokenTypeArray)) {
                    directionType = DirectionType.RL;
                } else {
                    tokenTypeArray = new TokenType[]{TokenType.DIRECTION_LR};
                    if (this.check(tokenTypeArray)) {
                        directionType = DirectionType.LR;
                    } else {
                        throw new ParseException("Expected direction");
                    }
                }
            }
        }
        DirectionType directionType2 = directionType;
        this.advance();
        return new DirectionStatementNode(directionType2, this.getCurrentPosition());
    }

    private final AccessibilityStatementNode parseAccessibilityStatement() {
        AccessibilityType accessibilityType;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.ACC_TITLE};
        if (this.check(tokenTypeArray)) {
            accessibilityType = AccessibilityType.TITLE;
        } else {
            tokenTypeArray = new TokenType[]{TokenType.ACC_DESCR};
            if (this.check(tokenTypeArray)) {
                accessibilityType = AccessibilityType.DESCRIPTION;
            } else {
                throw new ParseException("Expected accessibility statement");
            }
        }
        AccessibilityType type = accessibilityType;
        this.advance();
        String value = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> this.consume(TokenType.ACC_TITLE_VALUE, "Expected title value").getValue();
            case 2 -> {
                TokenType[] var3_3 = new TokenType[]{TokenType.ACC_DESCR_MULTILINE_VALUE};
                if (this.check(var3_3)) {
                    yield this.advance().getValue();
                }
                yield this.consume(TokenType.ACC_DESCR_VALUE, "Expected description value").getValue();
            }
            default -> throw new ParseException("Unexpected accessibility type");
        };
        return new AccessibilityStatementNode(type, value, this.getCurrentPosition());
    }

    private final String parseClassName() {
        String string;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.ALPHA};
        if (this.check(tokenTypeArray)) {
            string = this.advance().getValue();
        } else {
            tokenTypeArray = new TokenType[]{TokenType.BQUOTE_STR};
            if (this.check(tokenTypeArray)) {
                string = this.advance().getValue();
            } else {
                throw new ParseException("Expected class name");
            }
        }
        return string;
    }

    private final String parseNamespaceName() {
        List parts = new ArrayList();
        parts.add(this.consume(TokenType.ALPHA, "Expected namespace name").getValue());
        while (true) {
            TokenType[] tokenTypeArray = new TokenType[]{TokenType.DOT};
            if (!this.check(tokenTypeArray)) break;
            this.advance();
            parts.add(this.consume(TokenType.ALPHA, "Expected namespace name part").getValue());
        }
        return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private final RelationNode parseRelation() {
        RelationType type1 = RelationType.NONE;
        RelationType type2 = RelationType.NONE;
        LineType lineType = LineType.LINE;
        if (this.checkRelationType()) {
            type1 = this.parseRelationType();
        }
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.LINE};
        if (this.check(tokenTypeArray)) {
            lineType = LineType.LINE;
            this.advance();
        } else {
            tokenTypeArray = new TokenType[]{TokenType.DOTTED_LINE};
            if (this.check(tokenTypeArray)) {
                lineType = LineType.DOTTED_LINE;
                this.advance();
            }
        }
        if (this.checkRelationType()) {
            type2 = this.parseRelationType();
        }
        return new RelationNode(type1, type2, lineType, this.getCurrentPosition());
    }

    private final RelationType parseRelationType() {
        RelationType relationType;
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.EXTENSION};
        if (this.check(tokenTypeArray)) {
            this.advance();
            relationType = RelationType.EXTENSION;
        } else {
            tokenTypeArray = new TokenType[]{TokenType.DEPENDENCY};
            if (this.check(tokenTypeArray)) {
                this.advance();
                relationType = RelationType.DEPENDENCY;
            } else {
                tokenTypeArray = new TokenType[]{TokenType.COMPOSITION};
                if (this.check(tokenTypeArray)) {
                    this.advance();
                    relationType = RelationType.COMPOSITION;
                } else {
                    tokenTypeArray = new TokenType[]{TokenType.AGGREGATION};
                    if (this.check(tokenTypeArray)) {
                        this.advance();
                        relationType = RelationType.AGGREGATION;
                    } else {
                        tokenTypeArray = new TokenType[]{TokenType.LOLLIPOP};
                        if (this.check(tokenTypeArray)) {
                            this.advance();
                            relationType = RelationType.LOLLIPOP;
                        } else {
                            throw new ParseException("Expected relation type");
                        }
                    }
                }
            }
        }
        return relationType;
    }

    private final List<MemberNode> parseMembers() {
        TokenType[] tokenTypeArray;
        List members = new ArrayList();
        while (!this.check(tokenTypeArray = new TokenType[]{TokenType.STRUCT_STOP}) && !this.isAtEnd()) {
            Object object;
            tokenTypeArray = new TokenType[]{TokenType.MEMBER};
            if (this.check(tokenTypeArray)) {
                String memberText = this.advance().getValue();
                MemberNode member = this.parseMemberFromText(memberText);
                object = members.add(member);
                continue;
            }
            tokenTypeArray = new TokenType[]{TokenType.NEWLINE};
            object = this.check(tokenTypeArray) ? this.advance() : this.advance();
        }
        return members;
    }

    private final MemberNode parseMemberFromText(String text) {
        String string;
        String string2;
        String trimmed = ((Object)StringsKt.trim((CharSequence)text)).toString();
        ChangeStatus changeStatus = StringsKt.startsWith$default((String)trimmed, (String)"+", (boolean)false, (int)2, null) ? ChangeStatus.ADDED : (StringsKt.startsWith$default((String)trimmed, (String)"-", (boolean)false, (int)2, null) ? ChangeStatus.REMOVED : (StringsKt.startsWith$default((String)trimmed, (String)"~", (boolean)false, (int)2, null) ? ChangeStatus.MODIFIED : ChangeStatus.UNCHANGED));
        String[] stringArray = new String[]{"+", "-", "~"};
        if (this.startsWithAny(trimmed, stringArray)) {
            String string3 = trimmed.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        } else {
            string2 = trimmed;
        }
        String withoutChangeStatus = string2;
        VisibilityType visibility = StringsKt.startsWith$default((String)withoutChangeStatus, (String)"+", (boolean)false, (int)2, null) ? VisibilityType.PUBLIC : (StringsKt.startsWith$default((String)withoutChangeStatus, (String)"-", (boolean)false, (int)2, null) ? VisibilityType.PRIVATE : (StringsKt.startsWith$default((String)withoutChangeStatus, (String)"#", (boolean)false, (int)2, null) ? VisibilityType.PROTECTED : (StringsKt.startsWith$default((String)withoutChangeStatus, (String)"~", (boolean)false, (int)2, null) ? VisibilityType.PACKAGE : VisibilityType.PUBLIC)));
        String[] stringArray2 = new String[]{"+", "-", "#", "~"};
        if (this.startsWithAny(withoutChangeStatus, stringArray2)) {
            String string4 = withoutChangeStatus.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string = withoutChangeStatus;
        }
        String withoutVisibility = string;
        boolean isMethod = StringsKt.contains$default((CharSequence)withoutVisibility, (CharSequence)"(", (boolean)false, (int)2, null);
        return isMethod ? this.parseMemberMethod(withoutVisibility, visibility, changeStatus) : this.parseMemberField(withoutVisibility, visibility, changeStatus);
    }

    private final MemberNode parseMemberField(String text, VisibilityType visibility, ChangeStatus changeStatus) {
        Regex regex = new Regex("\\s+");
        CharSequence charSequence = text;
        int n = 2;
        List parts = regex.split(charSequence, n);
        return parts.size() >= 2 ? new MemberNode((String)parts.get(1), (String)parts.get(0), visibility, false, null, null, changeStatus, this.getCurrentPosition(), 48, null) : new MemberNode((String)parts.get(0), null, visibility, false, null, null, changeStatus, this.getCurrentPosition(), 48, null);
    }

    private final MemberNode parseMemberMethod(String text, VisibilityType visibility, ChangeStatus changeStatus) {
        int parenIndex = StringsKt.indexOf$default((CharSequence)text, (char)'(', (int)0, (boolean)false, (int)6, null);
        String string = text.substring(0, parenIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String methodName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return new MemberNode(methodName, "method", visibility, true, null, null, changeStatus, this.getCurrentPosition(), 48, null);
    }

    private final List<String> parseClassList() {
        List classes = new ArrayList();
        classes.add(this.consume(TokenType.ALPHA, "Expected class name").getValue());
        while (true) {
            TokenType[] tokenTypeArray = new TokenType[]{TokenType.COMMA};
            if (!this.check(tokenTypeArray)) break;
            this.advance();
            classes.add(this.consume(TokenType.ALPHA, "Expected class name").getValue());
        }
        return classes;
    }

    private final boolean startsWithAny(String $this$startsWithAny, String ... prefixes) {
        boolean bl;
        block1: {
            String[] $this$any$iv = prefixes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)$this$startsWithAny, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean checkClassAnnotationStatement() {
        int saved = this.position;
        try {
            TokenType[] tokenTypeArray = new TokenType[]{TokenType.ALPHA, TokenType.BQUOTE_STR};
            if (this.check(tokenTypeArray)) {
                this.advance();
                tokenTypeArray = new TokenType[]{TokenType.COLON};
                if (this.check(tokenTypeArray)) {
                    this.advance();
                    TokenType[] tokenTypeArray2 = new TokenType[]{TokenType.ALPHA};
                    boolean hasAnnotation = this.check(tokenTypeArray2);
                    this.position = saved;
                    return hasAnnotation;
                }
            }
        }
        catch (Exception e) {
            this.position = saved;
        }
        this.position = saved;
        return false;
    }

    private final ClassAnnotationStatementNode parseClassAnnotationStatement() {
        String className = this.parseClassName();
        this.consume(TokenType.COLON, "Expected ':'");
        String annotation = this.consume(TokenType.ALPHA, "Expected annotation").getValue();
        return new ClassAnnotationStatementNode(className, annotation, this.getCurrentPosition());
    }

    private final List<StyleNode> parseStyles() {
        return CollectionsKt.emptyList();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean checkRelationStatement() {
        block5: {
            saved = this.position;
            try {
                var2_2 = new TokenType[]{TokenType.ALPHA, TokenType.BQUOTE_STR};
                if (!this.check(var2_2)) break block5;
                this.advance();
                var2_2 = new TokenType[]{TokenType.STR};
                if (this.check(var2_2)) {
                    this.advance();
                }
                if (this.checkRelationType()) ** GOTO lbl-1000
                var3_5 = new TokenType[]{TokenType.LINE, TokenType.DOTTED_LINE};
                if (this.check(var3_5)) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                hasRelation = v0;
                this.position = saved;
                return hasRelation;
            }
            catch (Exception e) {
                this.position = saved;
            }
        }
        return false;
    }

    private final boolean checkMemberStatement() {
        int saved = this.position;
        try {
            TokenType[] tokenTypeArray = new TokenType[]{TokenType.ALPHA, TokenType.BQUOTE_STR};
            if (this.check(tokenTypeArray)) {
                this.advance();
                tokenTypeArray = new TokenType[]{TokenType.COLON};
                if (this.check(tokenTypeArray)) {
                    this.advance();
                    TokenType[] tokenTypeArray2 = new TokenType[]{TokenType.LABEL, TokenType.MEMBER};
                    boolean hasMember = this.check(tokenTypeArray2);
                    this.position = saved;
                    return hasMember;
                }
            }
        }
        catch (Exception e) {
            this.position = saved;
        }
        return false;
    }

    private final boolean checkRelationType() {
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.EXTENSION, TokenType.DEPENDENCY, TokenType.COMPOSITION, TokenType.AGGREGATION, TokenType.LOLLIPOP};
        return this.check(tokenTypeArray);
    }

    private final boolean check(TokenType ... types) {
        if (this.isAtEnd()) {
            return false;
        }
        MermaidToken mermaidToken = this.currentToken();
        return ArraysKt.contains((Object[])types, (Object)((Object)(mermaidToken != null ? mermaidToken.getType() : null)));
    }

    private final MermaidToken advance() {
        if (!this.isAtEnd()) {
            int n = this.position;
            this.position = n + 1;
        }
        return this.previous();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAtEnd() {
        if (this.position >= this.tokens.size()) return true;
        MermaidToken mermaidToken = this.currentToken();
        if ((mermaidToken != null ? mermaidToken.getType() : null) != TokenType.EOF) return false;
        return true;
    }

    private final MermaidToken currentToken() {
        return this.position < this.tokens.size() ? this.tokens.get(this.position) : null;
    }

    private final MermaidToken previous() {
        return this.tokens.get(this.position - 1);
    }

    private final MermaidToken consume(TokenType type, String message) {
        TokenType[] tokenTypeArray = new TokenType[]{type};
        if (this.check(tokenTypeArray)) {
            return this.advance();
        }
        MermaidToken mermaidToken = this.currentToken();
        throw new ParseException(message + ". Got " + (mermaidToken != null ? mermaidToken.getType() : null));
    }

    private final void consumeNewlines() {
        while (true) {
            TokenType[] tokenTypeArray = new TokenType[]{TokenType.NEWLINE};
            if (!this.check(tokenTypeArray)) break;
            this.advance();
        }
    }

    private final void synchronize() {
        this.advance();
        while (!this.isAtEnd()) {
            if (this.previous().getType() == TokenType.NEWLINE) {
                return;
            }
            MermaidToken mermaidToken = this.currentToken();
            TokenType tokenType = mermaidToken != null ? mermaidToken.getType() : null;
            switch (tokenType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[tokenType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return;
                }
            }
            this.advance();
        }
    }

    private final TokenPosition getCurrentPosition() {
        TokenPosition tokenPosition;
        MermaidToken mermaidToken = this.currentToken();
        if (mermaidToken != null) {
            MermaidToken it = mermaidToken;
            boolean bl = false;
            tokenPosition = new TokenPosition(it.getLine(), it.getColumn(), this.position);
        } else {
            tokenPosition = null;
        }
        return tokenPosition;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AccessibilityType.values().length];
            try {
                nArray[AccessibilityType.TITLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessibilityType.DESCRIPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.NAMESPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.NOTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.STYLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

