/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.diagram.parser.mermaid;

import cc.unitmesh.diagram.parser.mermaid.MermaidToken;
import cc.unitmesh.diagram.parser.mermaid.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\t\u0018\u00002\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0002J\b\u0010 \u001a\u00020\u0012H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0002J\b\u0010#\u001a\u00020\u0012H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u00020+2\b\b\u0002\u0010-\u001a\u00020\u0007H\u0002J\u0012\u0010.\u001a\u00020(2\b\b\u0002\u0010/\u001a\u00020\u0007H\u0002J\u0018\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0003H\u0002J\f\u00102\u001a\u00020\u0012*\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcc/unitmesh/diagram/parser/mermaid/MermaidLexer;", "", "input", "", "<init>", "(Ljava/lang/String;)V", "position", "", "line", "column", "state", "Lcc/unitmesh/diagram/parser/mermaid/MermaidLexer$LexerState;", "tokens", "", "Lcc/unitmesh/diagram/parser/mermaid/MermaidToken;", "tokenize", "", "scanToken", "", "scanInitialState", "scanStringState", "scanBackquoteStringState", "scanGenericState", "scanClassState", "scanClassBodyState", "scanNamespaceState", "scanNamespaceBodyState", "scanCallbackNameState", "scanCallbackArgsState", "scanAccTitleState", "scanAccDescrState", "scanAccDescrMultilineState", "scanIdentifierOrKeyword", "scanNumber", "scanNewline", "scanOperatorOrPunctuation", "getKeywordType", "Lcc/unitmesh/diagram/parser/mermaid/TokenType;", "value", "skipWhitespace", "", "skipComment", "current", "", "peek", "offset", "advance", "count", "addToken", "type", "isPunctuation", "LexerState", "ext-diagram"})
public final class MermaidLexer {
    @NotNull
    private final String input;
    private int position;
    private int line;
    private int column;
    @NotNull
    private LexerState state;
    @NotNull
    private final List<MermaidToken> tokens;

    public MermaidLexer(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.line = 1;
        this.column = 1;
        this.state = LexerState.INITIAL;
        this.tokens = new ArrayList();
    }

    @NotNull
    public final List<MermaidToken> tokenize() {
        this.tokens.clear();
        this.position = 0;
        this.line = 1;
        this.column = 1;
        this.state = LexerState.INITIAL;
        while (this.position < this.input.length()) {
            if (this.scanToken()) continue;
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        this.addToken(TokenType.EOF, "");
        return CollectionsKt.toList((Iterable)this.tokens);
    }

    private final boolean scanToken() {
        int start2 = this.position;
        int startLine = this.line;
        int startColumn = this.column;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1 -> this.scanInitialState();
            case 2 -> this.scanStringState();
            case 3 -> this.scanBackquoteStringState();
            case 4 -> this.scanGenericState();
            case 5 -> this.scanClassState();
            case 6 -> this.scanClassBodyState();
            case 7 -> this.scanNamespaceState();
            case 8 -> this.scanNamespaceBodyState();
            case 9 -> this.scanCallbackNameState();
            case 10 -> this.scanCallbackArgsState();
            case 11 -> this.scanAccTitleState();
            case 12 -> this.scanAccDescrState();
            case 13 -> this.scanAccDescrMultilineState();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean scanInitialState() {
        boolean bl;
        this.skipWhitespace();
        if (this.position >= this.input.length()) {
            return false;
        }
        char c = this.current();
        if (c == '%' && MermaidLexer.peek$default(this, 0, 1, null) == '%') {
            this.skipComment();
            bl = true;
        } else if (c == '\n' || c == '\r') {
            this.scanNewline();
            bl = true;
        } else if (c == '\"') {
            this.state = LexerState.STRING;
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '`') {
            this.state = LexerState.BQSTRING;
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '~') {
            this.state = LexerState.GENERIC;
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else {
            bl = Character.isLetter(c) || c == '_' ? this.scanIdentifierOrKeyword() : (Character.isDigit(c) ? this.scanNumber() : this.scanOperatorOrPunctuation());
        }
        return bl;
    }

    private final boolean scanStringState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != '\"') {
            if (this.current() == '\\') {
                MermaidLexer.advance$default(this, 0, 1, null);
                if (this.position >= this.input.length()) continue;
                MermaidLexer.advance$default(this, 0, 1, null);
                continue;
            }
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position < this.input.length() && this.current() == '\"') {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            this.addToken(TokenType.STR, value);
            MermaidLexer.advance$default(this, 0, 1, null);
            this.state = LexerState.INITIAL;
            return true;
        }
        return false;
    }

    private final boolean scanBackquoteStringState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != '`') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position < this.input.length() && this.current() == '`') {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            this.addToken(TokenType.BQUOTE_STR, value);
            MermaidLexer.advance$default(this, 0, 1, null);
            this.state = LexerState.INITIAL;
            return true;
        }
        return false;
    }

    private final boolean scanGenericState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != '~') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position < this.input.length() && this.current() == '~') {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            this.addToken(TokenType.GENERICTYPE, value);
            MermaidLexer.advance$default(this, 0, 1, null);
            this.state = LexerState.INITIAL;
            return true;
        }
        return false;
    }

    private final boolean scanClassState() {
        boolean bl;
        this.skipWhitespace();
        if (this.position >= this.input.length()) {
            return false;
        }
        char c = this.current();
        if (c == '\n' || c == '\r') {
            this.scanNewline();
            this.state = LexerState.INITIAL;
            bl = true;
        } else if (c == '{') {
            this.addToken(TokenType.STRUCT_START, "{");
            MermaidLexer.advance$default(this, 0, 1, null);
            this.state = LexerState.CLASS_BODY;
            bl = true;
        } else if (c == '}') {
            this.addToken(TokenType.STRUCT_STOP, "}");
            MermaidLexer.advance$default(this, 0, 1, null);
            this.state = LexerState.INITIAL;
            bl = true;
        } else {
            bl = Character.isLetter(c) || c == '_' ? this.scanIdentifierOrKeyword() : this.scanOperatorOrPunctuation();
        }
        return bl;
    }

    private final boolean scanClassBodyState() {
        this.skipWhitespace();
        if (this.position >= this.input.length()) {
            this.addToken(TokenType.EOF, "");
            return true;
        }
        char c = this.current();
        return switch (c) {
            case '}' -> {
                this.addToken(TokenType.STRUCT_STOP, "}");
                MermaidLexer.advance$default(this, 0, 1, null);
                this.state = LexerState.INITIAL;
                yield true;
            }
            case '\n' -> {
                MermaidLexer.advance$default(this, 0, 1, null);
                yield true;
            }
            case '{' -> {
                this.addToken(TokenType.STRUCT_START, "{");
                MermaidLexer.advance$default(this, 0, 1, null);
                yield true;
            }
            default -> {
                int start = this.position;
                while (this.position < this.input.length() && this.current() != '\n' && this.current() != '}' && this.current() != '{') {
                    MermaidLexer.advance$default(this, 0, 1, null);
                }
                if (this.position > start) {
                    String v1 = this.input.substring(start, this.position);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                    String value = ((Object)StringsKt.trim((CharSequence)v1)).toString();
                    if (((CharSequence)value).length() > 0) {
                        this.addToken(TokenType.MEMBER, value);
                    }
                }
                yield true;
            }
        };
    }

    private final boolean scanNamespaceState() {
        return this.scanClassState();
    }

    private final boolean scanNamespaceBodyState() {
        return this.scanClassBodyState();
    }

    private final boolean scanCallbackNameState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != '(' && !CharsKt.isWhitespace((char)this.current())) {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position > start2) {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            this.addToken(TokenType.CALLBACK_NAME, value);
        }
        this.state = LexerState.INITIAL;
        return true;
    }

    private final boolean scanCallbackArgsState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != ')') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position > start2) {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            this.addToken(TokenType.CALLBACK_ARGS, value);
        }
        if (this.position < this.input.length() && this.current() == ')') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        this.state = LexerState.INITIAL;
        return true;
    }

    private final boolean scanAccTitleState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != '\n' && this.current() != ';' && this.current() != '#') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position > start2) {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
            this.addToken(TokenType.ACC_TITLE_VALUE, value);
        }
        this.state = LexerState.INITIAL;
        return true;
    }

    private final boolean scanAccDescrState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != '\n' && this.current() != ';' && this.current() != '#') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position > start2) {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
            this.addToken(TokenType.ACC_DESCR_VALUE, value);
        }
        this.state = LexerState.INITIAL;
        return true;
    }

    private final boolean scanAccDescrMultilineState() {
        int start2 = this.position;
        while (this.position < this.input.length() && this.current() != '}') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        if (this.position > start2) {
            String string = this.input.substring(start2, this.position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String value = string;
            this.addToken(TokenType.ACC_DESCR_MULTILINE_VALUE, value);
        }
        if (this.position < this.input.length() && this.current() == '}') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        this.state = LexerState.INITIAL;
        return true;
    }

    private final boolean scanIdentifierOrKeyword() {
        int start2 = this.position;
        while (this.position < this.input.length() && (Character.isLetterOrDigit(this.current()) || this.current() == '_' || this.current() == '-')) {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        String string = this.input.substring(start2, this.position);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String value = string;
        TokenType tokenType = this.getKeywordType(value);
        if (tokenType == null) {
            tokenType = TokenType.ALPHA;
        }
        TokenType tokenType2 = tokenType;
        this.addToken(tokenType2, value);
        switch (WhenMappings.$EnumSwitchMapping$1[tokenType2.ordinal()]) {
            case 1: {
                this.state = LexerState.CLASS;
                break;
            }
            case 2: {
                this.state = LexerState.NAMESPACE;
                break;
            }
            case 3: {
                this.state = LexerState.ACC_TITLE;
                break;
            }
            case 4: {
                this.state = LexerState.ACC_DESCR;
            }
        }
        return true;
    }

    private final boolean scanNumber() {
        int start2 = this.position;
        while (this.position < this.input.length() && Character.isDigit(this.current())) {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        String string = this.input.substring(start2, this.position);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String value = string;
        this.addToken(TokenType.NUM, value);
        return true;
    }

    private final boolean scanNewline() {
        if (this.current() == '\r' && MermaidLexer.peek$default(this, 0, 1, null) == '\n') {
            MermaidLexer.advance$default(this, 0, 1, null);
            MermaidLexer.advance$default(this, 0, 1, null);
        } else {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
        this.addToken(TokenType.NEWLINE, "\\n");
        return true;
    }

    private final boolean scanOperatorOrPunctuation() {
        boolean bl;
        char c = this.current();
        if (c == '<' && MermaidLexer.peek$default(this, 0, 1, null) == '|' && this.peek(2) == '-' && this.peek(3) == '-') {
            this.addToken(TokenType.EXTENSION, "<|--");
            this.advance(4);
            bl = true;
        } else if (c == '-' && MermaidLexer.peek$default(this, 0, 1, null) == '-' && this.peek(2) == '>') {
            this.addToken(TokenType.LINE, "-->");
            this.advance(3);
            bl = true;
        } else if (c == '-' && MermaidLexer.peek$default(this, 0, 1, null) == '-') {
            this.addToken(TokenType.LINE, "--");
            this.advance(2);
            bl = true;
        } else if (c == '.' && MermaidLexer.peek$default(this, 0, 1, null) == '.') {
            this.addToken(TokenType.DOTTED_LINE, "..");
            this.advance(2);
            bl = true;
        } else if (c == '<' && MermaidLexer.peek$default(this, 0, 1, null) == '<') {
            this.addToken(TokenType.ANNOTATION_START, "<<");
            this.advance(2);
            bl = true;
        } else if (c == '>' && MermaidLexer.peek$default(this, 0, 1, null) == '>') {
            this.addToken(TokenType.ANNOTATION_END, ">>");
            this.advance(2);
            bl = true;
        } else if (c == ':' && MermaidLexer.peek$default(this, 0, 1, null) == ':' && this.peek(2) == ':') {
            this.addToken(TokenType.STYLE_SEPARATOR, ":::");
            this.advance(3);
            bl = true;
        } else if (c == '<' && MermaidLexer.peek$default(this, 0, 1, null) == '|') {
            this.addToken(TokenType.EXTENSION, "<|");
            this.advance(2);
            bl = true;
        } else if (c == '|' && MermaidLexer.peek$default(this, 0, 1, null) == '>') {
            this.addToken(TokenType.EXTENSION, "|>");
            this.advance(2);
            bl = true;
        } else if (c == '(' && MermaidLexer.peek$default(this, 0, 1, null) == ')') {
            this.addToken(TokenType.LOLLIPOP, "()");
            this.advance(2);
            bl = true;
        } else if (c == '{') {
            this.addToken(TokenType.STRUCT_START, "{");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '}') {
            this.addToken(TokenType.STRUCT_STOP, "}");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '[') {
            this.addToken(TokenType.SQS, "[");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == ']') {
            this.addToken(TokenType.SQE, "]");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == ':') {
            int start2;
            int end;
            for (end = start2 = this.position + 1; end < this.input.length() && this.input.charAt(end) != '\n' && this.input.charAt(end) != ';'; ++end) {
            }
            if (end > start2) {
                String string = this.input.substring(start2, end);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String content = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (((CharSequence)content).length() > 0) {
                    if (StringsKt.startsWith$default((CharSequence)content, (char)'+', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)content, (char)'-', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)content, (char)'#', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)content, (char)'~', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)content, (char)'(', (boolean)false, (int)2, null)) {
                        this.addToken(TokenType.COLON, ":");
                        MermaidLexer.advance$default(this, 0, 1, null);
                        this.skipWhitespace();
                        int memberStart = this.position;
                        this.position = end;
                        String string2 = this.input.substring(memberStart, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        String memberText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        if (((CharSequence)memberText).length() > 0) {
                            this.addToken(TokenType.MEMBER, memberText);
                        }
                        return true;
                    }
                    Regex regex = new Regex("\\s+");
                    CharSequence charSequence = content;
                    int n = 0;
                    List words = regex.split(charSequence, n);
                    if (words.size() == 1 && new Regex("[A-Za-z][A-Za-z0-9_]*").matches(charSequence = (CharSequence)words.get(0))) {
                        this.addToken(TokenType.COLON, ":");
                        MermaidLexer.advance$default(this, 0, 1, null);
                        return true;
                    }
                    this.addToken(TokenType.LABEL, ":" + content);
                    this.position = end;
                    return true;
                }
            }
            this.addToken(TokenType.COLON, ":");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == ',') {
            this.addToken(TokenType.COMMA, ",");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '.') {
            this.addToken(TokenType.DOT, ".");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '+') {
            this.addToken(TokenType.PLUS, "+");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '-') {
            this.addToken(TokenType.MINUS, "-");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '#') {
            this.addToken(TokenType.BRKT, "#");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '%') {
            this.addToken(TokenType.PCT, "%");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '=') {
            this.addToken(TokenType.EQUALS, "=");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '*') {
            this.addToken(TokenType.COMPOSITION, "*");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == 'o' && !Character.isLetterOrDigit(MermaidLexer.peek$default(this, 0, 1, null))) {
            this.addToken(TokenType.AGGREGATION, "o");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '<') {
            this.addToken(TokenType.DEPENDENCY, "<");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (c == '>') {
            this.addToken(TokenType.DEPENDENCY, ">");
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else if (this.isPunctuation(c)) {
            this.addToken(TokenType.PUNCTUATION, String.valueOf(c));
            MermaidLexer.advance$default(this, 0, 1, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final TokenType getKeywordType(String value) {
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "classdiagram-v2", "classdiagram" -> TokenType.CLASS_DIAGRAM;
            case "class" -> TokenType.CLASS;
            case "namespace" -> TokenType.NAMESPACE;
            case "note" -> TokenType.NOTE;
            case "style" -> TokenType.STYLE;
            case "classdef" -> TokenType.CLASSDEF;
            case "callback" -> TokenType.CALLBACK;
            case "link" -> TokenType.LINK;
            case "click" -> TokenType.CLICK;
            case "href" -> TokenType.HREF;
            case "cssclass" -> TokenType.CSSCLASS;
            case "acctitle" -> TokenType.ACC_TITLE;
            case "accdescr" -> TokenType.ACC_DESCR;
            case "_blank", "_parent", "_top", "_self" -> TokenType.LINK_TARGET;
            default -> StringsKt.contains$default((CharSequence)value, (CharSequence)"direction", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)value, (CharSequence)"TB", (boolean)false, (int)2, null) ? TokenType.DIRECTION_TB : (StringsKt.contains$default((CharSequence)value, (CharSequence)"direction", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)value, (CharSequence)"BT", (boolean)false, (int)2, null) ? TokenType.DIRECTION_BT : (StringsKt.contains$default((CharSequence)value, (CharSequence)"direction", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)value, (CharSequence)"RL", (boolean)false, (int)2, null) ? TokenType.DIRECTION_RL : (StringsKt.contains$default((CharSequence)value, (CharSequence)"direction", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)value, (CharSequence)"LR", (boolean)false, (int)2, null) ? TokenType.DIRECTION_LR : (Intrinsics.areEqual((Object)value, (Object)"note for") ? TokenType.NOTE_FOR : null))));
        };
    }

    private final void skipWhitespace() {
        while (this.position < this.input.length() && CharsKt.isWhitespace((char)this.current()) && this.current() != '\n' && this.current() != '\r') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
    }

    private final void skipComment() {
        while (this.position < this.input.length() && this.current() != '\n') {
            MermaidLexer.advance$default(this, 0, 1, null);
        }
    }

    private final char current() {
        return this.position < this.input.length() ? this.input.charAt(this.position) : (char)'\u0000';
    }

    private final char peek(int offset) {
        return this.position + offset < this.input.length() ? this.input.charAt(this.position + offset) : (char)'\u0000';
    }

    static /* synthetic */ char peek$default(MermaidLexer mermaidLexer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return mermaidLexer.peek(n);
    }

    private final void advance(int count) {
        for (int i = 0; i < count; ++i) {
            int n;
            int it = i;
            boolean bl = false;
            if (this.position >= this.input.length()) continue;
            if (this.input.charAt(this.position) == '\n') {
                n = this.line;
                this.line = n + 1;
                this.column = 1;
            } else {
                n = this.column;
                this.column = n + 1;
            }
            n = this.position;
            this.position = n + 1;
        }
    }

    static /* synthetic */ void advance$default(MermaidLexer mermaidLexer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        mermaidLexer.advance(n);
    }

    private final void addToken(TokenType type, String value) {
        this.tokens.add(new MermaidToken(type, value, this.line, this.column));
    }

    private final boolean isPunctuation(char $this$isPunctuation) {
        return StringsKt.contains$default((CharSequence)"!\"#$%&'*+,-.`?\\/", (char)$this$isPunctuation, (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0010\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/diagram/parser/mermaid/MermaidLexer$LexerState;", "", "<init>", "(Ljava/lang/String;I)V", "INITIAL", "STRING", "BQSTRING", "GENERIC", "CLASS", "CLASS_BODY", "NAMESPACE", "NAMESPACE_BODY", "CALLBACK_NAME", "CALLBACK_ARGS", "ACC_TITLE", "ACC_DESCR", "ACC_DESCR_MULTILINE", "ext-diagram"})
    private static final class LexerState
    extends Enum<LexerState> {
        public static final /* enum */ LexerState INITIAL = new LexerState();
        public static final /* enum */ LexerState STRING = new LexerState();
        public static final /* enum */ LexerState BQSTRING = new LexerState();
        public static final /* enum */ LexerState GENERIC = new LexerState();
        public static final /* enum */ LexerState CLASS = new LexerState();
        public static final /* enum */ LexerState CLASS_BODY = new LexerState();
        public static final /* enum */ LexerState NAMESPACE = new LexerState();
        public static final /* enum */ LexerState NAMESPACE_BODY = new LexerState();
        public static final /* enum */ LexerState CALLBACK_NAME = new LexerState();
        public static final /* enum */ LexerState CALLBACK_ARGS = new LexerState();
        public static final /* enum */ LexerState ACC_TITLE = new LexerState();
        public static final /* enum */ LexerState ACC_DESCR = new LexerState();
        public static final /* enum */ LexerState ACC_DESCR_MULTILINE = new LexerState();
        private static final /* synthetic */ LexerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LexerState[] values() {
            return (LexerState[])$VALUES.clone();
        }

        public static LexerState valueOf(String value) {
            return Enum.valueOf(LexerState.class, value);
        }

        @NotNull
        public static EnumEntries<LexerState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lexerStateArray = new LexerState[]{LexerState.INITIAL, LexerState.STRING, LexerState.BQSTRING, LexerState.GENERIC, LexerState.CLASS, LexerState.CLASS_BODY, LexerState.NAMESPACE, LexerState.NAMESPACE_BODY, LexerState.CALLBACK_NAME, LexerState.CALLBACK_ARGS, LexerState.ACC_TITLE, LexerState.ACC_DESCR, LexerState.ACC_DESCR_MULTILINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LexerState.values().length];
            try {
                nArray[LexerState.INITIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.BQSTRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.GENERIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.CLASS_BODY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.NAMESPACE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.NAMESPACE_BODY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.CALLBACK_NAME.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.CALLBACK_ARGS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ACC_TITLE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ACC_DESCR.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LexerState.ACC_DESCR_MULTILINE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.NAMESPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.ACC_TITLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.ACC_DESCR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

