/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.diagram.parser;

import cc.unitmesh.diagram.model.GraphDiagramData;
import cc.unitmesh.diagram.model.GraphEdgeData;
import cc.unitmesh.diagram.model.GraphEntityNodeData;
import cc.unitmesh.diagram.model.GraphGraphType;
import cc.unitmesh.diagram.model.GraphNodeField;
import cc.unitmesh.diagram.model.GraphvizEdgeType;
import cc.unitmesh.diagram.parser.mermaid.AccessibilityStatementNode;
import cc.unitmesh.diagram.parser.mermaid.AccessibilityType;
import cc.unitmesh.diagram.parser.mermaid.ChangeStatus;
import cc.unitmesh.diagram.parser.mermaid.ClassAnnotationStatementNode;
import cc.unitmesh.diagram.parser.mermaid.ClassDiagramNode;
import cc.unitmesh.diagram.parser.mermaid.ClassStatementNode;
import cc.unitmesh.diagram.parser.mermaid.DirectionStatementNode;
import cc.unitmesh.diagram.parser.mermaid.LineType;
import cc.unitmesh.diagram.parser.mermaid.MemberNode;
import cc.unitmesh.diagram.parser.mermaid.MemberStatementNode;
import cc.unitmesh.diagram.parser.mermaid.MermaidLexer;
import cc.unitmesh.diagram.parser.mermaid.MermaidParser;
import cc.unitmesh.diagram.parser.mermaid.MermaidToken;
import cc.unitmesh.diagram.parser.mermaid.ParseError;
import cc.unitmesh.diagram.parser.mermaid.ParseResult;
import cc.unitmesh.diagram.parser.mermaid.RelationStatementNode;
import cc.unitmesh.diagram.parser.mermaid.RelationType;
import cc.unitmesh.diagram.parser.mermaid.StatementNode;
import cc.unitmesh.diagram.parser.mermaid.VisibilityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0002\u00a8\u0006\u0014"}, d2={"Lcc/unitmesh/diagram/parser/MermaidClassDiagramParser;", "", "<init>", "()V", "parse", "Lcc/unitmesh/diagram/model/GraphDiagramData;", "mermaidContent", "", "ast", "Lcc/unitmesh/diagram/parser/mermaid/ClassDiagramNode;", "convertAstToGraphvizData", "convertMemberToField", "Lcc/unitmesh/diagram/model/GraphNodeField;", "member", "Lcc/unitmesh/diagram/parser/mermaid/MemberNode;", "convertRelationToEdge", "Lcc/unitmesh/diagram/model/GraphEdgeData;", "relation", "Lcc/unitmesh/diagram/parser/mermaid/RelationStatementNode;", "createEmptyData", "ext-diagram"})
@SourceDebugExtension(value={"SMAP\nMermaidClassDiagramParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MermaidClassDiagramParser.kt\ncc/unitmesh/diagram/parser/MermaidClassDiagramParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,258:1\n1855#2,2:259\n1549#2:261\n1620#2,3:262\n125#3:265\n152#3,3:266\n*S KotlinDebug\n*F\n+ 1 MermaidClassDiagramParser.kt\ncc/unitmesh/diagram/parser/MermaidClassDiagramParser\n*L\n33#1:259,2\n65#1:261\n65#1:262,3\n136#1:265\n136#1:266,3\n*E\n"})
public final class MermaidClassDiagramParser {
    @NotNull
    public final GraphDiagramData parse(@NotNull String mermaidContent) {
        GraphDiagramData graphDiagramData;
        Intrinsics.checkNotNullParameter((Object)mermaidContent, (String)"mermaidContent");
        try {
            GraphDiagramData graphDiagramData2;
            ParseResult parseResult;
            MermaidLexer lexer = new MermaidLexer(mermaidContent);
            List<MermaidToken> tokens = lexer.tokenize();
            MermaidParser parser = new MermaidParser(tokens);
            ParseResult parseResult2 = parseResult = parser.parse();
            if (parseResult2 instanceof ParseResult.Success) {
                graphDiagramData2 = this.convertAstToGraphvizData(((ParseResult.Success)parseResult).getAst());
            } else if (parseResult2 instanceof ParseResult.Error) {
                Iterable $this$forEach$iv = ((ParseResult.Error)parseResult).getErrors();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ParseError error = (ParseError)element$iv;
                    boolean bl = false;
                    System.out.println((Object)("Parse error: " + error.getMessage() + " at " + error.getPosition()));
                }
                graphDiagramData2 = this.createEmptyData();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            graphDiagramData = graphDiagramData2;
        }
        catch (Exception e) {
            System.out.println((Object)("Exception during parsing: " + e.getMessage()));
            e.printStackTrace();
            graphDiagramData = this.createEmptyData();
        }
        return graphDiagramData;
    }

    @NotNull
    public final GraphDiagramData parse(@NotNull ClassDiagramNode ast) {
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        return this.convertAstToGraphvizData(ast);
    }

    /*
     * WARNING - void declaration
     */
    private final GraphDiagramData convertAstToGraphvizData(ClassDiagramNode ast) {
        void $this$mapTo$iv$iv;
        Object field;
        Collection collection;
        Object object;
        Map entities = new LinkedHashMap();
        List edges = new ArrayList();
        Map graphAttributes = new LinkedHashMap();
        block5: for (StatementNode statement : ast.getStatements()) {
            Object $this$map$iv;
            StatementNode statementNode = statement;
            if (statementNode instanceof ClassStatementNode) {
                void $this$mapTo$iv$iv2;
                $this$map$iv = ((ClassStatementNode)statement).getMembers();
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void member;
                    MemberNode memberNode = (MemberNode)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertMemberToField((MemberNode)member));
                }
                List fields = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                if (entities.containsKey(((ClassStatementNode)statement).getClassName())) {
                    Object v = entities.get(((ClassStatementNode)statement).getClassName());
                    Intrinsics.checkNotNull(v);
                    ((List)v).addAll(fields);
                    continue;
                }
                entities.put(((ClassStatementNode)statement).getClassName(), fields);
                continue;
            }
            if (statementNode instanceof RelationStatementNode) {
                GraphEdgeData edge = this.convertRelationToEdge((RelationStatementNode)statement);
                edges.add(edge);
                if (!entities.containsKey(((RelationStatementNode)statement).getSourceClass())) {
                    entities.put(((RelationStatementNode)statement).getSourceClass(), (List)new ArrayList());
                }
                if (entities.containsKey(((RelationStatementNode)statement).getTargetClass())) continue;
                entities.put(((RelationStatementNode)statement).getTargetClass(), (List)new ArrayList());
                continue;
            }
            if (statementNode instanceof MemberStatementNode) {
                field = this.convertMemberToField(((MemberStatementNode)statement).getMember());
                if (entities.containsKey(((MemberStatementNode)statement).getClassName())) {
                    Object v = entities.get(((MemberStatementNode)statement).getClassName());
                    Intrinsics.checkNotNull(v);
                    ((List)v).add(field);
                    continue;
                }
                $this$map$iv = entities;
                String $i$f$map = ((MemberStatementNode)statement).getClassName();
                object = new GraphNodeField[]{field};
                object = CollectionsKt.mutableListOf((Object[])object);
                $this$map$iv.put($i$f$map, object);
                continue;
            }
            if (statementNode instanceof ClassAnnotationStatementNode) {
                if (entities.containsKey(((ClassAnnotationStatementNode)statement).getClassName())) {
                    graphAttributes.put(((ClassAnnotationStatementNode)statement).getClassName() + "_change", ((ClassAnnotationStatementNode)statement).getAnnotation());
                    continue;
                }
                entities.put(((ClassAnnotationStatementNode)statement).getClassName(), (List)new ArrayList());
                graphAttributes.put(((ClassAnnotationStatementNode)statement).getClassName() + "_change", ((ClassAnnotationStatementNode)statement).getAnnotation());
                continue;
            }
            if (statementNode instanceof DirectionStatementNode) {
                graphAttributes.put("direction", ((DirectionStatementNode)statement).getDirection().name());
                continue;
            }
            if (!(statementNode instanceof AccessibilityStatementNode)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[((AccessibilityStatementNode)statement).getType().ordinal()]) {
                case 1: {
                    graphAttributes.put("title", ((AccessibilityStatementNode)statement).getValue());
                    continue block5;
                }
                case 2: {
                    graphAttributes.put("description", ((AccessibilityStatementNode)statement).getValue());
                    continue block5;
                }
                case 3: {
                    graphAttributes.put("description", ((AccessibilityStatementNode)statement).getValue());
                    continue block5;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        graphAttributes.put("type", "mermaid_class_diagram");
        Map $this$map$iv = entities;
        boolean $i$f$map = false;
        field = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
            collection = destination$iv$iv;
            boolean bl = false;
            String className = (String)entry.getKey();
            List fields = (List)entry.getValue();
            collection.add(new GraphEntityNodeData(className, fields));
        }
        List entityList = (List)destination$iv$iv;
        return new GraphDiagramData(CollectionsKt.emptyList(), entityList, edges, graphAttributes, GraphGraphType.DIGRAPH);
    }

    private final GraphNodeField convertMemberToField(MemberNode member) {
        String visibilitySymbol = switch (WhenMappings.$EnumSwitchMapping$1[member.getVisibility().ordinal()]) {
            case 1 -> "+";
            case 2 -> "-";
            case 3 -> "#";
            case 4 -> "~";
            default -> throw new NoWhenBranchMatchedException();
        };
        cc.unitmesh.diagram.model.ChangeStatus changeStatus = switch (WhenMappings.$EnumSwitchMapping$2[member.getChangeStatus().ordinal()]) {
            case 1 -> cc.unitmesh.diagram.model.ChangeStatus.ADDED;
            case 2 -> cc.unitmesh.diagram.model.ChangeStatus.REMOVED;
            case 3 -> cc.unitmesh.diagram.model.ChangeStatus.UNCHANGED;
            case 4 -> cc.unitmesh.diagram.model.ChangeStatus.UNCHANGED;
            default -> throw new NoWhenBranchMatchedException();
        };
        Object name = member.isMethod() ? member.getName() + "()" : member.getName();
        String nameWithChangeStatus = switch (WhenMappings.$EnumSwitchMapping$2[member.getChangeStatus().ordinal()]) {
            case 1 -> "+" + (String)name;
            case 2 -> "-" + (String)name;
            case 3 -> "~" + (String)name;
            case 4 -> visibilitySymbol + (String)name;
            default -> throw new NoWhenBranchMatchedException();
        };
        String string = member.getType();
        if (string == null) {
            string = member.isMethod() ? "method" : "field";
        }
        return new GraphNodeField(nameWithChangeStatus, string, false, changeStatus, member.isMethod());
    }

    private final GraphEdgeData convertRelationToEdge(RelationStatementNode relation) {
        String string;
        Map attributes = new LinkedHashMap();
        if (relation.getRelation().getType1() == RelationType.EXTENSION || relation.getRelation().getType2() == RelationType.EXTENSION) {
            attributes.put("arrowhead", "empty");
        } else if (relation.getRelation().getType1() == RelationType.COMPOSITION || relation.getRelation().getType2() == RelationType.COMPOSITION) {
            attributes.put("arrowhead", "diamond");
            attributes.put("style", "filled");
        } else if (relation.getRelation().getType1() == RelationType.AGGREGATION || relation.getRelation().getType2() == RelationType.AGGREGATION) {
            attributes.put("arrowhead", "diamond");
        } else if (relation.getRelation().getType1() == RelationType.DEPENDENCY || relation.getRelation().getType2() == RelationType.DEPENDENCY) {
            attributes.put("style", "dashed");
        }
        if (relation.getRelation().getLineType() == LineType.DOTTED_LINE) {
            attributes.put("style", "dotted");
        }
        if ((string = relation.getRelationLabel()) == null) {
            string = relation.getRelation().getType1() == RelationType.EXTENSION || relation.getRelation().getType2() == RelationType.EXTENSION ? "extends" : (relation.getRelation().getType1() == RelationType.COMPOSITION || relation.getRelation().getType2() == RelationType.COMPOSITION ? "composed of" : (relation.getRelation().getType1() == RelationType.AGGREGATION || relation.getRelation().getType2() == RelationType.AGGREGATION ? "aggregates" : (relation.getRelation().getType1() == RelationType.DEPENDENCY || relation.getRelation().getType2() == RelationType.DEPENDENCY ? "depends on" : null)));
        }
        String label = string;
        Pair pair = relation.getRelation().getType1() == RelationType.EXTENSION || relation.getRelation().getType2() == RelationType.EXTENSION ? TuplesKt.to((Object)relation.getTargetClass(), (Object)relation.getSourceClass()) : TuplesKt.to((Object)relation.getSourceClass(), (Object)relation.getTargetClass());
        String actualSource = (String)pair.component1();
        String actualTarget = (String)pair.component2();
        return new GraphEdgeData(actualSource, actualTarget, label, attributes, GraphvizEdgeType.DIRECTED);
    }

    private final GraphDiagramData createEmptyData() {
        return new GraphDiagramData(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap(), GraphGraphType.DIGRAPH);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[AccessibilityType.values().length];
            try {
                nArray[AccessibilityType.TITLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessibilityType.DESCRIPTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessibilityType.DESCRIPTION_MULTILINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VisibilityType.values().length];
            try {
                nArray[VisibilityType.PUBLIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisibilityType.PRIVATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisibilityType.PROTECTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisibilityType.PACKAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ChangeStatus.values().length];
            try {
                nArray[ChangeStatus.ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeStatus.REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeStatus.MODIFIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChangeStatus.UNCHANGED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

