/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.diagram.editor;

import cc.unitmesh.diagram.editor.GraphvizPreviewFileEditor;
import cc.unitmesh.diagram.idea.DotFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/diagram/editor/GraphvizPreviewFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "<init>", "()V", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "isDotFile", "isMermaidFile", "ext-diagram"})
public final class GraphvizPreviewFileEditorProvider
implements FileEditorProvider {
    @NotNull
    public String getEditorTypeId() {
        return "graphviz-uml-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (Intrinsics.areEqual((Object)file.getFileType(), (Object)DotFileType.INSTANCE) || this.isDotFile(file)) && !this.isMermaidFile(file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new GraphvizPreviewFileEditor(project, file);
    }

    private final boolean isDotFile(VirtualFile file) {
        String string;
        String string2 = file.getExtension();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String extension = string;
        return Intrinsics.areEqual((Object)extension, (Object)"dot") || Intrinsics.areEqual((Object)extension, (Object)"gv") || Intrinsics.areEqual((Object)extension, (Object)"graphviz");
    }

    private final boolean isMermaidFile(VirtualFile file) {
        String string;
        String string2 = file.getExtension();
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String extension = string;
        return Intrinsics.areEqual((Object)extension, (Object)"mmd") || Intrinsics.areEqual((Object)extension, (Object)"mermaid");
    }
}

