/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs.gitignore;

import cc.unitmesh.devti.vcs.gitignore.InvalidGitIgnorePatternException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/devti/vcs/gitignore/PatternConverter;", "", "<init>", "()V", "convertToRegex", "", "gitignorePattern", "compilePattern", "Ljava/util/regex/Pattern;", "escapeSpecialCharacters", "pattern", "handleWildcards", "normalizePathSeparators", "handleDirectoryPatterns", "handleRootPatterns", "core"})
public final class PatternConverter {
    @NotNull
    public static final PatternConverter INSTANCE = new PatternConverter();

    private PatternConverter() {
    }

    @NotNull
    public final String convertToRegex(@NotNull String gitignorePattern) {
        Intrinsics.checkNotNullParameter((Object)gitignorePattern, (String)"gitignorePattern");
        try {
            String pattern = ((Object)StringsKt.trim((CharSequence)gitignorePattern)).toString();
            if (((CharSequence)pattern).length() == 0 || StringsKt.startsWith$default((String)pattern, (String)"#", (boolean)false, (int)2, null)) {
                return "^$";
            }
            if (StringsKt.startsWith$default((String)pattern, (String)"!", (boolean)false, (int)2, null)) {
                String string = pattern.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pattern = string;
            }
            pattern = this.escapeSpecialCharacters(pattern);
            pattern = this.handleWildcards(pattern);
            pattern = this.normalizePathSeparators(pattern);
            pattern = this.handleDirectoryPatterns(pattern);
            pattern = this.handleRootPatterns(pattern);
            return pattern;
        }
        catch (Exception e) {
            throw new InvalidGitIgnorePatternException(gitignorePattern, "Failed to convert pattern to regex", e);
        }
    }

    @NotNull
    public final Pattern compilePattern(@NotNull String gitignorePattern) {
        Pattern pattern;
        Intrinsics.checkNotNullParameter((Object)gitignorePattern, (String)"gitignorePattern");
        String regexPattern = this.convertToRegex(gitignorePattern);
        try {
            pattern = Pattern.compile(regexPattern, 2);
            Intrinsics.checkNotNull((Object)pattern);
        }
        catch (Exception e) {
            throw new InvalidGitIgnorePatternException(gitignorePattern, "Failed to compile regex pattern: " + regexPattern, e);
        }
        return pattern;
    }

    private final String escapeSpecialCharacters(String pattern) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)pattern, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"+", (String)"\\+", (boolean)false, (int)4, null), (String)"^", (String)"\\^", (boolean)false, (int)4, null), (String)"$", (String)"\\$", (boolean)false, (int)4, null), (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null), (String)"[", (String)"\\[", (boolean)false, (int)4, null), (String)"]", (String)"\\]", (boolean)false, (int)4, null), (String)"{", (String)"\\{", (boolean)false, (int)4, null), (String)"}", (String)"\\}", (boolean)false, (int)4, null), (String)"|", (String)"\\|", (boolean)false, (int)4, null);
    }

    private final String handleWildcards(String pattern) {
        String result = pattern;
        result = StringsKt.replace$default((String)result, (String)"**/", (String)"(?:.*/)?", (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)"/**", (String)"(?:/.*)?", (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)"**", (String)".*", (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)"*", (String)"[^/]*", (boolean)false, (int)4, null);
        result = StringsKt.replace$default((String)result, (String)"?", (String)"[^/]", (boolean)false, (int)4, null);
        return result;
    }

    private final String normalizePathSeparators(String pattern) {
        return StringsKt.replace$default((String)pattern, (String)"\\\\", (String)"/", (boolean)false, (int)4, null);
    }

    private final String handleDirectoryPatterns(String pattern) {
        return StringsKt.endsWith$default((String)pattern, (String)"/", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)pattern, (int)1) + "(?:/.*)?$" : pattern + "$";
    }

    private final String handleRootPatterns(String pattern) {
        String string;
        if (StringsKt.startsWith$default((String)pattern, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = pattern.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = "^" + string2;
        } else {
            string = "(?:^|.*/)" + pattern;
        }
        return string;
    }
}

