/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs.gitignore;

import cc.unitmesh.devti.vcs.gitignore.HomeSpunIgnoreRule;
import cc.unitmesh.devti.vcs.gitignore.IgnoreEngine;
import cc.unitmesh.devti.vcs.gitignore.IgnorePatternCache;
import cc.unitmesh.devti.vcs.gitignore.InvalidGitIgnorePatternException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c0\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/vcs/gitignore/HomeSpunIgnoreEngine;", "Lcc/unitmesh/devti/vcs/gitignore/IgnoreEngine;", "<init>", "()V", "rules", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcc/unitmesh/devti/vcs/gitignore/HomeSpunIgnoreRule;", "patternCache", "Lcc/unitmesh/devti/vcs/gitignore/IgnorePatternCache;", "isIgnored", "", "filePath", "", "addRule", "", "pattern", "removeRule", "getRules", "", "clearRules", "loadFromContent", "gitIgnoreContent", "getCacheSize", "", "getRuleCount", "normalizeFilePath", "getStatistics", "", "", "core"})
@SourceDebugExtension(value={"SMAP\nHomeSpunIgnoreEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HomeSpunIgnoreEngine.kt\ncc/unitmesh/devti/vcs/gitignore/HomeSpunIgnoreEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1549#2:117\n1620#2,3:118\n*S KotlinDebug\n*F\n+ 1 HomeSpunIgnoreEngine.kt\ncc/unitmesh/devti/vcs/gitignore/HomeSpunIgnoreEngine\n*L\n49#1:117\n49#1:118,3\n*E\n"})
public final class HomeSpunIgnoreEngine
implements IgnoreEngine {
    @NotNull
    private final CopyOnWriteArrayList<HomeSpunIgnoreRule> rules = new CopyOnWriteArrayList();
    @NotNull
    private final IgnorePatternCache patternCache = new IgnorePatternCache();

    @Override
    public boolean isIgnored(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.rules.isEmpty()) {
            return false;
        }
        String normalizedPath = this.normalizeFilePath(filePath);
        boolean ignored = false;
        Iterator<HomeSpunIgnoreRule> iterator = this.rules.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<HomeSpunIgnoreRule> iterator2 = iterator;
        while (iterator2.hasNext()) {
            HomeSpunIgnoreRule rule = iterator2.next();
            if (!rule.matches(normalizedPath)) continue;
            ignored = !rule.isNegated();
        }
        return ignored;
    }

    @Override
    public void addRule(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            HomeSpunIgnoreRule rule = HomeSpunIgnoreRule.Companion.fromPattern(pattern, this.patternCache);
            this.rules.add(rule);
        }
        catch (InvalidGitIgnorePatternException e) {
            System.err.println("Warning: Skipping invalid gitignore pattern: " + e.getMessage());
        }
    }

    @Override
    public void removeRule(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.rules.removeIf(arg_0 -> HomeSpunIgnoreEngine.removeRule$lambda$1(arg_0 -> HomeSpunIgnoreEngine.removeRule$lambda$0(pattern, arg_0), arg_0));
        this.patternCache.remove(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getRules() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.rules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HomeSpunIgnoreRule homeSpunIgnoreRule = (HomeSpunIgnoreRule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPattern());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void clearRules() {
        this.rules.clear();
        this.patternCache.clear();
    }

    @Override
    public void loadFromContent(@NotNull String gitIgnoreContent) {
        Intrinsics.checkNotNullParameter((Object)gitIgnoreContent, (String)"gitIgnoreContent");
        this.clearRules();
        List lines = StringsKt.lines((CharSequence)gitIgnoreContent);
        for (String line : lines) {
            String trimmedLine = ((Object)StringsKt.trim((CharSequence)line)).toString();
            if (!(((CharSequence)trimmedLine).length() > 0) || StringsKt.startsWith$default((String)trimmedLine, (String)"#", (boolean)false, (int)2, null)) continue;
            this.addRule(trimmedLine);
        }
    }

    public final int getCacheSize() {
        return this.patternCache.size();
    }

    public final int getRuleCount() {
        return this.rules.size();
    }

    private final String normalizeFilePath(String filePath) {
        String normalized = ((Object)StringsKt.trim((CharSequence)filePath)).toString();
        if (StringsKt.startsWith$default((String)(normalized = StringsKt.replace$default((String)normalized, (char)'\\', (char)'/', (boolean)false, (int)4, null)), (String)"/", (boolean)false, (int)2, null)) {
            String string = normalized.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            normalized = string;
        }
        return normalized;
    }

    @NotNull
    public final Map<String, Object> getStatistics() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ruleCount", (Object)this.getRuleCount()), TuplesKt.to((Object)"cacheSize", (Object)this.getCacheSize()), TuplesKt.to((Object)"cachedPatterns", this.patternCache.getCachedPatterns())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final boolean removeRule$lambda$0(String $pattern, HomeSpunIgnoreRule it) {
        return Intrinsics.areEqual((Object)it.getPattern(), (Object)$pattern);
    }

    private static final boolean removeRule$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

