/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs.gitignore;

import cc.unitmesh.devti.vcs.gitignore.GitIgnoreFlagWrapper;
import cc.unitmesh.devti.vcs.gitignore.IgnoreEngineFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0006J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/vcs/gitignore/GitIgnoreUtil;", "", "<init>", "()V", "projectEngines", "", "Lcom/intellij/openapi/project/Project;", "Lcc/unitmesh/devti/vcs/gitignore/GitIgnoreFlagWrapper;", "isIgnored", "", "project", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "", "Ljava/nio/file/Path;", "reloadGitIgnore", "", "getStatistics", "", "getActiveEngineType", "Lcc/unitmesh/devti/vcs/gitignore/IgnoreEngineFactory$EngineType;", "clearCache", "getOrCreateEngine", "loadGitIgnoreContent", "getRelativePath", "normalizeToRelativePath", "core"})
public final class GitIgnoreUtil {
    @NotNull
    public static final GitIgnoreUtil INSTANCE = new GitIgnoreUtil();
    @NotNull
    private static final Map<Project, GitIgnoreFlagWrapper> projectEngines = new LinkedHashMap();

    private GitIgnoreUtil() {
    }

    public final boolean isIgnored(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitIgnoreFlagWrapper engine = this.getOrCreateEngine(project);
        String string = this.getRelativePath(project, file);
        if (string == null) {
            return false;
        }
        String relativePath = string;
        return engine.isIgnored(relativePath);
    }

    public final boolean isIgnored(@NotNull Project project, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        GitIgnoreFlagWrapper engine = this.getOrCreateEngine(project);
        String relativePath = this.normalizeToRelativePath(project, filePath);
        return engine.isIgnored(relativePath);
    }

    public final boolean isIgnored(@NotNull Project project, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.isIgnored(project, ((Object)filePath).toString());
    }

    public final void reloadGitIgnore(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitIgnoreFlagWrapper engine = this.getOrCreateEngine(project);
        String gitIgnoreContent = this.loadGitIgnoreContent(project);
        engine.loadFromContent(gitIgnoreContent);
    }

    @NotNull
    public final Map<String, Object> getStatistics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitIgnoreFlagWrapper engine = this.getOrCreateEngine(project);
        return engine.getStatistics();
    }

    @NotNull
    public final IgnoreEngineFactory.EngineType getActiveEngineType(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitIgnoreFlagWrapper engine = this.getOrCreateEngine(project);
        return engine.getActiveEngineType();
    }

    public final void clearCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        projectEngines.remove(project);
    }

    private final GitIgnoreFlagWrapper getOrCreateEngine(Project project) {
        GitIgnoreFlagWrapper gitIgnoreFlagWrapper = projectEngines.computeIfAbsent(project, arg_0 -> GitIgnoreUtil.getOrCreateEngine$lambda$1(GitIgnoreUtil::getOrCreateEngine$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)gitIgnoreFlagWrapper, (String)"computeIfAbsent(...)");
        return gitIgnoreFlagWrapper;
    }

    private final String loadGitIgnoreContent(Project project) {
        Object object;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return "";
        }
        VirtualFile projectDir = virtualFile;
        VirtualFile virtualFile2 = projectDir.findChild(".gitignore");
        if (virtualFile2 == null) {
            return "";
        }
        VirtualFile gitIgnoreFile = virtualFile2;
        try {
            InputStream inputStream = gitIgnoreFile.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            object = ByteStreamsKt.readBytes((InputStream)inputStream);
            Charset charset = Charsets.UTF_8;
            object = new String((byte[])object, charset);
        }
        catch (Exception e) {
            object = "";
        }
        return object;
    }

    private final String getRelativePath(Project project, VirtualFile file) {
        String string;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile projectDir = virtualFile;
        Path path = projectDir.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path projectPath = path;
        Path path2 = file.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
        Path filePath = path2;
        try {
            string = StringsKt.replace$default((String)((Object)projectPath.relativize(filePath)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    private final String normalizeToRelativePath(Project project, String filePath) {
        String string;
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.toNioPath()) == null) {
            return filePath;
        }
        Object projectDir = object;
        Path path = Path.of(filePath, new String[0]);
        try {
            string = path.isAbsolute() ? StringsKt.replace$default((String)((Object)projectDir.relativize(path)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null) : StringsKt.replace$default((String)filePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        catch (Exception e) {
            string = StringsKt.replace$default((String)filePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        return string;
    }

    private static final GitIgnoreFlagWrapper getOrCreateEngine$lambda$0(Project proj) {
        Intrinsics.checkNotNullParameter((Object)proj, (String)"proj");
        String gitIgnoreContent = INSTANCE.loadGitIgnoreContent(proj);
        return new GitIgnoreFlagWrapper(proj, gitIgnoreContent);
    }

    private static final GitIgnoreFlagWrapper getOrCreateEngine$lambda$1(Function1 $tmp0, Object p0) {
        return (GitIgnoreFlagWrapper)$tmp0.invoke(p0);
    }
}

