/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs.gitignore;

import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingServiceKt;
import cc.unitmesh.devti.vcs.gitignore.BasjesIgnoreEngine;
import cc.unitmesh.devti.vcs.gitignore.HomeSpunIgnoreEngine;
import cc.unitmesh.devti.vcs.gitignore.IgnoreEngine;
import cc.unitmesh.devti.vcs.gitignore.IgnoreEngineFactory;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0001H\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/vcs/gitignore/GitIgnoreFlagWrapper;", "Lcc/unitmesh/devti/vcs/gitignore/IgnoreEngine;", "project", "Lcom/intellij/openapi/project/Project;", "gitIgnoreContent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "homeSpunEngine", "basjesEngine", "getActiveEngine", "getActiveEngineType", "Lcc/unitmesh/devti/vcs/gitignore/IgnoreEngineFactory$EngineType;", "isIgnored", "", "filePath", "addRule", "", "pattern", "removeRule", "getRules", "", "clearRules", "loadFromContent", "getStatistics", "", "", "core"})
public final class GitIgnoreFlagWrapper
implements IgnoreEngine {
    @NotNull
    private final Project project;
    @NotNull
    private final IgnoreEngine homeSpunEngine;
    @NotNull
    private final IgnoreEngine basjesEngine;

    public GitIgnoreFlagWrapper(@NotNull Project project, @NotNull String gitIgnoreContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gitIgnoreContent, (String)"gitIgnoreContent");
        this.project = project;
        this.homeSpunEngine = IgnoreEngineFactory.INSTANCE.createEngine(IgnoreEngineFactory.EngineType.HOMESPUN);
        this.basjesEngine = IgnoreEngineFactory.INSTANCE.createEngine(IgnoreEngineFactory.EngineType.BASJES);
        if (((CharSequence)gitIgnoreContent).length() > 0) {
            this.loadFromContent(gitIgnoreContent);
        }
    }

    public /* synthetic */ GitIgnoreFlagWrapper(Project project, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(project, string);
    }

    private final IgnoreEngine getActiveEngine() {
        return ((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getEnableHomeSpunGitIgnore() ? this.homeSpunEngine : this.basjesEngine;
    }

    @NotNull
    public final IgnoreEngineFactory.EngineType getActiveEngineType() {
        return ((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getEnableHomeSpunGitIgnore() ? IgnoreEngineFactory.EngineType.HOMESPUN : IgnoreEngineFactory.EngineType.BASJES;
    }

    @Override
    public boolean isIgnored(@NotNull String filePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            bl = this.getActiveEngine().isIgnored(filePath);
        }
        catch (Exception e) {
            boolean bl2;
            IgnoreEngine fallbackEngine = ((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(this.project).getState()).getEnableHomeSpunGitIgnore() ? this.basjesEngine : this.homeSpunEngine;
            System.err.println("Warning: Active gitignore engine failed, falling back. Error: " + e.getMessage());
            try {
                bl2 = fallbackEngine.isIgnored(filePath);
            }
            catch (Exception fallbackException) {
                System.err.println("Error: Both gitignore engines failed. Defaulting to not ignored. Error: " + fallbackException.getMessage());
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public void addRule(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            this.homeSpunEngine.addRule(pattern);
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to add rule to homespun engine: " + e.getMessage());
        }
        try {
            this.basjesEngine.addRule(pattern);
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to add rule to basjes engine: " + e.getMessage());
        }
    }

    @Override
    public void removeRule(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            this.homeSpunEngine.removeRule(pattern);
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to remove rule from homespun engine: " + e.getMessage());
        }
        try {
            this.basjesEngine.removeRule(pattern);
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to remove rule from basjes engine: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    public List<String> getRules() {
        return this.getActiveEngine().getRules();
    }

    @Override
    public void clearRules() {
        this.homeSpunEngine.clearRules();
        this.basjesEngine.clearRules();
    }

    @Override
    public void loadFromContent(@NotNull String gitIgnoreContent) {
        Intrinsics.checkNotNullParameter((Object)gitIgnoreContent, (String)"gitIgnoreContent");
        try {
            this.homeSpunEngine.loadFromContent(gitIgnoreContent);
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to load content into homespun engine: " + e.getMessage());
        }
        try {
            this.basjesEngine.loadFromContent(gitIgnoreContent);
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to load content into basjes engine: " + e.getMessage());
        }
    }

    @NotNull
    public final Map<String, Object> getStatistics() {
        String string;
        String string2;
        Map map;
        Map stats = new LinkedHashMap();
        stats.put("activeEngine", this.getActiveEngineType().name());
        try {
            if (this.homeSpunEngine instanceof HomeSpunIgnoreEngine) {
                stats.put("homeSpun", ((HomeSpunIgnoreEngine)this.homeSpunEngine).getStatistics());
            }
        }
        catch (Exception e) {
            map = stats;
            string2 = "homeSpunError";
            String string3 = e.getMessage();
            if (string3 == null) {
                string3 = "Unknown error";
            }
            string = string3;
            map.put(string2, string);
        }
        try {
            if (this.basjesEngine instanceof BasjesIgnoreEngine) {
                stats.put("basjes", ((BasjesIgnoreEngine)this.basjesEngine).getStatistics());
            }
        }
        catch (Exception e) {
            map = stats;
            string2 = "basjesError";
            String string4 = e.getMessage();
            if (string4 == null) {
                string4 = "Unknown error";
            }
            string = string4;
            map.put(string2, string);
        }
        return stats;
    }
}

