/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.vcs.context;

import cc.unitmesh.devti.vcs.context.FilePriority;
import cc.unitmesh.devti.vcs.context.PrioritizedChange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcc/unitmesh/devti/vcs/context/FilePriorityCalculator;", "", "ignoreFilePatterns", "", "Ljava/nio/file/PathMatcher;", "<init>", "(Ljava/util/List;)V", "calculate", "Lcc/unitmesh/devti/vcs/context/PrioritizedChange;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "calculateAndSort", "changes", "shouldIgnore", "", "filePath", "", "adjustPriorityBySize", "Lcc/unitmesh/devti/vcs/context/FilePriority;", "basePriority", "fileSize", "", "getFileExtension", "getFileSize", "revision", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFilePriorityCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePriorityCalculator.kt\ncc/unitmesh/devti/vcs/context/FilePriorityCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1603#2,9:183\n1855#2:192\n1856#2:194\n1612#2:195\n1747#2,3:196\n1747#2,3:199\n1#3:193\n*S KotlinDebug\n*F\n+ 1 FilePriorityCalculator.kt\ncc/unitmesh/devti/vcs/context/FilePriorityCalculator\n*L\n113#1:183,9\n113#1:192\n113#1:194\n113#1:195\n122#1:196,3\n127#1:199,3\n113#1:193\n*E\n"})
public final class FilePriorityCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PathMatcher> ignoreFilePatterns;
    @NotNull
    private static final Set<String> CRITICAL_EXTENSIONS;
    @NotNull
    private static final Set<String> HIGH_EXTENSIONS;
    @NotNull
    private static final Set<String> MEDIUM_EXTENSIONS;
    @NotNull
    private static final Set<String> LOW_EXTENSIONS;
    @NotNull
    private static final Set<String> EXCLUDED_PATTERNS;

    public FilePriorityCalculator(@NotNull List<? extends PathMatcher> ignoreFilePatterns) {
        Intrinsics.checkNotNullParameter(ignoreFilePatterns, (String)"ignoreFilePatterns");
        this.ignoreFilePatterns = ignoreFilePatterns;
    }

    public /* synthetic */ FilePriorityCalculator(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @Nullable
    public final PrioritizedChange calculate(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ContentRevision contentRevision = change.getAfterRevision();
        if (contentRevision == null && (contentRevision = change.getBeforeRevision()) == null) {
            return null;
        }
        ContentRevision revision = contentRevision;
        String string = revision.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        if (this.shouldIgnore(filePath)) {
            return null;
        }
        String fileExtension = this.getFileExtension(filePath);
        long fileSize = this.getFileSize(revision);
        String string2 = fileExtension;
        FilePriority basePriority = CRITICAL_EXTENSIONS.contains(string2) ? FilePriority.CRITICAL : (HIGH_EXTENSIONS.contains(string2) ? FilePriority.HIGH : (MEDIUM_EXTENSIONS.contains(string2) ? FilePriority.MEDIUM : (LOW_EXTENSIONS.contains(string2) ? FilePriority.LOW : FilePriority.MEDIUM)));
        FilePriority adjustedPriority = this.adjustPriorityBySize(basePriority, fileSize);
        return new PrioritizedChange(change, adjustedPriority, filePath, fileSize, fileExtension);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PrioritizedChange> calculateAndSort(@NotNull List<? extends Change> changes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Iterable $this$mapNotNull$iv = changes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PrioritizedChange it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Change it = (Change)element$iv$iv;
            boolean bl2 = false;
            if (this.calculate(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    private final boolean shouldIgnore(String filePath) {
        boolean bl;
        block8: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block7: {
                $this$any$iv = this.ignoreFilePatterns;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PathMatcher it = (PathMatcher)element$iv;
                        boolean bl3 = false;
                        if (!it.matches(Path.of(filePath, new String[0]))) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            $this$any$iv = EXCLUDED_PATTERNS;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String pattern = (String)element$iv;
                    boolean bl4 = false;
                    if (!(StringsKt.contains$default((CharSequence)filePath, (CharSequence)("/" + pattern + "/"), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)filePath, (CharSequence)("\\" + pattern + "\\"), (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final FilePriority adjustPriorityBySize(FilePriority basePriority, long fileSize) {
        if (fileSize > 1000000L) {
            return FilePriority.EXCLUDED;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[basePriority.ordinal()]) {
            case 1 -> {
                if (fileSize > 500000L) {
                    yield FilePriority.HIGH;
                }
                yield FilePriority.CRITICAL;
            }
            case 2 -> {
                if (fileSize > 200000L) {
                    yield FilePriority.MEDIUM;
                }
                yield FilePriority.HIGH;
            }
            case 3 -> {
                if (fileSize > 100000L) {
                    yield FilePriority.LOW;
                }
                yield FilePriority.MEDIUM;
            }
            default -> basePriority;
        };
    }

    private final String getFileExtension(String filePath) {
        String fileName = StringsKt.substringAfterLast$default((String)filePath, (char)'/', null, (int)2, null);
        return StringsKt.contains$default((CharSequence)fileName, (char)'.', (boolean)false, (int)2, null) ? StringsKt.substringAfterLast$default((String)fileName, (char)'.', null, (int)2, null) : fileName;
    }

    private final long getFileSize(ContentRevision revision) {
        long l;
        try {
            VirtualFile virtualFile;
            CurrentContentRevision currentContentRevision = revision instanceof CurrentContentRevision ? (CurrentContentRevision)revision : null;
            VirtualFile virtualFile2 = virtualFile = currentContentRevision != null ? currentContentRevision.getVirtualFile() : null;
            l = virtualFile2 != null ? virtualFile2.getLength() : 0L;
        }
        catch (Exception e) {
            l = 0L;
        }
        return l;
    }

    public FilePriorityCalculator() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"kt", "java", "scala", "groovy", "ts", "tsx", "js", "jsx", "vue", "py", "pyi", "go", "rs", "c", "cpp", "cc", "h", "hpp", "cs", "rb", "php", "swift"};
        CRITICAL_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"yaml", "yml", "toml", "properties", "conf", "config", "gradle", "kts", "xml", "pom", "sql", "graphql", "proto"};
        HIGH_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"md", "adoc", "rst", "txt", "sh", "bash", "zsh", "fish", "Dockerfile", "docker-compose", "Makefile"};
        MEDIUM_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"json", "jsonl", "csv", "tsv", "html", "htm", "css", "scss", "svg", "png", "jpg", "jpeg", "gif", "ico", "lock"};
        LOW_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"node_modules", "target", "build", "dist", "out", ".git", ".svn", ".hg", "vendor", "venv", ".venv"};
        EXCLUDED_PATTERNS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcc/unitmesh/devti/vcs/context/FilePriorityCalculator$Companion;", "", "<init>", "()V", "CRITICAL_EXTENSIONS", "", "", "HIGH_EXTENSIONS", "MEDIUM_EXTENSIONS", "LOW_EXTENSIONS", "EXCLUDED_PATTERNS", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilePriority.values().length];
            try {
                nArray[FilePriority.CRITICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilePriority.HIGH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilePriority.MEDIUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

